/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Equals;
import savilerow.expression.NumberConstant;
import savilerow.model.SymbolTable;

public class GlobalCard
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public GlobalCard(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 3);
        return new GlobalCard(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 3; ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() == 1) continue;
            CmdFlags.println("ERROR: Expected one-dimensional matrix for each argument of gcc constraint: " + this);
            return false;
        }
        if (this.getChild(1).getCategory() > 2) {
            CmdFlags.println("ERROR: Expected no decision variables in second argument of gcc constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(1) instanceof EmptyMatrix && this.getChild(2) instanceof EmptyMatrix) {
            return new BooleanConstant(true);
        }
        if ((this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) && this.getChild(1) instanceof CompoundMatrix && this.getChild(2) instanceof CompoundMatrix) {
            int n;
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            ArrayList<ASTNode> arrayList2 = this.getChild(1).getChildren();
            arrayList2.remove(0);
            ArrayList<ASTNode> arrayList3 = this.getChild(2).getChildren();
            arrayList3.remove(0);
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).isConstant()) continue;
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (!arrayList2.get(n).equals(arrayList.get(i))) continue;
                    arrayList3.set(n, BinOp.makeBinOp("-", arrayList3.get(n), new NumberConstant(1L)));
                }
                arrayList.remove(i);
                --i;
                bl = true;
            }
            if (arrayList.size() == 0) {
                ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
                for (n = 0; n < arrayList3.size(); ++n) {
                    arrayList4.add(new Equals(arrayList3.get(n), new NumberConstant(0L)));
                }
                return new And(arrayList4);
            }
            if (bl) {
                return new GlobalCard(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2), CompoundMatrix.makeCompoundMatrix(arrayList3));
            }
        }
        return this;
    }

    @Override
    public ASTNode normalise() {
        if (this.getChild(0) instanceof CompoundMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            boolean bl = GlobalCard.sortByHashcode(arrayList);
            if (bl) {
                return new GlobalCard(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
            }
        }
        return this;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("gccweak(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("gcc(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(2).toDominion(stringBuilder, false);
        stringBuilder.append("))");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint global_cardinality(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).toFlatzinc(stringBuilder, false);
        stringBuilder.append(")::domain;");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("global_cardinality(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "gcc(" + this.getChild(0) + "," + this.getChild(1) + "," + this.getChild(2) + ")";
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        GlobalCard.toAlternateJSON(this, stringBuilder);
    }

    public static void toAlternateJSON(ASTNode aSTNode, StringBuilder stringBuilder) {
        aSTNode.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"children\": [\n");
        aSTNode.getChild(0).toJSON(stringBuilder);
        stringBuilder.append(",\n");
        ASTNode aSTNode2 = aSTNode.getChild(1);
        ASTNode aSTNode3 = aSTNode.getChild(2);
        int n = aSTNode2.numChildren();
        stringBuilder.append("{\n\"type\": \"pairList\",\n");
        stringBuilder.append("\"symmetricChildren\": true,\n");
        stringBuilder.append("\"children\": [");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("\n{\n\"type\": \"pair\",\n\"symmetricChildren\": false,\n");
            stringBuilder.append("\"children\": [\n");
            aSTNode2.getChild(i).toJSON(stringBuilder);
            stringBuilder.append(",\n");
            aSTNode3.getChild(i).toJSON(stringBuilder);
            stringBuilder.append("]\n}");
            if (i >= n - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}]}");
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return n == 0;
    }
}

