/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.model.Sat;

public class SATLiteral
extends ASTNode {
    public static final long serialVersionUID = 1L;
    private long lit;
    private Sat satModel;

    public SATLiteral(long l, Sat sat) {
        this.lit = l;
        this.satModel = sat;
    }

    @Override
    public String toString() {
        return "SATLiteral(" + String.valueOf(this.lit) + ")";
    }

    public long getLit() {
        return this.lit;
    }

    @Override
    public ASTNode copy() {
        return new SATLiteral(this.lit, this.satModel);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SATLiteral)) {
            return false;
        }
        return ((SATLiteral)object).lit == this.lit;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.lit).hashCode();
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public ASTNode simplify() {
        if (this.lit == this.satModel.getTrue()) {
            return new BooleanConstant(true);
        }
        if (this.lit == -this.satModel.getTrue()) {
            return new BooleanConstant(false);
        }
        return this;
    }

    @Override
    public long directEncode(Sat sat, long l) {
        if (l == 0L) {
            return -this.lit;
        }
        if (l == 1L) {
            return this.lit;
        }
        return -sat.getTrue();
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        if (l == 0L) {
            return -this.lit;
        }
        if (l >= 1L) {
            return sat.getTrue();
        }
        return -sat.getTrue();
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new SATLiteral(-this.lit, this.satModel);
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        sat.addClause(String.valueOf(this.lit));
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        sat.addClause(-l + " " + this.lit);
        sat.addClause(l + " " + -this.lit);
    }
}

