/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.NegativeTable;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Table
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Table(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Table(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of table should be 1-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 2) {
            CmdFlags.println("ERROR: Second argument of table should be 2-dimensional matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ASTNode aSTNode = this.getChild(1);
            if (aSTNode instanceof Identifier) {
                aSTNode = ((Identifier)aSTNode).global_symbols.getConstantMatrix(aSTNode.toString());
            }
            if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                if (this.getChild(0) instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
                arrayList.remove(0);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isConstant()) continue;
                    long l = arrayList.get(i).getValue();
                    arrayList.remove(i);
                    ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                    for (int j = 1; j < aSTNode.numChildren(); ++j) {
                        if (aSTNode.getChild(j).getChild(i + 1).getValue() != l) continue;
                        ArrayList<ASTNode> arrayList3 = aSTNode.getChild(j).getChildren();
                        arrayList3.remove(0);
                        arrayList3.remove(i);
                        arrayList2.add(CompoundMatrix.makeCompoundMatrix(arrayList3));
                    }
                    Table table = new Table(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
                    return table;
                }
            }
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new NegativeTable(this.getChild(0), this.getChild(1));
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.getChild(0).numChildren() <= 3) {
            stringBuilder.append("lighttable(");
        } else {
            stringBuilder.append("table(");
        }
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
            stringBuilder.append("{");
            for (int i = 1; i < arrayList.size(); ++i) {
                ArrayList<ASTNode> arrayList2 = arrayList.get(i).getChildren();
                stringBuilder.append("<");
                for (int j = 1; j < arrayList2.size(); ++j) {
                    arrayList2.get(j).toMinion(stringBuilder, false);
                    if (j >= arrayList2.size() - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(">");
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        } else {
            this.getChild(1).toMinion(stringBuilder, false);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("table(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint table_int(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",[");
        ASTNode aSTNode = this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix ? this.getChild(1) : ((Identifier)this.getChild((int)1)).global_symbols.getConstantMatrix(this.getChild(1).toString());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = 1; j < aSTNode.getChild(i).numChildren(); ++j) {
                aSTNode.getChild(i).getChild(j).toFlatzinc(stringBuilder, false);
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("]);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("table(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            stringBuilder.append("[");
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                ASTNode aSTNode = this.getChild(1).getChild(i);
                stringBuilder.append("| ");
                for (int j = 1; j < aSTNode.numChildren(); ++j) {
                    aSTNode.getChild(j).toMinizinc(stringBuilder, false);
                    if (j >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append("|]");
        } else {
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.toSATHelper2(sat);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.toSATHelper(sat, l, true);
    }

    public void toSATHelper(Sat sat, long l, boolean bl) throws IOException {
        ASTNode aSTNode = this.getChild(1);
        if (aSTNode instanceof Identifier) {
            aSTNode = ((Identifier)this.getChild((int)1)).global_symbols.getConstantMatrix(this.getChild(1).toString());
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(aSTNode.numChildren());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            ASTNode aSTNode2 = aSTNode.getChild(i);
            long l2 = sat.createAuxSATVariable();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.numChildren(); ++j) {
                long l3 = aSTNode2.getChild(j).getValue();
                long l4 = this.getChild(0).getChild(j).directEncode(sat, l3);
                sat.addClause(-l2 + " " + l4);
                arrayList2.add(-l4);
            }
            arrayList2.add(l2);
            sat.addClause(arrayList2);
            arrayList.add(l2);
        }
        if (bl) {
            sat.addClauseReified(arrayList, l);
        } else {
            sat.addClause(arrayList);
        }
    }

    public void toSATHelper2(Sat sat) throws IOException {
        int n;
        ASTNode aSTNode = this.getChild(1);
        if (aSTNode instanceof Identifier) {
            aSTNode = ((Identifier)this.getChild((int)1)).global_symbols.getConstantMatrix(this.getChild(1).toString());
        }
        ArrayList<ASTNode> arrayList = aSTNode.getChildren();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
            ASTNode aSTNode2 = this.getChild(0).getChild(i);
            if (aSTNode2 instanceof Identifier) {
                arrayList2.add(((Identifier)aSTNode2).getDomain());
                continue;
            }
            arrayList2.add(new BooleanDomain());
        }
        ArrayList<Long> arrayList3 = new ArrayList<Long>(arrayList.size());
        for (n = 1; n < arrayList.size(); ++n) {
            boolean bl = true;
            for (int i = 1; i < this.getChild(0).numChildren(); ++i) {
                if (((ASTNode)arrayList2.get(i - 1)).containsValue(arrayList.get(n).getChild(i).getValue())) continue;
                bl = false;
                break;
            }
            if (!bl) {
                arrayList.set(n, arrayList.get(arrayList.size() - 1));
                arrayList.remove(arrayList.size() - 1);
                --n;
                continue;
            }
            arrayList3.add(sat.createAuxSATVariable());
        }
        for (n = 1; n < this.getChild(0).numChildren(); ++n) {
            int n2;
            ASTNode aSTNode3 = this.getChild(0).getChild(n);
            ArrayList<Long> arrayList4 = ((ASTNode)arrayList2.get(n - 1)).getValueSet();
            ArrayList<Intpair> arrayList5 = ((ASTNode)arrayList2.get(n - 1)).getIntervalSet();
            ArrayList arrayList6 = new ArrayList(arrayList4.size());
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                arrayList6.add(new ArrayList());
            }
            for (n2 = 1; n2 < arrayList.size(); ++n2) {
                long l = arrayList.get(n2).getChild(n).getValue();
                int n3 = -1;
                int n4 = 0;
                for (int i = 0; i < arrayList5.size(); ++i) {
                    Intpair intpair = arrayList5.get(i);
                    if (l >= intpair.lower && l <= intpair.upper) {
                        n3 = (int)(l - intpair.lower + (long)n4);
                        break;
                    }
                    n4 = (int)((long)n4 + (intpair.upper - intpair.lower + 1L));
                }
                if (n3 == -1) {
                    sat.addClause(String.valueOf(-arrayList3.get(n2 - 1).longValue()));
                    continue;
                }
                assert (arrayList4.get(n3) == l);
                ((ArrayList)arrayList6.get(n3)).add(arrayList3.get(n2 - 1));
            }
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                sat.addClauseReified((ArrayList)arrayList6.get(n2), aSTNode3.directEncode(sat, arrayList4.get(n2)));
            }
        }
        sat.addClause(arrayList3);
    }
}

