/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Element;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.Intpair;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.expression.SATLiteral;
import savilerow.expression.SafeElement;
import savilerow.model.Sat;

public class ToVariable
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ToVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ToVariable(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        if (this.getChild(0).isRelation()) {
            return "(" + this.getChild(0) + "<-tv>" + this.getChild(1) + ")";
        }
        return "(" + this.getChild(0) + "=tv=" + this.getChild(1) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof BooleanConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isRelation()) {
            return new Iff(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0) instanceof NumberConstant || this.getChild(0) instanceof Identifier && this.getChild(0).isNumerical()) {
            return new Equals(this.getChild(0), this.getChild(1));
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(false);
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(1).isRelation();
    }

    @Override
    public ASTNode negation() {
        return new ToVariable(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            stringBuilder.append("reify(");
            this.getChild(0).toMinion(stringBuilder, true);
            stringBuilder.append(", ");
            this.getChild(1).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            this.getChild(0).toMinionWithAuxVar(stringBuilder, this.getChild(1));
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0).isRelation()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("reify(");
            this.getChild(0).toDominion(stringBuilder, true);
            stringBuilder.append(", ");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            this.getChild(0).toDominionWithAuxVar(stringBuilder, this.getChild(1));
        }
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0).isRelation()) {
            assert (!(this.getChild(0) instanceof ToVariable));
            if (this.getChild(0) instanceof And || this.getChild(0) instanceof Or) {
                this.getChild(0).toFlatzincWithAuxVar(stringBuilder, this.getChild(1));
            } else {
                StringBuilder stringBuilder2 = new StringBuilder();
                this.getChild(0).toFlatzinc(stringBuilder2, true);
                StringBuilder stringBuilder3 = new StringBuilder();
                this.getChild(1).toFlatzinc(stringBuilder3, true);
                int n = stringBuilder2.lastIndexOf(");");
                stringBuilder2.replace(n, n + 2, "," + stringBuilder3.toString() + ");");
                int n2 = stringBuilder2.indexOf("(");
                stringBuilder2.replace(n2, n2 + 1, "_reif(");
                stringBuilder.append((CharSequence)stringBuilder2);
            }
        } else {
            this.getChild(0).toFlatzincWithAuxVar(stringBuilder, this.getChild(1));
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("( ");
        if (this.getChild(0).isRelation()) {
            this.getChild(0).toMinizinc(stringBuilder, true);
            stringBuilder.append(" <-> ");
            this.getChild(1).toMinizinc(stringBuilder, true);
        } else {
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(" == ");
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append(" )");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant() && (this.getChild(0) instanceof SATLiteral || this.getChild(0) instanceof Identifier)) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            if (this.getChild(1) instanceof BooleanConstant) {
                if (this.getChild(1).getValue() == 1L) {
                    this.getChild(0).toSAT(sat);
                } else {
                    assert (this.getChild(1).getValue() == 0L);
                    new Negate(this.getChild(0)).toSAT(sat);
                }
            } else {
                long l;
                if (this.getChild(1) instanceof SATLiteral) {
                    l = ((SATLiteral)this.getChild(1)).getLit();
                } else {
                    if (!this.getChild(1).isRelation()) {
                        System.err.println("Weird expression in output: " + this);
                    }
                    l = ((Identifier)this.getChild(1)).directEncode(sat, 1L);
                }
                this.getChild(0).toSATWithAuxVar(sat, l);
            }
        } else {
            this.getChild(0).toSATWithAuxVar(sat, this.getChild(1));
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (this.getChild(0).isRelation() && !(this.getChild(0) instanceof SafeElement) && !(this.getChild(0) instanceof Element)) {
            long l2;
            long l3 = sat.createAuxSATVariable();
            this.getChild(0).toSATWithAuxVar(sat, l3);
            if (this.getChild(1) instanceof SATLiteral) {
                l2 = ((SATLiteral)this.getChild(1)).getLit();
            } else {
                if (!this.getChild(1).isRelation()) {
                    System.err.println("Weird expression in output: " + this);
                }
                l2 = ((Identifier)this.getChild(1)).directEncode(sat, 1L);
            }
            sat.addClause(-l + " " + -l3 + " " + l2);
            sat.addClause(-l + " " + l3 + " " + -l2);
            sat.addClause(l + " " + -l3 + " " + -l2);
            sat.addClause(l + " " + l3 + " " + l2);
        } else {
            CmdFlags.errorExit("Missing part of toSATWithAuxVar(long) method on type ToVariable.");
        }
    }
}

