/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Times;
import savilerow.expression.UnaryMinus;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class WeightedSum
extends ASTNode {
    public static final long serialVersionUID = 1L;
    long[] weights;

    public WeightedSum(ArrayList<ASTNode> arrayList) {
        super(arrayList);
        this.weights = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.weights[i] = 1L;
        }
    }

    public WeightedSum(ArrayList<ASTNode> arrayList, ArrayList<Long> arrayList2) {
        super(arrayList);
        this.weights = new long[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.weights[i] = arrayList2.get(i);
        }
        assert (arrayList.size() == arrayList2.size());
    }

    public WeightedSum(ASTNode[] aSTNodeArray, long[] lArray) {
        super(aSTNodeArray);
        this.weights = lArray;
        assert (aSTNodeArray.length == lArray.length);
    }

    public WeightedSum(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
        this.weights = new long[2];
        this.weights[0] = 1L;
        this.weights[1] = 1L;
    }

    public WeightedSum(ASTNode aSTNode, ASTNode aSTNode2, long l, long l2) {
        super(aSTNode, aSTNode2);
        this.weights = new long[2];
        this.weights[0] = l;
        this.weights[1] = l2;
    }

    public ArrayList<Long> getWeights() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.weights.length);
        for (int i = 0; i < this.weights.length; ++i) {
            arrayList.add(this.weights[i]);
        }
        return arrayList;
    }

    public long getWeight(int n) {
        return this.weights[n];
    }

    @Override
    public ASTNode copy() {
        long[] lArray = new long[this.weights.length];
        for (int i = 0; i < this.weights.length; ++i) {
            lArray[i] = this.weights[i];
        }
        return new WeightedSum(this.getChildrenArray(), lArray);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WeightedSum)) {
            return false;
        }
        WeightedSum weightedSum = (WeightedSum)object;
        if (!weightedSum.getChildren().equals(this.getChildren())) {
            return false;
        }
        return Arrays.equals(weightedSum.weights, this.weights);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n = Arrays.hashCode(this.weights);
            this.hashCache = n = n * 13 + Arrays.hashCode(this.children);
            return n;
        }
        return this.hashCache;
    }

    @Override
    public ASTNode simplify() {
        int n;
        int n2;
        ArrayList<ASTNode> arrayList = this.getChildren();
        ArrayList<Long> arrayList2 = this.getWeights();
        boolean bl = false;
        assert (arrayList.size() == arrayList2.size());
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (arrayList.get(n2) instanceof WeightedSum) {
                ASTNode aSTNode = arrayList.remove(n2);
                long l = arrayList2.remove(n2);
                --n2;
                arrayList.addAll(aSTNode.getChildren());
                ArrayList<Long> arrayList3 = ((WeightedSum)aSTNode).getWeights();
                for (int i = 0; i < arrayList3.size(); ++i) {
                    arrayList2.add(arrayList3.get(i) * l);
                }
                bl = true;
                continue;
            }
            if (!(arrayList.get(n2) instanceof UnaryMinus)) continue;
            bl = true;
            arrayList.set(n2, arrayList.get(n2).getChild(0));
            arrayList2.set(n2, -arrayList2.get(n2).longValue());
        }
        assert (arrayList.size() == arrayList2.size());
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).isConstant()) continue;
            n2 = (int)((long)n2 + arrayList.get(i).getValue() * arrayList2.get(i));
            arrayList.remove(i);
            arrayList2.remove(i);
            --i;
            ++n3;
        }
        if (arrayList.size() == 0) {
            return new NumberConstant(n2);
        }
        assert (arrayList.size() == arrayList2.size());
        if (n2 != 0) {
            arrayList.add(new NumberConstant(n2));
            arrayList2.add(1L);
            assert (arrayList.size() == arrayList2.size());
        }
        if (n3 > 1 || n3 == 1 && n2 == 0) {
            bl = true;
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList4.add(arrayList.get(n).hashCode());
        }
        for (n = 1; n < arrayList.size(); ++n) {
            for (int i = n - 1; i >= 0 && (Integer)arrayList4.get(i + 1) < (Integer)arrayList4.get(i); --i) {
                ASTNode aSTNode = arrayList.get(i + 1);
                arrayList.set(i + 1, arrayList.get(i));
                arrayList.set(i, aSTNode);
                Long l = arrayList2.get(i + 1);
                arrayList2.set(i + 1, arrayList2.get(i));
                arrayList2.set(i, l);
                int n4 = (Integer)arrayList4.get(i + 1);
                arrayList4.set(i + 1, (Integer)arrayList4.get(i));
                arrayList4.set(i, n4);
            }
        }
        for (n = 0; n < arrayList.size() - 1; ++n) {
            if (!arrayList.get(n).equals(arrayList.get(n + 1))) continue;
            bl = true;
            arrayList.remove(n + 1);
            arrayList2.set(n, arrayList2.get(n) + arrayList2.remove(n + 1));
            --n;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (arrayList2.get(n) != 0L) continue;
            bl = true;
            arrayList2.remove(n);
            arrayList.remove(n);
            --n;
        }
        if (arrayList.size() == 0) {
            return new NumberConstant(0L);
        }
        if (arrayList.size() == 1 && arrayList2.get(0) == 1L) {
            return arrayList.get(0);
        }
        if (arrayList.size() == 1 && arrayList2.get(0) == -1L) {
            return new UnaryMinus(arrayList.get(0));
        }
        if (bl) {
            return new WeightedSum(arrayList, arrayList2);
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() <= 0) continue;
            CmdFlags.println("ERROR: Unexpected matrix in weighted sum: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        int n;
        ArrayList<ASTNode> arrayList = this.getChildren();
        ArrayList<Long> arrayList2 = this.getWeights();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList3.add(arrayList.get(n).hashCode());
        }
        n = 0;
        for (int i = 1; i < arrayList.size(); ++i) {
            for (int j = i - 1; j >= 0 && (Integer)arrayList3.get(j + 1) < (Integer)arrayList3.get(j); --j) {
                ASTNode aSTNode = arrayList.get(j + 1);
                arrayList.set(j + 1, arrayList.get(j));
                arrayList.set(j, aSTNode);
                Long l = arrayList2.get(j + 1);
                arrayList2.set(j + 1, arrayList2.get(j));
                arrayList2.set(j, l);
                int n2 = (Integer)arrayList3.get(j + 1);
                arrayList3.set(j + 1, (Integer)arrayList3.get(j));
                arrayList3.set(j, n2);
                n = 1;
            }
        }
        if (n != 0) {
            return new WeightedSum(arrayList, arrayList2);
        }
        return this;
    }

    public boolean isCommutative() {
        return true;
    }

    public boolean isAssociative() {
        return true;
    }

    @Override
    public String toString() {
        String string = "(";
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).isConstant()) {
                long l = this.weights[i] * this.getChild(i).getValue();
                if (l >= 0L && i > 0) {
                    string = string + " + ";
                }
                string = string + l;
                continue;
            }
            if (this.weights[i] >= 0L && i > 0) {
                string = string + " + ";
            }
            if (this.weights[i] != 1L) {
                string = string + this.weights[i] + "*";
            }
            string = string + this.getChild(i);
        }
        string = string + ")";
        return string;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return !(this.getParent() instanceof LessEqual);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public Intpair getBounds() {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i = 0; i < this.weights.length; ++i) {
            Intpair intpair = this.getChild(i).getBounds();
            if (this.weights[i] > 0L) {
                bigInteger = bigInteger.add(BigInteger.valueOf(intpair.lower).multiply(BigInteger.valueOf(this.weights[i])));
                bigInteger2 = bigInteger2.add(BigInteger.valueOf(intpair.upper).multiply(BigInteger.valueOf(this.weights[i])));
                continue;
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(intpair.upper).multiply(BigInteger.valueOf(this.weights[i])));
            bigInteger2 = bigInteger2.add(BigInteger.valueOf(intpair.lower).multiply(BigInteger.valueOf(this.weights[i])));
        }
        return this.lookupBounds(new Intpair(Intpair.BigIntegerToLong(bigInteger), Intpair.BigIntegerToLong(bigInteger2)));
    }

    @Override
    public PairASTNode getBoundsAST() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.weights.length; ++i) {
            PairASTNode pairASTNode = this.getChild(i).getBoundsAST();
            if (this.weights[i] > 0L) {
                arrayList.add(pairASTNode.e1);
                arrayList2.add(pairASTNode.e2);
                continue;
            }
            arrayList.add(pairASTNode.e2);
            arrayList2.add(pairASTNode.e1);
        }
        return new PairASTNode(new WeightedSum(arrayList, this.getWeights()), new WeightedSum(arrayList2, this.getWeights()));
    }

    @Override
    public long getValue() {
        long l = 0L;
        for (int i = 0; i < this.numChildren(); ++i) {
            assert (this.getChild(i).isConstant());
            l += this.getChild(i).getValue() * this.weights[i];
        }
        return l;
    }

    public Pair<ASTNode, ASTNode> retrieveConstant() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof NumberConstant)) continue;
            ArrayList<ASTNode> arrayList = this.getChildren();
            ArrayList<Long> arrayList2 = this.getWeights();
            ASTNode aSTNode = arrayList.remove(i);
            Long l = arrayList2.remove(i);
            aSTNode = new NumberConstant(aSTNode.getValue() * l);
            return new Pair<ASTNode, ASTNode>(aSTNode, new WeightedSum(arrayList, arrayList2));
        }
        return null;
    }

    public void toMinionLeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        int n;
        boolean bl = true;
        for (n = 0; n < this.weights.length; ++n) {
            if (this.weights[n] == 1L) continue;
            bl = false;
            break;
        }
        if (bl) {
            stringBuilder.append("sumleq([");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(stringBuilder, false);
                if (n >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("weightedsumleq([");
            for (n = 0; n < this.weights.length; ++n) {
                stringBuilder.append(this.weights[n]);
                if (n >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(stringBuilder, false);
                if (n >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toMinion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    public void toMinionGeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        int n;
        boolean bl = true;
        for (n = 0; n < this.weights.length; ++n) {
            if (this.weights[n] == 1L) continue;
            bl = false;
            break;
        }
        if (bl) {
            stringBuilder.append("sumgeq([");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(stringBuilder, false);
                if (n >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("weightedsumgeq([");
            for (n = 0; n < this.weights.length; ++n) {
                stringBuilder.append(this.weights[n]);
                if (n >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toMinion(stringBuilder, false);
                if (n >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toMinion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    public boolean isAll1Weights() {
        boolean bl = true;
        for (int i = 0; i < this.weights.length; ++i) {
            if (this.weights[i] == 1L) continue;
            bl = false;
            break;
        }
        return bl;
    }

    String mappertype() {
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.weights.length; ++i) {
            long l = this.weights[i];
            if (l != -1L && l != 1L) {
                bl2 = false;
            }
            if (l >= 0L) continue;
            bl = false;
        }
        if (bl2) {
            return "signmult";
        }
        if (bl) {
            return "posmult";
        }
        return "mult";
    }

    public void toDominionLeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        this.toDominionOp(stringBuilder, aSTNode, "sumleq");
    }

    public void toDominionGeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        this.toDominionOp(stringBuilder, aSTNode, "sumgeq");
    }

    public void toDominionOp(StringBuilder stringBuilder, ASTNode aSTNode, String string) {
        if (this.isAll1Weights()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append(string + "([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, false);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            String string2 = this.mappertype();
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append(string + "([");
            for (int i = 0; i < this.weights.length; ++i) {
                stringBuilder.append(string2);
                stringBuilder.append("(");
                this.getChild(i).toDominion(stringBuilder, false);
                stringBuilder.append("," + this.weights[i] + ")");
                if (i >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        if (this.numChildren() > 1) {
            stringBuilder.append("Sum([");
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.weights[i] != 1L) {
                stringBuilder.append("Product(" + this.weights[i] + ",");
            }
            this.getChild(i).toDominionParam(stringBuilder);
            if (this.weights[i] != 1L) {
                stringBuilder.append(")");
            }
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        if (this.numChildren() > 1) {
            stringBuilder.append("])");
        }
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        if (this.isAll1Weights()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("sum([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, false);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            String string = this.mappertype();
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("sum([");
            for (int i = 0; i < this.weights.length; ++i) {
                stringBuilder.append(string);
                stringBuilder.append("(");
                this.getChild(i).toDominion(stringBuilder, false);
                stringBuilder.append("," + this.weights[i] + ")");
                if (i >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toDominion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    public void toFlatzincLeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        int n;
        stringBuilder.append("constraint int_lin_le([");
        for (n = 0; n < this.weights.length; ++n) {
            stringBuilder.append(this.weights[n]);
            stringBuilder.append(",");
        }
        stringBuilder.append("-1],[");
        for (n = 0; n < this.numChildren(); ++n) {
            this.getChild(n).toFlatzinc(stringBuilder, false);
            stringBuilder.append(",");
        }
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append("],0);");
    }

    public void toFlatzincGeq(StringBuilder stringBuilder, ASTNode aSTNode) {
        int n;
        stringBuilder.append("constraint int_lin_le([");
        for (n = 0; n < this.weights.length; ++n) {
            stringBuilder.append(-this.weights[n]);
            stringBuilder.append(",");
        }
        stringBuilder.append("1],[");
        for (n = 0; n < this.numChildren(); ++n) {
            this.getChild(n).toFlatzinc(stringBuilder, false);
            stringBuilder.append(",");
        }
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append("],0);");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        if (!aSTNode.isConstant()) {
            int n;
            stringBuilder.append("constraint int_lin_eq([");
            for (n = 0; n < this.weights.length; ++n) {
                stringBuilder.append(this.weights[n]);
                stringBuilder.append(",");
            }
            stringBuilder.append("-1],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toFlatzinc(stringBuilder, false);
                stringBuilder.append(",");
            }
            aSTNode.toFlatzinc(stringBuilder, false);
            stringBuilder.append("],0);");
        } else {
            int n;
            stringBuilder.append("constraint int_lin_eq([");
            for (n = 0; n < this.weights.length; ++n) {
                stringBuilder.append(this.weights[n]);
                if (n >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],[");
            for (n = 0; n < this.numChildren(); ++n) {
                this.getChild(n).toFlatzinc(stringBuilder, false);
                if (n >= this.weights.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("],");
            aSTNode.toFlatzinc(stringBuilder, false);
            stringBuilder.append(");");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append("(");
            if (this.weights[i] != 1L) {
                stringBuilder.append(this.weights[i]);
                stringBuilder.append("*");
            }
            this.getChild(i).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append("+");
        }
        stringBuilder.append(")");
    }

    public void orderEncodingLeq(Sat sat, long[] lArray, long l, long l2) throws IOException {
        long[] lArray2 = new long[this.numChildren()];
        Intpair[] intpairArray = new Intpair[this.numChildren()];
        for (int i = 0; i < this.numChildren(); ++i) {
            intpairArray[i] = this.getChild(i).getBounds();
            if (lArray[i] > 0L) {
                intpairArray[i].lower = lArray[i] * intpairArray[i].lower;
                intpairArray[i].upper = lArray[i] * intpairArray[i].upper;
                continue;
            }
            long l3 = lArray[i] * intpairArray[i].lower;
            intpairArray[i].lower = lArray[i] * intpairArray[i].upper;
            intpairArray[i].upper = l3;
        }
        this.orderEncodingLeqHelper(sat, lArray, l, intpairArray, lArray2, 0, l2);
    }

    public void orderEncodingLeqHelper(Sat sat, long[] lArray, long l, Intpair[] intpairArray, long[] lArray2, int n, long l2) throws IOException {
        if (n == this.numChildren()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (l2 != 0L) {
                arrayList.add(l2);
            }
            boolean bl = false;
            for (int i = 0; i < this.numChildren(); ++i) {
                long l3 = lArray[i] > 0L ? this.getChild(i).orderEncode(sat, (long)Math.floor((double)lArray2[i] / (double)lArray[i])) : -this.getChild(i).orderEncode(sat, (long)Math.ceil((double)lArray2[i] / (double)lArray[i]) - 1L);
                if (l3 == sat.getTrue()) {
                    bl = true;
                    break;
                }
                if (l3 == -sat.getTrue()) continue;
                arrayList.add(l3);
            }
            if (!bl) {
                sat.addClause(arrayList);
            }
        } else if (n == this.numChildren() - 1) {
            long l4 = 0L;
            for (int i = 0; i < this.numChildren() - 1; ++i) {
                l4 += lArray2[i];
            }
            long l5 = l - (long)this.numChildren() + 1L - l4;
            if (l5 <= intpairArray[n].upper && l5 >= intpairArray[n].lower - 1L) {
                lArray2[n] = l5;
                this.orderEncodingLeqHelper(sat, lArray, l, intpairArray, lArray2, n + 1, l2);
            }
        } else {
            long l6 = intpairArray[n].lower - 1L;
            while (l6 <= intpairArray[n].upper) {
                lArray2[n] = l6++;
                this.orderEncodingLeqHelper(sat, lArray, l, intpairArray, lArray2, n + 1, l2);
            }
        }
    }

    public void toSATLeq(Sat sat, long l) throws IOException {
        long[] lArray = new long[this.numChildren()];
        for (int i = 0; i < this.numChildren(); ++i) {
            lArray[i] = this.weights[i];
        }
        this.orderEncodingLeq(sat, lArray, l, 0L);
    }

    public void toSATGeq(Sat sat, long l) throws IOException {
        long[] lArray = new long[this.numChildren()];
        for (int i = 0; i < this.numChildren(); ++i) {
            lArray[i] = -this.weights[i];
        }
        this.orderEncodingLeq(sat, lArray, -l, 0L);
    }

    public void toSATLeqWithAuxVar(Sat sat, long l, long l2) throws IOException {
        int n;
        long[] lArray = new long[this.numChildren()];
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, l, -l2);
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = -this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, -(l + 1L), l2);
    }

    public void toSATGeqWithAuxVar(Sat sat, long l, long l2) throws IOException {
        int n;
        long[] lArray = new long[this.numChildren()];
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = -this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, -l, -l2);
        for (n = 0; n < this.numChildren(); ++n) {
            lArray[n] = this.weights[n];
        }
        this.orderEncodingLeq(sat, lArray, l - 1L, l2);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        assert (CmdFlags.getSatAlt());
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.func(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return this.weights[0] * l + this.weights[1] * l2;
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        if (this.getParent() != null && this.getParent().canChildBeConvertedToDifference(this.getChildNo()) && this.isValidDifference()) {
            this.toJSONAsDifference(stringBuilder);
            return;
        }
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"children\": [");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append("\n");
            NumberConstant numberConstant = new NumberConstant(this.weights[i]);
            Times times = new Times(numberConstant, this.getChild(i));
            times.toJSON(stringBuilder);
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }

    public boolean isValidDifference() {
        long l = Math.abs(this.weights[0]);
        for (int i = 1; i < this.numChildren(); ++i) {
            if (l == Math.abs(this.weights[i])) continue;
            return false;
        }
        return true;
    }

    public void toJSONAsDifference(StringBuilder stringBuilder) {
        String string = "{\n\"type\": \"Difference\",\n\"symmetricChildren\": true,\n\"children\": [";
        ArrayList<ASTNode> arrayList = this.collectNodesOfSign(true);
        ArrayList<Long> arrayList2 = this.makeFilledList(arrayList.size(), Math.abs(this.weights[0]));
        WeightedSum weightedSum = new WeightedSum(arrayList, arrayList2);
        arrayList = this.collectNodesOfSign(false);
        arrayList2 = this.makeFilledList(arrayList.size(), Math.abs(this.weights[0]));
        WeightedSum weightedSum2 = new WeightedSum(arrayList, arrayList2);
        stringBuilder.append(string);
        stringBuilder.append("\n");
        weightedSum.toJSON(stringBuilder);
        stringBuilder.append(",\n");
        weightedSum2.toJSON(stringBuilder);
        stringBuilder.append("]\n}");
    }

    public ArrayList<ASTNode> collectNodesOfSign(boolean bl) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if ((!bl || this.weights[i] <= 0L) && (bl || this.weights[i] >= 0L)) continue;
            arrayList.add(this.getChild(i));
        }
        return arrayList;
    }

    public ArrayList<Long> makeFilledList(int n, long l) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(l);
        }
        return arrayList;
    }
}

