/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import savilerow.ACCSE;
import savilerow.ACCSEActiveSum;
import savilerow.CSE;
import savilerow.CSEActive;
import savilerow.CSEClassIdentical;
import savilerow.CSETopLevel;
import savilerow.CmdFlags;
import savilerow.ICSEProduct;
import savilerow.ICSESum;
import savilerow.Pair;
import savilerow.RemoveRedundantVars;
import savilerow.SymmetryBreaker;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Dim;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Find;
import savilerow.expression.ForallExpression;
import savilerow.expression.Given;
import savilerow.expression.HoleyMatrixDomain;
import savilerow.expression.Identifier;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Minimising;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Solution;
import savilerow.expression.ToVariable;
import savilerow.expression.Top;
import savilerow.expression.Where;
import savilerow.model.FilteredDomainStore;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.model.categoryentry;
import savilerow.solver.GecodeSolver;
import savilerow.solver.LingelingSATSolver;
import savilerow.solver.MinionSolver;
import savilerow.solver.MinisatSATSolver;
import savilerow.solver.SATSolver;
import savilerow.solver.Stats;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformAbsReify;
import savilerow.treetransformer.TransformAlldiffExcept;
import savilerow.treetransformer.TransformAlldiffGCCSum;
import savilerow.treetransformer.TransformAlldiffToAtmost;
import savilerow.treetransformer.TransformBoolEq;
import savilerow.treetransformer.TransformBreakupSum;
import savilerow.treetransformer.TransformBreakupSum2;
import savilerow.treetransformer.TransformCollectAlldiff;
import savilerow.treetransformer.TransformCollectBool;
import savilerow.treetransformer.TransformCollectGCC;
import savilerow.treetransformer.TransformCollectSATDirect;
import savilerow.treetransformer.TransformConstMatrixClass;
import savilerow.treetransformer.TransformDeMorgans;
import savilerow.treetransformer.TransformDecomposeLex;
import savilerow.treetransformer.TransformDecomposeLex2;
import savilerow.treetransformer.TransformDecomposeMinMax;
import savilerow.treetransformer.TransformDecomposeNegativeTable;
import savilerow.treetransformer.TransformDistributeLogical;
import savilerow.treetransformer.TransformElementForSAT2;
import savilerow.treetransformer.TransformEqual;
import savilerow.treetransformer.TransformEqualClass;
import savilerow.treetransformer.TransformEqualConst;
import savilerow.treetransformer.TransformEqualConstClass;
import savilerow.treetransformer.TransformFactorLogical;
import savilerow.treetransformer.TransformFactorOutSum;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformForBoundVars;
import savilerow.treetransformer.TransformForallAndToAndForall;
import savilerow.treetransformer.TransformGCAssignClique;
import savilerow.treetransformer.TransformGCCSum;
import savilerow.treetransformer.TransformGCCToSums;
import savilerow.treetransformer.TransformHoleyMatrixToAtoms;
import savilerow.treetransformer.TransformImplicationOr;
import savilerow.treetransformer.TransformLogicToSum;
import savilerow.treetransformer.TransformMakeSafe;
import savilerow.treetransformer.TransformMappingToTable;
import savilerow.treetransformer.TransformMatrixDeref;
import savilerow.treetransformer.TransformMatrixDerefClass;
import savilerow.treetransformer.TransformMatrixIndexedMatrix;
import savilerow.treetransformer.TransformMatrixIndices;
import savilerow.treetransformer.TransformMatrixIndicesClass;
import savilerow.treetransformer.TransformMatrixToAtoms;
import savilerow.treetransformer.TransformMultiplyOutSum;
import savilerow.treetransformer.TransformNormalise;
import savilerow.treetransformer.TransformOccurrence;
import savilerow.treetransformer.TransformOccurrenceToSum;
import savilerow.treetransformer.TransformProductToMult;
import savilerow.treetransformer.TransformProductToMultInQSum;
import savilerow.treetransformer.TransformQuantifiedExpression;
import savilerow.treetransformer.TransformReifyAlldiff;
import savilerow.treetransformer.TransformReifyMin;
import savilerow.treetransformer.TransformReverseDeMorgans;
import savilerow.treetransformer.TransformSATEncoding;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TransformSortWeightedSum2;
import savilerow.treetransformer.TransformSubInConstantMatrices;
import savilerow.treetransformer.TransformSumEq;
import savilerow.treetransformer.TransformSumEqToSum;
import savilerow.treetransformer.TransformSumEqualSum;
import savilerow.treetransformer.TransformSumForSAT;
import savilerow.treetransformer.TransformSumLeq;
import savilerow.treetransformer.TransformSumLess;
import savilerow.treetransformer.TransformSumToShift;
import savilerow.treetransformer.TransformTimes;
import savilerow.treetransformer.TransformToFlat;
import savilerow.treetransformer.TransformToFlatBubble;
import savilerow.treetransformer.TransformToFlatClass;
import savilerow.treetransformer.TransformToFlatGecode;
import savilerow.treetransformer.TransformWSumToSum;
import savilerow.treetransformer.TransformWeightedSumForSAT;
import savilerow.treetransformer.TreeTransformer;
import savilerow.treetransformer.TreeTransformerBottomUp;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;
import savilerow.treetransformer.TreeTransformerTopdown;

public class ModelContainer {
    public Model m;
    public ArrayList<ASTNode> parameters;

    public ModelContainer(Model model, ArrayList<ASTNode> arrayList) {
        this.m = model;
        this.parameters = arrayList;
    }

    public void process() {
        this.processPreamble();
        if (CmdFlags.getClasstrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
                CmdFlags.currentModel = this.m;
            }
            this.instancePreFlattening2(false);
            if (CmdFlags.getMode() == 3) {
                this.branchingInstanceFlattening();
            } else {
                this.instanceFlattening(-1, false);
                this.postFlattening(-1, false);
            }
        }
    }

    public void dryrun() {
        this.processPreamble();
        if (CmdFlags.getClasstrans()) {
            this.classLevelFlattening();
        } else {
            this.instancePreFlattening1();
            if (CmdFlags.getUsePropagate()) {
                this.squashDomains();
                CmdFlags.currentModel = this.m;
            }
            this.instancePreFlattening2(false);
            if (CmdFlags.getMode() == 3) {
                this.branchingInstanceFlattening();
            } else {
                this.instanceFlattening(-1, false);
            }
        }
    }

    public void processPreamble() {
        TreeTransformer treeTransformer;
        Object object;
        Object object2;
        Object object3;
        CmdFlags.setOutputReady(false);
        CmdFlags.setAfterAggregate(false);
        ArrayDeque<ASTNode> arrayDeque = this.m.global_symbols.lettings_givens;
        for (int i = 0; i < this.parameters.size(); ++i) {
            object3 = this.parameters.get(i);
            if (!((ASTNode)object3).typecheck(this.m.global_symbols)) {
                CmdFlags.println("ERROR: Failed type checking in parameter file:" + object3);
                CmdFlags.exit();
            }
            object2 = new TransformMakeSafe(this.m);
            object3 = ((TreeTransformerBottomUp)object2).transform((ASTNode)object3);
            object = ((TreeTransformerBottomUp)object2).getContextCts();
            if (object != null) {
                arrayDeque.addLast(new Where((ASTNode)object));
            }
            treeTransformer = new TransformSimplify();
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            TransformQuantifiedExpression transformQuantifiedExpression = new TransformQuantifiedExpression(this.m);
            object3 = transformQuantifiedExpression.transform((ASTNode)object3);
            object3 = ((TreeTransformerBottomUpNoWrapper)treeTransformer).transform((ASTNode)object3);
            this.fixIndexDomainsLetting((ASTNode)object3);
            this.parameters.set(i, (ASTNode)object3);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(((ASTNode)object3).getChild(0), ((ASTNode)object3).getChild(1));
            for (int j = i + 1; j < this.parameters.size(); ++j) {
                this.parameters.set(j, replaceASTNode.transform(this.parameters.get(j)));
            }
        }
        while (arrayDeque.size() != 0) {
            ASTNode aSTNode = arrayDeque.removeFirst();
            if (!aSTNode.typecheck(this.m.global_symbols)) {
                CmdFlags.println("ERROR: Failed type checking:" + aSTNode);
                CmdFlags.exit();
            }
            object3 = new TransformMakeSafe(this.m);
            aSTNode = ((TreeTransformerBottomUp)object3).transform(aSTNode);
            object2 = ((TreeTransformerBottomUp)object3).getContextCts();
            if (object2 != null) {
                arrayDeque.addLast(new Where((ASTNode)object2));
            }
            object = new TransformSimplify();
            aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode);
            if (!CmdFlags.getClasstrans()) {
                treeTransformer = new TransformQuantifiedExpression(this.m);
                aSTNode = ((TreeTransformerTopdown)treeTransformer).transform(aSTNode);
            }
            if ((aSTNode = ((TreeTransformerBottomUpNoWrapper)object).transform(aSTNode)) instanceof Letting) {
                this.fixIndexDomainsLetting(aSTNode);
                this.processLetting(aSTNode);
                continue;
            }
            if (aSTNode instanceof Find) {
                this.processFind(aSTNode);
                continue;
            }
            if (aSTNode instanceof Where) {
                this.processWhere(aSTNode);
                continue;
            }
            if (aSTNode instanceof Given) {
                this.processGiven(aSTNode);
                continue;
            }
            if (aSTNode instanceof Dim) {
                this.processDim(aSTNode);
                continue;
            }
            assert (aSTNode instanceof ForallExpression);
            this.processForallFind(aSTNode);
        }
        if (this.parameters.size() > 0) {
            CmdFlags.println("WARNING: Number of givens in model file does not match number of lettings in parameter file.");
        }
        this.parameters = null;
        if (!this.m.typecheck()) {
            CmdFlags.println("ERROR: Failed type checking after substituting in lettings.");
            CmdFlags.exit();
        }
        if (CmdFlags.getVerbose()) {
            CmdFlags.println("Model before undef handling:");
            CmdFlags.println(this.m);
        }
        this.removeMatrixIndexedMatrices();
        TransformMakeSafe transformMakeSafe = new TransformMakeSafe(this.m);
        this.m.transform(transformMakeSafe);
        this.m.simplify();
    }

    public void instancePreFlattening1() {
        Object object;
        TreeTransformer treeTransformer;
        Map.Entry<String, ASTNode> entry2;
        HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry2 : hashMap.entrySet()) {
            if (!(entry2.getValue() instanceof MatrixDomain)) continue;
            treeTransformer = new TransformMatrixIndices(0, this.m, (String)entry2.getKey());
            this.m.transform(treeTransformer);
        }
        entry2 = new TransformQuantifiedExpression(this.m);
        this.m.transform((TreeTransformer)((Object)entry2));
        treeTransformer = new TransformToFlatBubble(this.m);
        this.m.transform(treeTransformer);
        this.destroyMatrices();
        this.m.simplify();
        TransformSubInConstantMatrices transformSubInConstantMatrices = new TransformSubInConstantMatrices(this.m);
        this.m.transform(transformSubInConstantMatrices);
        TransformMatrixDeref transformMatrixDeref = new TransformMatrixDeref(this.m);
        this.m.transform(transformMatrixDeref);
        if (CmdFlags.getGraphColSymBreak()) {
            object = new TransformGCAssignClique(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseVarSymBreaking()) {
            this.writeModelAsJSON(this.m);
        }
        if (this.m.objective != null && !((ASTNode)(object = this.m.objective.getChild(0))).isConstant() && !(object instanceof Identifier)) {
            boolean bl = true;
            if (object instanceof MatrixDeref || object instanceof SafeMatrixDeref) {
                bl = false;
                for (int i = 1; i < ((ASTNode)object).numChildren(); ++i) {
                    if (((ASTNode)object).getChild(i).isConstant()) continue;
                    bl = true;
                }
            }
            if (bl) {
                ASTNode aSTNode = this.m.global_symbols.newAuxHelper((ASTNode)object);
                ToVariable toVariable = new ToVariable((ASTNode)object, aSTNode);
                this.m.global_symbols.auxVarRepresentsConstraint(aSTNode.toString(), ((ASTNode)object).toString());
                this.m.objective.setChild(0, aSTNode);
                this.m.constraints.setChild(0, new And(toVariable, this.m.constraints.getChild(0)));
            }
        }
        object = new TransformNormalise(this.m);
        this.m.transform((TreeTransformer)object);
    }

    public void instancePreFlattening2(boolean bl) {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper2;
        TreeTransformer treeTransformer;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper3;
        Object object;
        if (CmdFlags.getRemoveRedundantVars()) {
            object = new RemoveRedundantVars();
            ((RemoveRedundantVars)object).transform(this.m);
        }
        if (CmdFlags.getUseAggregate()) {
            object = new TransformCollectAlldiff(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper3 = new TransformCollectGCC(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper3);
        }
        CmdFlags.setAfterAggregate(true);
        if (CmdFlags.getUseDeleteVars() && CmdFlags.getUseAggregate()) {
            this.m.simplify();
        }
        object = new TransformAlldiffExcept(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper3 = new TransformOccurrence();
        this.m.transform(treeTransformerBottomUpNoWrapper3);
        if (CmdFlags.getUseBoundVars() && CmdFlags.getMiniontrans()) {
            treeTransformer = new TransformForBoundVars(this.m);
            this.m.transform(treeTransformer);
        }
        treeTransformer = new TransformBoolEq(this.m);
        this.m.transform(treeTransformer);
        TransformGCCSum transformGCCSum = new TransformGCCSum(this.m);
        this.m.transform(transformGCCSum);
        if (CmdFlags.getUseAggressiveACCSE()) {
            treeTransformerBottomUpNoWrapper2 = new TransformOccurrenceToSum();
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            treeTransformerBottomUpNoWrapper = new TransformLogicToSum();
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getGecodetrans()) {
            treeTransformerBottomUpNoWrapper2 = new TransformReifyAlldiff(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper2);
            treeTransformerBottomUpNoWrapper = new TransformDecomposeNegativeTable(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        treeTransformerBottomUpNoWrapper2 = new TransformNormalise(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper2);
    }

    public void squashDomains() {
        Model model = this.m.copy();
        boolean bl = CmdFlags.getOutputReady();
        boolean bl2 = CmdFlags.getAfterAggregate();
        this.instancePreFlattening2(true);
        this.instanceFlattening(-1, true);
        ArrayList<ASTNode> arrayList = this.postFlattening(-1, true);
        FilteredDomainStore filteredDomainStore = this.m.filt;
        ASTNode aSTNode = this.m.incumbentSolution;
        this.m = model;
        this.m.filt = filteredDomainStore;
        this.m.incumbentSolution = aSTNode;
        CmdFlags.setOutputReady(bl);
        CmdFlags.setAfterAggregate(bl2);
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode2 = arrayList.get(i).getChild(0);
            ASTNode aSTNode3 = arrayList.get(i).getChild(1);
            assert (aSTNode2 instanceof Identifier);
            assert (aSTNode3.isFiniteSet());
            String string = aSTNode2.toString();
            if (this.m.global_symbols.getCategory(string) == 3) {
                ASTNode aSTNode4 = this.m.global_symbols.getDomain(string);
                ASTNode aSTNode5 = new Intersect(aSTNode4, aSTNode3);
                if (aSTNode4.isBooleanSet()) {
                    TransformSimplify transformSimplify = new TransformSimplify();
                    aSTNode5 = Intpair.makeDomain(transformSimplify.transform(aSTNode5).getIntervalSet(), true);
                }
                this.m.global_symbols.setDomain(string, aSTNode5);
                continue;
            }
            this.m.filt.auxVarFilteredDomain(string, aSTNode3);
        }
        this.m.simplify();
    }

    public void branchingInstanceFlattening() {
        CmdFlags.currentModel = null;
        ArrayList<TreeTransformerBottomUpNoWrapper> arrayList = new ArrayList<TreeTransformerBottomUpNoWrapper>();
        arrayList.add(new TransformMultiplyOutSum());
        arrayList.add(new TransformFactorOutSum());
        arrayList.add(new TransformImplicationOr(false));
        arrayList.add(new TransformImplicationOr(true));
        arrayList.add(new TransformDeMorgans(true));
        arrayList.add(new TransformDeMorgans(false));
        arrayList.add(new TransformReverseDeMorgans(true));
        arrayList.add(new TransformReverseDeMorgans(false));
        arrayList.add(new TransformDistributeLogical(true, true));
        arrayList.add(new TransformDistributeLogical(false, true));
        arrayList.add(new TransformFactorLogical(true));
        arrayList.add(new TransformFactorLogical(false));
        ArrayList<ArrayList<Boolean>> arrayList2 = new ArrayList<ArrayList<Boolean>>();
        this.buildSwitches(arrayList2, new ArrayList<Boolean>(), arrayList.size());
        Model model = this.m.copy();
        int n = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            System.out.println("Switches: " + arrayList2.get(i));
            boolean bl = false;
            int n2 = -1;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!arrayList2.get(i).get(j).booleanValue()) continue;
                String string = this.m.toString();
                boolean bl2 = this.m.transform((TreeTransformer)arrayList.get(j));
                String string2 = this.m.toString();
                if (!bl2 && !string.equals(string2)) {
                    CmdFlags.println("Yikes: modelchanged flag wrong.");
                    bl2 = true;
                }
                if (bl2) continue;
                bl = true;
                n2 = j;
                break;
            }
            if (!bl) {
                this.instanceFlattening(++n, false);
                this.postFlattening(n, false);
            } else {
                assert (n2 > -1);
                while (i < arrayList2.size() && arrayList2.get(i).get(n2).booleanValue()) {
                    ++i;
                }
                --i;
            }
            this.m = model.copy();
        }
        System.out.println("Total models:" + n);
    }

    public void buildSwitches(ArrayList<ArrayList<Boolean>> arrayList, ArrayList<Boolean> arrayList2, int n) {
        if (n == 0) {
            arrayList.add(arrayList2);
            return;
        }
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>(arrayList2);
        arrayList3.add(false);
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>(arrayList2);
        arrayList4.add(true);
        this.buildSwitches(arrayList, arrayList3, n - 1);
        this.buildSwitches(arrayList, arrayList4, n - 1);
    }

    public void instanceFlattening(int n, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        if (!CmdFlags.getUseEliminateVars() || !bl) {
            // empty if block
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Rules: Normalisation and CSE");
        }
        TransformAlldiffGCCSum transformAlldiffGCCSum = new TransformAlldiffGCCSum(this.m);
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            this.m.transform(transformAlldiffGCCSum);
        }
        TransformNormalise transformNormalise = new TransformNormalise(this.m);
        if (CmdFlags.getUseACCSE()) {
            this.m.transform(transformNormalise);
            object3 = new ACCSE();
            ((ACCSE)object3).flattenCSEs(this.m, "*");
            CmdFlags.stats.put("AC-CSE-Times_number", ((ACCSE)object3).numcse);
            CmdFlags.stats.put("AC-CSE-Times_eliminated_expressions", ((ACCSE)object3).countcse);
            CmdFlags.stats.put("AC-CSE-Times_total_size", ((ACCSE)object3).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSEAlt()) {
            this.m.transform(transformNormalise);
            object3 = new ICSEProduct();
            ((ICSEProduct)object3).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object3 = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object3);
        if (CmdFlags.getUseCSE()) {
            this.m.transform(transformNormalise);
            object2 = new CSETopLevel();
            ((CSETopLevel)object2).flattenCSEs(this.m);
            CmdFlags.stats.put("CSETopLevel_number", ((CSETopLevel)object2).numcse);
            CmdFlags.stats.put("CSETopLevel_eliminated_expressions", ((CSETopLevel)object2).countcse);
            CmdFlags.stats.put("CSETopLevel_total_size", ((CSETopLevel)object2).totallength);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE()) {
            object2 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveACCSE()) {
                object = new ACCSEActiveSum();
                ((ACCSEActiveSum)object).flattenCSEs(this.m);
                CmdFlags.stats.put("Active-AC-CSE-Sum_number", ((ACCSEActiveSum)object).numcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_eliminated_expressions", ((ACCSEActiveSum)object).countcse);
                CmdFlags.stats.put("Active-AC-CSE-Sum_total_size", ((ACCSEActiveSum)object).totallength);
                CmdFlags.stats.put("Active-AC-CSE-Found", ((ACCSEActiveSum)object).active_ac_cs_found ? 1 : 0);
            } else {
                ((ACCSE)object2).flattenCSEs(this.m, "+");
                CmdFlags.stats.put("AC-CSE-Sum_number", ((ACCSE)object2).numcse);
                CmdFlags.stats.put("AC-CSE-Sum_eliminated_expressions", ((ACCSE)object2).countcse);
                CmdFlags.stats.put("AC-CSE-Sum_total_size", ((ACCSE)object2).totallength);
            }
        }
        if (CmdFlags.getUseACCSEAlt()) {
            object2 = new ACCSE();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "\\/");
            CmdFlags.stats.put("AC-CSE-Or_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-Or_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-Or_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            ((ACCSE)object2).flattenCSEs(this.m, "/\\");
            CmdFlags.stats.put("AC-CSE-And_number", ((ACCSE)object2).numcse);
            CmdFlags.stats.put("AC-CSE-And_eliminated_expressions", ((ACCSE)object2).countcse);
            CmdFlags.stats.put("AC-CSE-And_total_size", ((ACCSE)object2).totallength);
            this.m.simplify();
            this.m.transform(transformNormalise);
            object = new ICSESum();
            ((ICSESum)object).flattenCSEs(this.m);
            this.m.simplify();
        }
        if (CmdFlags.getUseACCSE() || CmdFlags.getUseACCSEAlt()) {
            transformAlldiffGCCSum.removeImpliedConstraints();
        }
        if (CmdFlags.getSattrans() && !bl) {
            this.decomposeSatEncoding();
        }
        if (CmdFlags.getUseCSE() || CmdFlags.getUseActiveCSE()) {
            this.m.transform(transformNormalise);
            if (CmdFlags.getUseActiveCSE()) {
                object2 = new CSEActive();
                ((CSEActive)object2).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_active_number", ((CSEActive)object2).numcse);
                CmdFlags.stats.put("CSE_active_eliminated_expressions", ((CSEActive)object2).countcse);
                CmdFlags.stats.put("CSE_active_total_size", ((CSEActive)object2).totallength);
            } else {
                object2 = new CSE();
                ((CSE)object2).flattenCSEs(this.m);
                this.m.simplify();
                CmdFlags.stats.put("CSE_number", ((CSE)object2).numcse);
                CmdFlags.stats.put("CSE_eliminated_expressions", ((CSE)object2).countcse);
                CmdFlags.stats.put("CSE_total_size", ((CSE)object2).totallength);
            }
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Model may have changed by CSE. Model after rule application:\n" + this.m.toString());
        }
        object2 = new TransformEqual(this.m);
        this.m.transform((TreeTransformer)object2);
        object = new TransformEqualConst();
        this.m.transform((TreeTransformer)object);
        TransformToFlat transformToFlat = new TransformToFlat(this.m, bl);
        this.m.transform(transformToFlat);
        if (CmdFlags.getGecodetrans() && !bl) {
            TransformToFlatGecode transformToFlatGecode = new TransformToFlatGecode(this.m);
            this.m.transform(transformToFlatGecode);
        }
    }

    public ArrayList<ASTNode> postFlattening(int n, boolean bl) {
        block22: {
            Object object;
            Object object2;
            TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
            TransformMappingToTable transformMappingToTable = new TransformMappingToTable();
            this.m.transform(transformMappingToTable);
            if (CmdFlags.getGecodetrans() && !bl) {
                this.gecodeFlattening();
                System.exit(0);
            }
            if (CmdFlags.getMinizinctrans() && !bl) {
                this.minizincOutput();
                System.exit(0);
            }
            if (CmdFlags.getSattrans() && !bl) {
                this.decomposeSatEncodingFlat();
                this.m.simplify();
                if (CmdFlags.getTestSolutions()) {
                    CmdFlags.checkSolModel = this.m.copy();
                }
                treeTransformerBottomUpNoWrapper = new TransformCollectSATDirect(this.m);
                treeTransformerBottomUpNoWrapper.transform(this.m.constraints);
                CmdFlags.printlnIfVerbose("About to do m.setupSAT");
                boolean bl2 = this.m.setupSAT();
                if (!bl2) {
                    object2 = new Stats();
                    ((Stats)object2).putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
                    ((Stats)object2).putValue("SavileRowClauseOut", "1");
                    ((Stats)object2).makeInfoFiles();
                    CmdFlags.errorExit("Failed when writing SAT encoding to file.");
                }
                CmdFlags.printlnIfVerbose("Done m.setupSAT");
                object2 = new TransformSATEncoding(this.m);
                this.m.transform((TreeTransformer)object2);
                this.satOutput();
                System.exit(0);
            }
            treeTransformerBottomUpNoWrapper = new TransformSumEq();
            this.m.transform(treeTransformerBottomUpNoWrapper);
            if (CmdFlags.getMakeTables() && !bl) {
                this.makeTables();
            }
            this.m.simplify();
            if (CmdFlags.getOptWarmStart() && this.m.objective != null && bl) {
                MinionSolver minionSolver = new MinionSolver();
                try {
                    object2 = minionSolver.optWarmStart(this.m);
                    if (object2 != null) {
                        this.m.incumbentSolution = object2;
                        long l = ((Solution)object2).optval;
                        ASTNode aSTNode = this.m.objective.getChild(0);
                        Less less = this.m.objective instanceof Minimising ? new Less(aSTNode, new NumberConstant(l)) : new Less(new NumberConstant(l), aSTNode);
                        System.out.println("Adding warm start constraint: " + less);
                        this.m.constraints.setChild(0, new And(this.m.constraints.getChild(0), less));
                        this.m.simplify();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.m.toMinion(stringBuilder);
            assert (CmdFlags.minionfile != null);
            object2 = CmdFlags.minionfile;
            if (n > -1) {
                object2 = (String)object2 + "." + n;
            }
            try {
                object = new FileOutputStream((String)object2);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
                bufferedWriter.write(stringBuilder.toString());
                bufferedWriter.flush();
                ((FileOutputStream)object).getFD().sync();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("Could not open file for Minion output.");
                CmdFlags.exit();
            }
            CmdFlags.println("Created output file " + (bl ? "for domain filtering " : "") + (String)object2);
            if (bl) {
                object = new MinionSolver();
                try {
                    return ((MinionSolver)object).reduceDomains(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.println("Could not run Minion: " + iOException);
                    CmdFlags.exit();
                    break block22;
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.println("Could not run Minion: " + interruptedException);
                    CmdFlags.exit();
                    break block22;
                }
            }
            if (CmdFlags.getRunSolver()) {
                object = new MinionSolver();
                try {
                    ((MinionSolver)object).findSolutions(CmdFlags.getMinion(), (String)object2, this.m);
                }
                catch (IOException iOException) {
                    CmdFlags.println("Could not run Minion: " + iOException);
                    CmdFlags.exit();
                }
                catch (InterruptedException interruptedException) {
                    CmdFlags.println("Could not run Minion: " + interruptedException);
                    CmdFlags.exit();
                }
            }
        }
        return null;
    }

    private void makeTables() {
        MinionSolver minionSolver = new MinionSolver();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<Identifier> arrayList2 = new ArrayList<Identifier>();
        categoryentry categoryentry2 = this.m.global_symbols.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                arrayList2.add(new Identifier(categoryentry2.name, this.m.global_symbols));
            }
            categoryentry2 = categoryentry2.next;
        }
        for (int i = 0; i < CmdFlags.make_tables_scope.size(); ++i) {
            arrayList.add((ASTNode)arrayList2.get(CmdFlags.make_tables_scope.get(i)));
        }
        ASTNode aSTNode = null;
        try {
            aSTNode = minionSolver.makeTable(this.m, arrayList);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace(System.out);
        }
        this.m.constraints = new Top(new And(this.m.constraints.getChild(0), aSTNode));
        this.m.simplify();
    }

    private void destroyMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
                if (entry.getValue() instanceof MatrixDomain && this.m.global_symbols.getCategory(entry.getKey()) == 3) {
                    treeTransformerBottomUpNoWrapper = new TransformMatrixToAtoms(entry.getKey(), this.m);
                    this.m.transform(treeTransformerBottomUpNoWrapper);
                    bl = true;
                    continue block0;
                }
                if (!(entry.getValue() instanceof HoleyMatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                treeTransformerBottomUpNoWrapper = new TransformHoleyMatrixToAtoms(entry.getKey(), this.m);
                this.m.transform(treeTransformerBottomUpNoWrapper);
                bl = true;
                continue block0;
            }
        }
    }

    private void removeMatrixIndexedMatrices() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
            for (Map.Entry<String, ASTNode> entry : hashMap.entrySet()) {
                if (!(entry.getValue() instanceof MatrixDomain) || this.m.global_symbols.getCategory(entry.getKey()) != 3) continue;
                boolean bl2 = false;
                for (int i = 3; i < entry.getValue().numChildren(); ++i) {
                    if (!(entry.getValue().getChild(i) instanceof MatrixDomain)) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                TransformMatrixIndexedMatrix transformMatrixIndexedMatrix = new TransformMatrixIndexedMatrix(entry.getKey(), this.m);
                this.m.transform(transformMatrixIndexedMatrix);
                bl = true;
                continue block0;
            }
        }
    }

    private void classLevelFlattening() {
        Map.Entry<String, ASTNode> entry3;
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper;
        Object object;
        Object object2;
        Object object3;
        Map.Entry<String, ASTNode> entry22;
        System.out.println(this.m.toString());
        CmdFlags.setAfterAggregate(true);
        HashMap<String, ASTNode> hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry22 : hashMap.entrySet()) {
            if (!(entry22.getValue() instanceof MatrixDomain)) continue;
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry22.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        if (this.m.objective != null && !((ASTNode)((Object)(entry22 = this.m.objective.getChild(0)))).isConstant() && !(entry22 instanceof Identifier)) {
            boolean bl = true;
            if (entry22 instanceof MatrixDeref || entry22 instanceof SafeMatrixDeref) {
                bl = false;
                for (int i = 1; i < ((ASTNode)((Object)entry22)).numChildren(); ++i) {
                    if (((ASTNode)((Object)entry22)).getChild(i).getCategory() != 3) continue;
                    bl = true;
                }
            }
            if (bl) {
                PairASTNode pairASTNode = ((ASTNode)((Object)entry22)).getBoundsAST();
                object3 = this.m.global_symbols.newAuxiliaryVariable(pairASTNode.e1, pairASTNode.e2);
                object2 = new ToVariable((ASTNode)((Object)entry22), (ASTNode)object3);
                this.m.global_symbols.auxVarRepresentsConstraint(((ASTNode)object3).toString(), ((ASTNode)((Object)entry22)).toString());
                this.m.objective.setChild(0, (ASTNode)object3);
                this.m.constraints.setChild(0, new And((ASTNode)object2, this.m.constraints.getChild(0)));
            }
        }
        entry22 = new TransformForallAndToAndForall();
        this.m.transform((TreeTransformer)((Object)entry22));
        TransformMatrixDerefClass transformMatrixDerefClass = new TransformMatrixDerefClass(this.m);
        this.m.transform(transformMatrixDerefClass);
        TransformOccurrence transformOccurrence = new TransformOccurrence();
        this.m.transform(transformOccurrence);
        object3 = new TransformSumEqualSum(this.m);
        this.m.transform((TreeTransformer)object3);
        object2 = new TransformSumLess();
        this.m.transform((TreeTransformer)object2);
        TransformSumLeq transformSumLeq = new TransformSumLeq();
        this.m.transform(transformSumLeq);
        if (CmdFlags.getUseMappers()) {
            object = new TransformSumToShift(this.m);
            this.m.transform((TreeTransformer)object);
            treeTransformerBottomUpNoWrapper = new TransformProductToMult(this.m);
            this.m.transform(treeTransformerBottomUpNoWrapper);
        }
        if (CmdFlags.getUseMinionMappers()) {
            object = new TransformProductToMultInQSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (!CmdFlags.getUseMappers() && !CmdFlags.getUseMinionMappers()) {
            object = new TransformWSumToSum(this.m);
            this.m.transform((TreeTransformer)object);
        }
        if (CmdFlags.getUseCSE()) {
            object = new CSEClassIdentical();
            ((CSEClassIdentical)object).flattenCSEs(this.m);
            this.m.simplify();
        }
        CmdFlags.setOutputReady(true);
        object = new TransformTimes(this.m);
        this.m.transform((TreeTransformer)object);
        treeTransformerBottomUpNoWrapper = new TransformEqualClass(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformEqualConstClass transformEqualConstClass = new TransformEqualConstClass();
        this.m.transform(transformEqualConstClass);
        TransformToFlatClass transformToFlatClass = new TransformToFlatClass(this.m);
        this.m.transform(transformToFlatClass);
        TransformConstMatrixClass transformConstMatrixClass = new TransformConstMatrixClass(this.m);
        this.m.transform(transformConstMatrixClass);
        System.out.println("**** Completed class-level flattening ****");
        System.out.println(this.m.toString());
        hashMap = this.m.global_symbols.getDomains();
        for (Map.Entry<String, ASTNode> entry3 : hashMap.entrySet()) {
            if (!(entry3.getValue() instanceof MatrixDomain)) continue;
            boolean bl = false;
            ArrayList<ASTNode> arrayList = ((MatrixDomain)entry3.getValue()).getMDIndexDomains();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get((int)i).getBoundsAST().e1.equals(new NumberConstant(0L))) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            CmdFlags.println("About to normalise indices of matrix: " + entry3.getKey());
            TransformMatrixIndicesClass transformMatrixIndicesClass = new TransformMatrixIndicesClass(0, this.m, (String)entry3.getKey());
            this.m.transform(transformMatrixIndicesClass);
            System.out.println(this.m.toString());
        }
        this.m.simplify();
        System.out.println("************************");
        System.out.println("**** After Simplify ****");
        System.out.println("************************");
        System.out.println(this.m.toString());
        System.out.println("************************");
        System.out.println("**** Dominion output ***");
        System.out.println("************************");
        entry3 = new StringBuilder();
        this.m.toDominion((StringBuilder)((Object)entry3));
        System.out.println(((StringBuilder)((Object)entry3)).toString());
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.dominionfile));
            bufferedWriter.write(((StringBuilder)((Object)entry3)).toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for Dominion output.");
            CmdFlags.exit();
        }
    }

    private void gecodeFlattening() {
        Object object;
        TransformSumEqToSum transformSumEqToSum = new TransformSumEqToSum();
        this.m.transform(transformSumEqToSum);
        TransformReifyMin transformReifyMin = new TransformReifyMin(this.m);
        this.m.transform(transformReifyMin);
        TransformAbsReify transformAbsReify = new TransformAbsReify(this.m);
        this.m.transform(transformAbsReify);
        this.m.simplify();
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        StringBuilder stringBuilder = new StringBuilder();
        this.m.toFlatzinc(stringBuilder);
        try {
            object = new BufferedWriter(new FileWriter(CmdFlags.gecodefile));
            ((Writer)object).write(stringBuilder.toString());
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for Gecode flatzinc output.");
            CmdFlags.exit();
        }
        CmdFlags.println("Created output file " + CmdFlags.gecodefile);
        if (CmdFlags.getRunSolver()) {
            object = new GecodeSolver();
            try {
                ((GecodeSolver)object).findSolutions(CmdFlags.getGecode(), CmdFlags.gecodefile, this.m);
            }
            catch (IOException iOException) {
                CmdFlags.println("Could not run Gecode: " + iOException);
                CmdFlags.exit();
            }
            catch (InterruptedException interruptedException) {
                CmdFlags.println("Could not run Gecode: " + interruptedException);
                CmdFlags.exit();
            }
        }
    }

    private void minizincOutput() {
        this.m.simplify();
        TransformCollectBool transformCollectBool = new TransformCollectBool(this.m);
        this.m.transform(transformCollectBool);
        StringBuilder stringBuilder = new StringBuilder();
        this.m.toMinizinc(stringBuilder);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(CmdFlags.minizincfile));
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for minizinc output.");
            CmdFlags.exit();
        }
        CmdFlags.println("Created output file " + CmdFlags.minizincfile);
    }

    private void decomposeSatEncoding() {
        TreeTransformerBottomUpNoWrapper treeTransformerBottomUpNoWrapper = new TransformAlldiffToAtmost(this.m);
        this.m.transform(treeTransformerBottomUpNoWrapper);
        treeTransformerBottomUpNoWrapper = new TransformGCCToSums();
        this.m.transform(treeTransformerBottomUpNoWrapper);
        TransformOccurrenceToSum transformOccurrenceToSum = new TransformOccurrenceToSum();
        this.m.transform(transformOccurrenceToSum);
        if (CmdFlags.getSatDecompCSE()) {
            TransformDecomposeLex2 transformDecomposeLex2 = new TransformDecomposeLex2(this.m);
            this.m.transform(transformDecomposeLex2);
        } else {
            TransformDecomposeLex transformDecomposeLex = new TransformDecomposeLex(this.m);
            this.m.transform(transformDecomposeLex);
        }
    }

    private void decomposeSatEncodingFlat() {
        TransformDecomposeMinMax transformDecomposeMinMax = new TransformDecomposeMinMax(this.m);
        this.m.transform(transformDecomposeMinMax);
        TreeTransformer treeTransformer = new TransformElementForSAT2(this.m);
        this.m.transform(treeTransformer);
        if (!CmdFlags.getSatAlt()) {
            treeTransformer = new TransformBreakupSum2(this.m);
            this.m.transform(treeTransformer);
            treeTransformer = new TransformSumEq();
            this.m.transform(treeTransformer);
            TransformSumForSAT transformSumForSAT = new TransformSumForSAT();
            this.m.transform(transformSumForSAT);
            TransformWeightedSumForSAT transformWeightedSumForSAT = new TransformWeightedSumForSAT();
            this.m.transform(transformWeightedSumForSAT);
        } else {
            treeTransformer = new TransformSortWeightedSum2();
            this.m.transform(treeTransformer);
            TransformBreakupSum transformBreakupSum = new TransformBreakupSum(this.m);
            this.m.constraints = transformBreakupSum.transform(this.m.constraints);
            TransformToFlat transformToFlat = new TransformToFlat(this.m, false);
            this.m.transform(transformToFlat);
        }
    }

    private void satOutput() {
        Object object;
        boolean bl = this.m.toSAT();
        if (!bl) {
            object = new Stats();
            ((Stats)object).putValue("SavileRowTotalTime", String.valueOf(((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0));
            ((Stats)object).putValue("SavileRowClauseOut", "1");
            ((Stats)object).makeInfoFiles();
            CmdFlags.errorExit("Failed when writing SAT encoding to file.");
        }
        CmdFlags.println("Created output SAT file " + CmdFlags.satfile);
        if (CmdFlags.getRunSolver()) {
            if (CmdFlags.getSatFamily().equals("minisat")) {
                object = new MinisatSATSolver(this.m);
            } else {
                assert (CmdFlags.getSatFamily().equals("lingeling"));
                object = new LingelingSATSolver(this.m);
            }
            try {
                ((SATSolver)object).findSolutions(CmdFlags.getSatSolver(), CmdFlags.satfile, this.m);
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Could not run SAT solver: " + exception);
            }
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private void processGiven(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        ASTNode aSTNode3 = aSTNode.getChild(1);
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.errorExit("Symbol " + string + " declared twice.");
        }
        this.m.global_symbols.newVariable(string, aSTNode3, 1);
        if (!CmdFlags.getClasstrans()) {
            int n = 0;
            ASTNode aSTNode4 = null;
            for (ASTNode aSTNode5 : this.parameters) {
                if (!((Identifier)((Letting)aSTNode5).getChildren().get(0)).getName().equals(string)) continue;
                aSTNode4 = aSTNode5;
                ++n;
            }
            if (n != 1) {
                CmdFlags.errorExit("Too many or zero lettings of parameter variable " + string + " in parameter file.");
            }
            this.processLetting(aSTNode4);
            this.parameters.remove(aSTNode4);
        }
    }

    private void processLetting(ASTNode aSTNode) {
        ASTNode aSTNode2;
        assert (aSTNode instanceof Letting);
        ASTNode aSTNode3 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode3).getName();
        if (this.m.global_symbols.hasVariable(string) && this.m.global_symbols.getCategory(string) != 1) {
            CmdFlags.errorExit("Symbol " + string + " declared more than once.");
        }
        if ((aSTNode2 = aSTNode.getChild(1)).getCategory() > 2) {
            CmdFlags.errorExit("In statement: " + aSTNode, "Right-hand side contains an identifier that is not a constant or parameter.");
        }
        if (aSTNode2 instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix) {
            this.m.global_symbols.newConstantMatrix(string, aSTNode2);
            ArrayList<ASTNode> arrayList = this.m.global_symbols.makeLettingsConstantMatrix(string);
            for (ASTNode aSTNode4 : arrayList) {
                this.processLetting(aSTNode4);
            }
            this.m.global_symbols.correctIndicesConstantMatrix(string);
            this.m.substituteExceptTable(aSTNode.getChild(0), this.m.global_symbols.getConstantMatrix(string));
        } else {
            this.m.substitute(aSTNode.getChild(0), aSTNode2.copy());
        }
    }

    private void processFind(ASTNode aSTNode) {
        assert (aSTNode instanceof Find);
        ASTNode aSTNode2 = aSTNode.getChild(0);
        String string = ((Identifier)aSTNode2).getName();
        if (this.m.global_symbols.hasVariable(string)) {
            CmdFlags.println("ERROR: Symbol " + string + " declared more than once.");
            CmdFlags.exit();
        }
        if (aSTNode.getChild(1).getCategory() > 2) {
            CmdFlags.println("ERROR: In statement : " + aSTNode);
            CmdFlags.println("ERROR: Right-hand side contains an identifier that is not a constant or parameter.");
            CmdFlags.exit();
        }
        this.m.global_symbols.newVariable(string, aSTNode.getChild(1), 3);
    }

    private void processWhere(ASTNode aSTNode) {
        if (CmdFlags.getClasstrans()) {
            return;
        }
        if ((aSTNode = aSTNode.getChild(0)).getCategory() > 2) {
            CmdFlags.println("ERROR: In statement: where " + aSTNode);
            CmdFlags.println("ERROR: Contains an identifier that is not a constant or parameter.");
            CmdFlags.exit();
        }
        if (!aSTNode.equals(new BooleanConstant(true))) {
            CmdFlags.println("ERROR: In statement: where " + aSTNode);
            CmdFlags.println("ERROR: Does not evaluate to true.");
            CmdFlags.exit();
        }
    }

    private void processDim(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getChild(0);
        if (this.m.global_symbols.hasVariable(aSTNode2.toString())) {
            CmdFlags.println("ERROR: In statement: " + aSTNode);
            CmdFlags.println("ERROR: Contains an identifier that is already defined.");
            CmdFlags.exit();
        }
        this.m.global_symbols.newDim(aSTNode2.toString(), aSTNode.getChild(1), ((Dim)aSTNode).dimensions);
    }

    private void processForallFind(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode;
        while (aSTNode2 instanceof ForallExpression) {
            aSTNode2 = aSTNode2.getChild(2);
        }
        aSTNode2 = aSTNode2.getChild(0);
        assert (aSTNode2 instanceof MatrixDeref);
        String string = aSTNode2.getChild(0).toString();
        if (!this.m.global_symbols.hasVariable(string)) {
            CmdFlags.println("ERROR: In statement: " + aSTNode);
            CmdFlags.println("ERROR: Forall-Find without preceding matching dim statement.");
            CmdFlags.exit();
        }
        this.m.global_symbols.newForallFind(string, aSTNode);
    }

    private void fixIndexDomainsLetting(ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode.numChildren() == 3 && ((aSTNode2 = aSTNode.getChild(1)) instanceof CompoundMatrix || aSTNode2 instanceof EmptyMatrix)) {
            Pair<ASTNode, Boolean> pair = SymbolTable.fixIndicesConstantMatrix(aSTNode.getChild(2), aSTNode2.copy());
            if (pair.getSecond().booleanValue()) {
                System.out.println("WARNING: The index domains in the matrix literal do not match");
                System.out.println("WARNING: the given matrix domain in the following letting statement:");
                System.out.println("WARNING: " + aSTNode);
            }
            aSTNode.setChild(1, pair.getFirst());
        }
    }

    public ModelContainer copy() {
        Model model = this.m.copy();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(model.global_symbols);
        for (int i = 0; i < this.parameters.size(); ++i) {
            arrayList.add(transformFixSTRef.transform(this.parameters.get(i)));
        }
        return new ModelContainer(model, arrayList);
    }

    public void writeModelAsJSON(Model model) {
        SymmetryBreaker symmetryBreaker = new SymmetryBreaker();
        symmetryBreaker.detectAndBreakSymmetries(model);
        model.simplify();
    }
}

