/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.expression.Solution;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.solver.ReadProcessOutput;
import savilerow.solver.RunCommand;
import savilerow.solver.Solver;

public class GecodeSolver
extends Solver {
    @Override
    public void findSolutions(String string, String string2, Model model) throws IOException, InterruptedException {
        double d = ((double)System.currentTimeMillis() - (double)CmdFlags.startTime) / 1000.0;
        this.runGecode(string, string2, model);
    }

    private void runGecode(String string, String string2, Model model) throws IOException, InterruptedException {
        CmdFlags.runningSolver = true;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (CmdFlags.getFindAllSolutions()) {
                if (model.objective != null) {
                    CmdFlags.println("WARNING: Ignoring -all-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindAllSolutions(false);
                } else {
                    arrayList.add("-n");
                    arrayList.add("0");
                }
            }
            if (CmdFlags.getFindNumSolutions() > -1L) {
                if (model.objective != null) {
                    CmdFlags.println("WARNING: Ignoring -num-solutions flag because it cannot be used with optimisation.");
                    CmdFlags.setFindNumSolutions(-1L);
                } else {
                    arrayList.add("-n");
                    arrayList.add("" + CmdFlags.getFindNumSolutions());
                }
            }
            arrayList.addAll(CmdFlags.getSolverExtraFlags());
            arrayList.add(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ReadGecodeOutput readGecodeOutput = new ReadGecodeOutput(this, model.global_symbols);
            int n = RunCommand.runCommand(arrayList, arrayList2, readGecodeOutput);
            if (arrayList2.size() != 0 || n != 0) {
                CmdFlags.println("Gecode exited with error code:" + n + " and message:");
                CmdFlags.println(arrayList2);
                CmdFlags.rmTempFiles();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException.");
            CmdFlags.rmTempFiles();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException.");
            CmdFlags.rmTempFiles();
            throw interruptedException;
        }
    }

    @Override
    Solution parseOneSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            while (!string.equals("----------")) {
                arrayList.add(string);
                string = bufferedReader.readLine();
                if (string != null) continue;
                return null;
            }
            Solution solution = this.solverSolToAST(arrayList, symbolTable);
            return solution;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    Solution parseLastSolverSolution(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Serializable serializable;
        Serializable serializable2 = null;
        while (true) {
            serializable = new ArrayList();
            try {
                String string = bufferedReader.readLine();
                if (string == null || string.equals("=====UNSATISFIABLE=====") || string.equals("==========")) break;
                while (!string.equals("----------")) {
                    ((ArrayList)serializable).add(string);
                    string = bufferedReader.readLine();
                    if (string != null) continue;
                }
                serializable2 = serializable;
            }
            catch (IOException iOException) {
                break;
            }
        }
        if (serializable2 != null) {
            serializable = this.solverSolToAST((ArrayList<String>)serializable2, symbolTable);
            return serializable;
        }
        return null;
    }

    @Override
    HashMap<String, Long> readAllAssignments(ArrayList<String> arrayList, SymbolTable symbolTable) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            String[] stringArray = string.split(" = ");
            assert (stringArray.length == 2);
            String[] stringArray2 = stringArray[1].split(";");
            hashMap.put(stringArray[0], Long.parseLong(stringArray2[0].trim()));
        }
        return hashMap;
    }

    class ReadGecodeOutput
    extends ReadProcessOutput {
        BufferedReader br;
        GecodeSolver gs;
        SymbolTable st;

        ReadGecodeOutput(GecodeSolver gecodeSolver2, SymbolTable symbolTable) {
            this.gs = gecodeSolver2;
            this.st = symbolTable;
        }

        @Override
        public void giveInputStream(BufferedReader bufferedReader) {
            this.br = bufferedReader;
        }

        @Override
        public void run() {
            if (!CmdFlags.getFindAllSolutions() && CmdFlags.getFindNumSolutions() == -1L) {
                Solution solution = this.gs.parseLastSolverSolution(this.st, this.br);
                if (solution != null || this.st.m.incumbentSolution != null) {
                    this.gs.createSolutionFile(solution != null ? solution : this.st.m.incumbentSolution, CmdFlags.solutionfile);
                }
            } else {
                this.gs.parseAllSolverSolutions(this.st, this.br);
            }
        }
    }
}

