/*
 * Decompiled with CFR 0.152.
 */
package savilerow.solver;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Negate;
import savilerow.expression.NoValue;
import savilerow.expression.NumberConstant;
import savilerow.expression.Solution;
import savilerow.expression.Top;
import savilerow.model.Model;
import savilerow.model.SymbolTable;
import savilerow.model.categoryentry;
import savilerow.treetransformer.SubstituteAllValues;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformer;

public abstract class Solver {
    public abstract void findSolutions(String var1, String var2, Model var3) throws IOException, InterruptedException;

    public void parseSolutionMode() {
        SymbolTable symbolTable;
        Object object;
        Closeable closeable;
        try {
            closeable = new FileInputStream(CmdFlags.auxfile);
            object = new ObjectInputStream((InputStream)closeable);
            symbolTable = (SymbolTable)((ObjectInputStream)object).readObject();
            symbolTable.unmangle_after_serialization();
            ((ObjectInputStream)object).close();
            closeable.close();
        }
        catch (Exception exception) {
            CmdFlags.println("" + exception);
            symbolTable = null;
        }
        if (symbolTable == null) {
            CmdFlags.errorExit("Failed to read serialisation file " + CmdFlags.auxfile);
        }
        if (!CmdFlags.getFindAllSolutions() && CmdFlags.getFindNumSolutions() == -1L) {
            try {
                closeable = new BufferedReader(new FileReader(CmdFlags.minionsolfile));
                object = this.parseLastSolverSolution(symbolTable, (BufferedReader)closeable);
                this.createSolutionFile((ASTNode)object, CmdFlags.solutionfile);
            }
            catch (IOException iOException) {
                System.out.println("Could not open or parse Minion solution file. " + iOException);
            }
        } else {
            try {
                closeable = new BufferedReader(new FileReader(CmdFlags.minionsolfile));
                this.parseAllSolverSolutions(symbolTable, (BufferedReader)closeable);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Could not open or parse Minion solution file. " + fileNotFoundException);
            }
        }
    }

    void parseAllSolverSolutions(SymbolTable symbolTable, BufferedReader bufferedReader) {
        Solution solution;
        int n = 6;
        int n2 = 0;
        while ((solution = this.parseOneSolverSolution(symbolTable, bufferedReader)) != null) {
            String string = String.format("%0" + n + "d", n2 + 1);
            this.createSolutionFile(solution, CmdFlags.solutionfile + "." + string);
            if ((long)(++n2) != CmdFlags.getFindNumSolutions()) continue;
            break;
        }
    }

    abstract Solution parseOneSolverSolution(SymbolTable var1, BufferedReader var2);

    abstract Solution parseLastSolverSolution(SymbolTable var1, BufferedReader var2);

    abstract HashMap<String, Long> readAllAssignments(ArrayList<String> var1, SymbolTable var2);

    Solution solverSolToAST(ArrayList<String> arrayList, SymbolTable symbolTable) {
        Serializable serializable;
        Object object;
        Object object2;
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        HashMap<String, HashMap<ArrayList<Long>, ASTNode>> hashMap = new HashMap<String, HashMap<ArrayList<Long>, ASTNode>>();
        HashMap<String, Long> hashMap2 = this.readAllAssignments(arrayList, symbolTable);
        Long l = null;
        if (symbolTable.m != null && symbolTable.m.objective != null) {
            l = hashMap2.get(symbolTable.m.objective.getChild(0).toString());
        }
        categoryentry categoryentry2 = symbolTable.getCategoryFirst();
        while (categoryentry2 != null) {
            object2 = categoryentry2.name;
            int n = categoryentry2.cat;
            if (n == 3) {
                long l2;
                object = symbolTable.getDomain((String)object2);
                assert (((ASTNode)object).isFiniteSet());
                if (hashMap2.containsKey(object2)) {
                    l2 = hashMap2.get(object2);
                } else if (hashMap2.containsKey(object2 + "_INTEGER")) {
                    l2 = hashMap2.get((String)object2 + "_INTEGER");
                } else if (hashMap2.containsKey((String)object2 + "_BOOL")) {
                    l2 = hashMap2.get((String)object2 + "_BOOL");
                } else {
                    assert (CmdFlags.getSattrans());
                    l2 = ((ASTNode)object).getBounds().lower;
                }
                if (symbolTable.replaces_matrix.containsKey(object2)) {
                    if (!hashMap.containsKey(symbolTable.replaces_matrix.get((Object)object2).name)) {
                        hashMap.put(symbolTable.replaces_matrix.get((Object)object2).name, new HashMap());
                    }
                    if (object instanceof BooleanDomain) {
                        ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object2).name)).put(symbolTable.replaces_matrix.get((Object)object2).idx, new BooleanConstant(l2 != 0L));
                    } else {
                        ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object2).name)).put(symbolTable.replaces_matrix.get((Object)object2).idx, new NumberConstant(l2));
                    }
                } else if (object instanceof BooleanDomain) {
                    arrayList2.add(new Letting(new Identifier((String)object2, symbolTable), new BooleanConstant(l2 != 0L)));
                } else {
                    arrayList2.add(new Letting(new Identifier((String)object2, symbolTable), new NumberConstant(l2)));
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        for (ASTNode aSTNode : symbolTable.replacements.keySet()) {
            object = aSTNode.toString();
            if (symbolTable.replacements_category.get(aSTNode) != 3) continue;
            ASTNode aSTNode2 = symbolTable.replacements.get(aSTNode);
            serializable = symbolTable.replacements_domains.get(aSTNode);
            long l3 = this.readReplacementValue(aSTNode2, hashMap2, symbolTable.replacements);
            hashMap2.put((String)object, l3);
            if (symbolTable.replaces_matrix.containsKey(object)) {
                if (!hashMap.containsKey(symbolTable.replaces_matrix.get((Object)object).name)) {
                    hashMap.put(symbolTable.replaces_matrix.get((Object)object).name, new HashMap());
                }
                if (serializable instanceof BooleanDomain) {
                    ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object).name)).put(symbolTable.replaces_matrix.get((Object)object).idx, new BooleanConstant(l3 != 0L));
                    continue;
                }
                ((HashMap)hashMap.get(symbolTable.replaces_matrix.get((Object)object).name)).put(symbolTable.replaces_matrix.get((Object)object).idx, new NumberConstant(l3));
                continue;
            }
            if (serializable instanceof BooleanDomain) {
                arrayList2.add(new Letting(new Identifier((String)object, symbolTable), new BooleanConstant(l3 != 0L)));
                continue;
            }
            arrayList2.add(new Letting(new Identifier((String)object, symbolTable), new NumberConstant(l3)));
        }
        for (String string : hashMap.keySet()) {
            object = symbolTable.deleted_matrices.get(string);
            ASTNode aSTNode = symbolTable.getOriginalDomain(string);
            serializable = ((ASTNode)object).getChildren();
            ((ArrayList)serializable).remove(0);
            ((ArrayList)serializable).remove(0);
            ((ArrayList)serializable).remove(0);
            ArrayList<ASTNode> arrayList3 = aSTNode.getChildren();
            arrayList3.remove(0);
            arrayList3.remove(0);
            arrayList3.remove(0);
            boolean bl = aSTNode.getChild(0).isBooleanSet();
            arrayList2.add(new Letting(new Identifier(string, symbolTable), this.collectMatrix((ArrayList<ASTNode>)serializable, arrayList3, string, new ArrayList<Long>(), hashMap, bl)));
        }
        for (String string : symbolTable.deleted_matrices.keySet()) {
            if (hashMap.keySet().contains(string)) continue;
            arrayList2.add(new Letting(new Identifier(string, symbolTable), new EmptyMatrix(symbolTable.matrix_original_domain.get(string))));
        }
        class Cmplettings
        implements Comparator<ASTNode> {
            Cmplettings() {
            }

            @Override
            public int compare(ASTNode aSTNode, ASTNode aSTNode2) {
                return aSTNode.getChild(0).toString().compareTo(aSTNode2.getChild(0).toString());
            }
        }
        object2 = new Cmplettings();
        Collections.sort(arrayList2, object2);
        if (l == null) {
            return new Solution(arrayList2, new ArrayList<String>());
        }
        return new Solution(arrayList2, new ArrayList<String>(), l);
    }

    private long readReplacementValue(ASTNode aSTNode, HashMap<String, Long> hashMap, HashMap<ASTNode, ASTNode> hashMap2) {
        while (hashMap2.get(aSTNode) != null) {
            aSTNode = hashMap2.get(aSTNode);
        }
        if (aSTNode.isConstant()) {
            return aSTNode.getValue();
        }
        if (aSTNode instanceof Identifier) {
            if (hashMap.containsKey(aSTNode.toString())) {
                return hashMap.get(aSTNode.toString());
            }
            if (hashMap.containsKey(aSTNode.toString() + "_INTEGER")) {
                return hashMap.get(aSTNode.toString() + "_INTEGER");
            }
            return hashMap.get(aSTNode.toString() + "_BOOL");
        }
        assert (aSTNode instanceof Negate);
        return 1L - this.readReplacementValue(aSTNode.getChild(0), hashMap, hashMap2);
    }

    private ASTNode collectMatrix(ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, String string, ArrayList<Long> arrayList3, HashMap<String, HashMap<ArrayList<Long>, ASTNode>> hashMap, boolean bl) {
        if (arrayList.size() == 0) {
            if (hashMap.get(string).containsKey(arrayList3)) {
                return hashMap.get(string).get(arrayList3);
            }
            return new NoValue();
        }
        ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(arrayList);
        ASTNode aSTNode = arrayList4.remove(0);
        ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>(arrayList2);
        ASTNode aSTNode2 = arrayList5.remove(0);
        ArrayList<Long> arrayList6 = aSTNode.getValueSet();
        ArrayList<ASTNode> arrayList7 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList6.size(); ++i) {
            arrayList3.add(arrayList6.get(i));
            arrayList7.add(this.collectMatrix(arrayList4, arrayList5, string, arrayList3, hashMap, bl));
            arrayList3.remove(arrayList3.size() - 1);
        }
        if (arrayList7.size() > 0) {
            return new CompoundMatrix(aSTNode2, arrayList7);
        }
        if (bl) {
            return new EmptyMatrix(new MatrixDomain((ASTNode)new BooleanDomain(), arrayList2));
        }
        return new EmptyMatrix(new MatrixDomain((ASTNode)new IntegerDomain(new EmptyRange()), arrayList2));
    }

    void createSolutionFile(ASTNode aSTNode, String string) {
        if (!CmdFlags.getSolutionsToNull()) {
            if (CmdFlags.getSolutionsToStdout()) {
                System.out.println(aSTNode.toString());
                System.out.println("----------");
            } else if (CmdFlags.getSolutionsToStdoutOneLine()) {
                System.out.println("Solution: " + ((Solution)aSTNode).toStringOneLine().replaceAll("[\\t\\n\\r]", " "));
            } else {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                    bufferedWriter.write(aSTNode.toString());
                    bufferedWriter.close();
                    CmdFlags.println("Created solution file " + string);
                }
                catch (IOException iOException) {
                    CmdFlags.println("Could not open file for solution output.");
                }
            }
        }
    }

    void checkSolution(HashMap<String, Long> hashMap) {
        Model model = CmdFlags.checkSolModel;
        assert (model.constraints instanceof Top);
        ArrayList<ASTNode> arrayList = model.constraints.getChild(0) instanceof And ? model.constraints.getChild(0).getChildren() : model.constraints.getChildren();
        SubstituteAllValues substituteAllValues = new SubstituteAllValues(hashMap);
        TransformSimplify transformSimplify = new TransformSimplify();
        for (int i = 0; i < arrayList.size(); ++i) {
            ASTNode aSTNode = arrayList.get(i).copy();
            aSTNode = transformSimplify.transform(aSTNode);
            aSTNode = ((TreeTransformer)substituteAllValues).transform(aSTNode);
            if ((aSTNode = transformSimplify.transform(aSTNode)) instanceof BooleanConstant && aSTNode.getValue() == 1L) continue;
            CmdFlags.errorExit("When checking constraint: " + arrayList.get(i), "Constraint not satisfied by solver solution.", "Evaluation is:" + aSTNode);
        }
    }
}

