/*
 * Decompiled with CFR 0.152.
 */
package savilerow;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Random;
import savilerow.RepositoryVersion;
import savilerow.model.Model;

public final class CmdFlags {
    private static boolean verbose = false;
    private static String minionpath = "minion";
    private static String gecodepath = "fzn-gecode";
    private static String satsolverpath = null;
    private static String satfamily = "lingeling";
    private static boolean runsolver = false;
    private static boolean class_trans = false;
    private static boolean gecode_trans = false;
    private static boolean minizinc_trans = false;
    private static boolean minion_trans = false;
    private static boolean sat_trans = false;
    private static boolean use_mappers = true;
    private static boolean use_minionmappers = false;
    private static boolean use_cse = true;
    private static boolean use_ac_cse = false;
    private static boolean use_active_ac_cse = false;
    private static boolean use_active_cse = true;
    private static boolean use_ac_cse_alt = false;
    private static boolean use_sat_decomp_cse = false;
    private static boolean use_sat_alt = false;
    private static boolean make_tables = false;
    public static ArrayList<Integer> make_tables_scope;
    private static boolean use_var_symmetry_breaking;
    private static boolean use_eliminate_vars;
    private static boolean graph_col_sym_break;
    public static int accse_heuristic;
    public static boolean use_aggressive_ac_cse;
    public static boolean dryruns;
    private static boolean use_delete_vars;
    private static boolean use_propagate;
    private static boolean use_propagate_extend;
    private static boolean use_propagate_extend2;
    private static boolean remove_redundant_vars;
    private static boolean opt_warm_start;
    private static boolean find_all_solutions;
    private static long find_num_solutions;
    private static boolean solutions_to_stdout_one_line;
    private static boolean solutions_to_stdout;
    private static boolean solutions_to_null;
    private static boolean use_boundvars;
    private static int boundvar_threshold;
    private static boolean use_aggregate;
    private static boolean test_solutions;
    private static boolean output_ready;
    private static boolean after_aggregate;
    public static final int Normal = 1;
    public static final int ReadSolution = 2;
    public static final int Multi = 3;
    private static int seed;
    private static Random randomGen;
    private static int mode;
    private static String version;
    private static ArrayList<String> solverflags;
    private static String minionStatsTempFile;
    private static String minionSolsTempFile;
    public static volatile long startTime;
    public static String preprocess;
    public static String eprimefile;
    public static String paramfile;
    public static String paramstring;
    public static String solutionfile;
    public static String minionsolfile;
    public static String infofile;
    public static String minionfile;
    public static String dominionfile;
    public static String gecodefile;
    public static String minizincfile;
    public static String satfile;
    public static String auxfile;
    public static long timelimit;
    public static long cnflimit;
    public static volatile boolean runningSolver;
    public static LinkedHashMap<String, Integer> stats;
    public static Model checkSolModel;
    public static Model currentModel;
    private static int ctnum;

    public static Random getRandomGen() {
        if (randomGen == null) {
            randomGen = new Random(seed);
        }
        return randomGen;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setMinion(String string) {
        minionpath = string;
    }

    public static String getMinion() {
        return minionpath;
    }

    public static void setGecode(String string) {
        gecodepath = string;
    }

    public static String getGecode() {
        return gecodepath;
    }

    public static void setSatSolver(String string) {
        satsolverpath = string;
    }

    public static String getSatSolver() {
        return satsolverpath;
    }

    public static void setSatFamily(String string) {
        satfamily = string;
    }

    public static String getSatFamily() {
        return satfamily;
    }

    public static boolean getRunSolver() {
        return runsolver;
    }

    public static void setRunSolver() {
        runsolver = true;
    }

    public static String getPreprocess() {
        return preprocess;
    }

    public static void setPreprocess(String string) {
        preprocess = string;
    }

    public static long getTimeLimit() {
        return timelimit;
    }

    public static void setTimeLimit(long l) {
        timelimit = l;
    }

    public static long getCNFLimit() {
        return cnflimit;
    }

    public static void setCNFLimit(long l) {
        cnflimit = l;
    }

    public static void setEprimeFile(String string) {
        eprimefile = string;
    }

    public static void setParamFile(String string) {
        paramfile = string;
    }

    public static void setParamString(String string) {
        paramstring = string;
    }

    public static void setMinionFile(String string) {
        minionfile = string;
    }

    public static void setSatFile(String string) {
        satfile = string;
    }

    public static void setMinionSolutionFile(String string) {
        minionsolfile = string;
    }

    public static void setSolutionFile(String string) {
        solutionfile = string;
    }

    public static void setInfoFile(String string) {
        infofile = string;
    }

    public static void setAuxFile(String string) {
        auxfile = string;
    }

    public static void setDominionFile(String string) {
        dominionfile = string;
    }

    public static void setGecodeFile(String string) {
        gecodefile = string;
    }

    public static void setMinizincFile(String string) {
        minizincfile = string;
    }

    public static void printlnIfVerbose(Object object) {
        if (verbose) {
            System.out.println(object);
        }
    }

    public static String getMinionStatsTempFile() {
        return minionStatsTempFile;
    }

    public static String getMinionSolsTempFile() {
        return minionSolsTempFile;
    }

    public static void rmTempFiles() {
        File file = new File(CmdFlags.getMinionStatsTempFile());
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(CmdFlags.getMinionSolsTempFile())).exists()) {
            file.delete();
        }
    }

    public static void setSolverExtraFlags(ArrayList<String> arrayList) {
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals("")) continue;
            iterator.remove();
        }
        solverflags = arrayList;
    }

    public static ArrayList<String> getSolverExtraFlags() {
        if (solverflags == null) {
            return new ArrayList<String>();
        }
        return solverflags;
    }

    public static void setClasstrans() {
        class_trans = true;
    }

    public static boolean getClasstrans() {
        return class_trans;
    }

    public static void setUseDeleteVars(boolean bl) {
        use_delete_vars = bl;
    }

    public static boolean getUseDeleteVars() {
        return use_delete_vars;
    }

    public static void setUseEliminateVars(boolean bl) {
        use_eliminate_vars = bl;
    }

    public static boolean getUseEliminateVars() {
        return use_eliminate_vars;
    }

    public static void setOutputReady(boolean bl) {
        output_ready = bl;
    }

    public static boolean getOutputReady() {
        return output_ready;
    }

    public static void setAfterAggregate(boolean bl) {
        after_aggregate = bl;
    }

    public static boolean getAfterAggregate() {
        return after_aggregate;
    }

    public static void setUsePropagate(boolean bl) {
        use_propagate = bl;
    }

    public static boolean getUsePropagate() {
        return use_propagate;
    }

    public static void setUsePropagateExtend(boolean bl) {
        use_propagate_extend = bl;
        if (!bl) {
            use_propagate_extend2 = false;
        }
    }

    public static boolean getUsePropagateExtend() {
        return use_propagate_extend;
    }

    public static void setUsePropagateExtend2(boolean bl) {
        use_propagate_extend2 = bl;
    }

    public static boolean getUsePropagateExtend2() {
        return use_propagate_extend2;
    }

    public static void setRemoveRedundantVars(boolean bl) {
        remove_redundant_vars = bl;
    }

    public static boolean getRemoveRedundantVars() {
        return remove_redundant_vars;
    }

    public static void setUseAggregate(boolean bl) {
        use_aggregate = bl;
    }

    public static boolean getUseAggregate() {
        return use_aggregate;
    }

    public static void setUseVarSymBreaking(boolean bl) {
        use_var_symmetry_breaking = bl;
    }

    public static boolean getUseVarSymBreaking() {
        return use_var_symmetry_breaking;
    }

    public static void setFindAllSolutions(boolean bl) {
        find_all_solutions = bl;
    }

    public static boolean getFindAllSolutions() {
        return find_all_solutions;
    }

    public static void setSolutionsToStdoutOneLine(boolean bl) {
        solutions_to_stdout_one_line = bl;
    }

    public static boolean getSolutionsToStdoutOneLine() {
        return solutions_to_stdout_one_line;
    }

    public static void setSolutionsToStdout(boolean bl) {
        solutions_to_stdout = bl;
    }

    public static boolean getSolutionsToStdout() {
        return solutions_to_stdout;
    }

    public static void setSolutionsToNull(boolean bl) {
        solutions_to_null = bl;
    }

    public static boolean getSolutionsToNull() {
        return solutions_to_null;
    }

    public static void setFindNumSolutions(long l) {
        find_num_solutions = l;
    }

    public static long getFindNumSolutions() {
        return find_num_solutions;
    }

    public static void setUseBoundVars(boolean bl) {
        use_boundvars = bl;
    }

    public static boolean getUseBoundVars() {
        return use_boundvars;
    }

    public static int getBoundVarThreshold() {
        return boundvar_threshold;
    }

    public static void setGecodetrans() {
        gecode_trans = true;
    }

    public static boolean getGecodetrans() {
        return gecode_trans;
    }

    public static void setMiniontrans() {
        minion_trans = true;
    }

    public static boolean getMiniontrans() {
        return minion_trans;
    }

    public static void setMinizinctrans() {
        minizinc_trans = true;
    }

    public static boolean getMinizinctrans() {
        return minizinc_trans;
    }

    public static void setSattrans() {
        sat_trans = true;
    }

    public static boolean getSattrans() {
        return sat_trans;
    }

    public static void setSatAlt() {
        use_sat_alt = true;
    }

    public static boolean getSatAlt() {
        return use_sat_alt;
    }

    public static void setSatDecompCSE(boolean bl) {
        use_sat_decomp_cse = bl;
    }

    public static boolean getSatDecompCSE() {
        return use_sat_decomp_cse;
    }

    public static void setUseMappers(boolean bl) {
        use_mappers = bl;
    }

    public static boolean getUseMappers() {
        return use_mappers;
    }

    public static void setUseMinionMappers(boolean bl) {
        use_minionmappers = bl;
    }

    public static boolean getUseMinionMappers() {
        return use_minionmappers;
    }

    public static void setUseCSE(boolean bl) {
        use_cse = bl;
    }

    public static boolean getUseCSE() {
        return use_cse;
    }

    public static void setUseACCSE(boolean bl) {
        use_ac_cse = bl;
    }

    public static boolean getUseACCSE() {
        return use_ac_cse;
    }

    public static void setUseActiveACCSE(boolean bl) {
        use_active_ac_cse = bl;
        if (bl) {
            use_ac_cse = true;
        }
    }

    public static boolean getUseActiveACCSE() {
        return use_active_ac_cse;
    }

    public static void setUseAggressiveACCSE(boolean bl) {
        use_aggressive_ac_cse = bl;
    }

    public static boolean getUseAggressiveACCSE() {
        return use_aggressive_ac_cse;
    }

    public static void setUseActiveCSE(boolean bl) {
        use_active_cse = bl;
    }

    public static boolean getUseActiveCSE() {
        return use_active_cse;
    }

    public static void setUseACCSEAlt(boolean bl) {
        use_ac_cse_alt = bl;
    }

    public static boolean getUseACCSEAlt() {
        return use_ac_cse_alt;
    }

    public static int getMode() {
        return mode;
    }

    public static void setMode(int n) {
        mode = n;
    }

    public static boolean getTestSolutions() {
        return test_solutions;
    }

    public static boolean getMakeTables() {
        return make_tables;
    }

    public static boolean getOptWarmStart() {
        return opt_warm_start;
    }

    public static boolean getGraphColSymBreak() {
        return graph_col_sym_break;
    }

    public static void println(Object object) {
        System.out.println(object);
    }

    public static void errorExit(String string) {
        System.err.println("ERROR: " + string);
        CmdFlags.exit();
    }

    public static void errorExit(String string, String string2) {
        System.err.println("ERROR: " + string);
        System.err.println("ERROR: " + string2);
        CmdFlags.exit();
    }

    public static void errorExit(String string, String string2, String string3) {
        System.err.println("ERROR: " + string);
        System.err.println("ERROR: " + string2);
        System.err.println("ERROR: " + string3);
        CmdFlags.exit();
    }

    public static void exit() {
        CmdFlags.rmTempFiles();
        System.exit(1);
    }

    public static String getCtName() {
        return "con" + ++ctnum;
    }

    public static void parseArguments(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-O2");
        arrayList.addAll(Arrays.asList(stringArray));
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (!string.equals("-O0") && !string.equals("-O1") && !string.equals("-O2") && !string.equals("-O3")) continue;
            arrayList.remove(i);
            --i;
            if (string.equals("-O0")) {
                CmdFlags.setUseCSE(false);
                CmdFlags.setUseActiveCSE(false);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(false);
                CmdFlags.setUsePropagate(false);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(false);
                continue;
            }
            if (string.equals("-O1")) {
                CmdFlags.setUseCSE(true);
                CmdFlags.setUseActiveCSE(true);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(true);
                CmdFlags.setUsePropagate(false);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(false);
                continue;
            }
            if (string.equals("-O2")) {
                CmdFlags.setUseCSE(true);
                CmdFlags.setUseActiveCSE(true);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                CmdFlags.setUseDeleteVars(true);
                CmdFlags.setUsePropagate(true);
                CmdFlags.setUsePropagateExtend(false);
                CmdFlags.setUseAggregate(true);
                continue;
            }
            if (!string.equals("-O3")) continue;
            CmdFlags.setUseCSE(true);
            CmdFlags.setUseActiveCSE(true);
            CmdFlags.setUseACCSE(true);
            CmdFlags.setSatDecompCSE(true);
            CmdFlags.setUseACCSEAlt(false);
            CmdFlags.setUseDeleteVars(true);
            CmdFlags.setUsePropagate(true);
            CmdFlags.setUsePropagateExtend(false);
            CmdFlags.setUseAggregate(true);
        }
        while (arrayList.size() > 0) {
            int n;
            String string = (String)arrayList.get(0);
            arrayList.remove(0);
            if (string.equals("-v")) {
                CmdFlags.setVerbose(true);
                continue;
            }
            if (string.equals("-nomappers")) {
                CmdFlags.setUseMappers(false);
                continue;
            }
            if (string.equals("-minionmappers")) {
                CmdFlags.setUseMappers(false);
                CmdFlags.setUseMinionMappers(true);
                continue;
            }
            if (string.equals("-no-cse")) {
                CmdFlags.setUseCSE(false);
                CmdFlags.setUseActiveCSE(false);
                CmdFlags.setUseACCSE(false);
                CmdFlags.setSatDecompCSE(false);
                CmdFlags.setUseACCSEAlt(false);
                continue;
            }
            if (string.equals("-identical-cse")) {
                CmdFlags.setUseCSE(true);
                continue;
            }
            if (string.equals("-active-cse")) {
                CmdFlags.setUseActiveCSE(true);
                continue;
            }
            if (string.equals("-ac-cse")) {
                CmdFlags.setUseACCSE(true);
                CmdFlags.setSatDecompCSE(true);
                continue;
            }
            if (string.equals("-active-ac-cse")) {
                CmdFlags.setUseActiveACCSE(true);
                continue;
            }
            if (string.equals("-ac-cse-aggressive")) {
                CmdFlags.setUseAggressiveACCSE(true);
                continue;
            }
            if (string.equals("-ac-cse-heuristic")) {
                assert (arrayList.size() > 0) : "AC-CSE heuristic integer missing";
                accse_heuristic = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-ac-cse-alt")) {
                CmdFlags.setUseACCSEAlt(true);
                continue;
            }
            if (string.equals("-deletevars")) {
                CmdFlags.setUseDeleteVars(true);
                continue;
            }
            if (string.equals("-aggregate")) {
                CmdFlags.setUseAggregate(true);
                continue;
            }
            if (string.equals("-varelim")) {
                CmdFlags.setUseEliminateVars(true);
                continue;
            }
            if (string.equals("-reduce-domains")) {
                CmdFlags.setUsePropagate(true);
                continue;
            }
            if (string.equals("-reduce-domains-extend")) {
                CmdFlags.setUsePropagate(true);
                CmdFlags.setUsePropagateExtend(true);
                continue;
            }
            if (string.equals("-reduce-domains-extend2")) {
                CmdFlags.setUsePropagateExtend2(true);
                continue;
            }
            if (string.equals("-remove-redundant-vars")) {
                CmdFlags.setRemoveRedundantVars(true);
                continue;
            }
            if (string.equals("-graph-col-sym-break")) {
                graph_col_sym_break = true;
                continue;
            }
            if (string.equals("-opt-warm-start")) {
                opt_warm_start = true;
                continue;
            }
            if (string.equals("-make-tables")) {
                make_tables = true;
                assert (arrayList.size() > 0) : "-make-tables expects arguments specifying the scope.";
                int n2 = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                make_tables_scope = new ArrayList();
                for (n = 0; n < n2; ++n) {
                    assert (arrayList.size() > 0) : "-make-tables expects arguments specifying the scope.";
                    make_tables_scope.add(Integer.parseInt((String)arrayList.get(0)));
                    arrayList.remove(0);
                }
                continue;
            }
            if (string.equals("-preprocess")) {
                assert (arrayList.size() > 0) : "-preprocess expects an argument.\nOptions are: None, GAC, SAC, SSAC, SACBounds, SSACBounds";
                CmdFlags.setPreprocess((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-timelimit")) {
                assert (arrayList.size() > 0) : "-timelimit expects an argument in milliseconds.";
                CmdFlags.setTimeLimit(Integer.parseInt((String)arrayList.get(0)));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-cnflimit")) {
                assert (arrayList.size() > 0) : "-cnflimit expects an integer argument.";
                CmdFlags.setCNFLimit(Integer.parseInt((String)arrayList.get(0)));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-dryruns")) {
                dryruns = true;
                continue;
            }
            if (string.equals("-test-solutions")) {
                test_solutions = true;
                continue;
            }
            if (string.equals("-run-solver")) {
                CmdFlags.setRunSolver();
                continue;
            }
            if (string.equals("-all-solutions")) {
                CmdFlags.setFindAllSolutions(true);
                continue;
            }
            if (string.equals("-num-solutions")) {
                assert (arrayList.size() > 0) : "-num-solutions expects an argument: the number of solutions required.";
                long l = Long.parseLong((String)arrayList.get(0));
                if (l <= 0L) {
                    CmdFlags.errorExit("Argument to -num-solutions is less than one.");
                }
                CmdFlags.setFindNumSolutions(l);
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-solutions-to-stdout-one-line")) {
                CmdFlags.setSolutionsToStdoutOneLine(true);
                continue;
            }
            if (string.equals("-solutions-to-stdout")) {
                CmdFlags.setSolutionsToStdout(true);
                continue;
            }
            if (string.equals("-solutions-to-null")) {
                CmdFlags.setSolutionsToNull(true);
                continue;
            }
            if (string.equals("-no-bound-vars")) {
                CmdFlags.setUseBoundVars(false);
                continue;
            }
            if (string.equals("-var-sym-breaking")) {
                CmdFlags.setUseVarSymBreaking(true);
                continue;
            }
            if (string.equals("-minion")) {
                CmdFlags.setMiniontrans();
                continue;
            }
            if (string.equals("-gecode")) {
                CmdFlags.setGecodetrans();
                continue;
            }
            if (string.equals("-minizinc")) {
                CmdFlags.setMinizinctrans();
                continue;
            }
            if (string.equals("-dominion")) {
                CmdFlags.setClasstrans();
                continue;
            }
            if (string.equals("-sat")) {
                CmdFlags.setSattrans();
                continue;
            }
            if (string.equals("-sat-alt")) {
                CmdFlags.setSatAlt();
                continue;
            }
            if (string.equals("-sat-decomp-cse")) {
                CmdFlags.setSatDecompCSE(true);
                continue;
            }
            if (string.equals("-minion-bin")) {
                assert (arrayList.size() >= 1) : "Missing minion executable file name";
                CmdFlags.setMinion((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-satsolver-bin")) {
                assert (arrayList.size() >= 1) : "Missing SAT solver executable file name";
                CmdFlags.setSatSolver((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-sat-family")) {
                assert (arrayList.size() >= 1) : "Missing SAT family";
                String string2 = (String)arrayList.get(0);
                assert (string2.equals("minisat") || string2.equals("lingeling")) : "SAT family " + string2 + " not supported.";
                CmdFlags.setSatFamily((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-solver-options")) {
                assert (arrayList.size() > 0) : "Missing solver options string";
                ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(((String)arrayList.get(0)).split(" ")));
                for (n = 0; n < arrayList2.size(); ++n) {
                    if (!arrayList2.get(n).equals("")) continue;
                    arrayList2.remove(n);
                    --n;
                }
                CmdFlags.setSolverExtraFlags(arrayList2);
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-gecode-bin")) {
                assert (arrayList.size() >= 1) : "Missing Gecode executable file name";
                CmdFlags.setGecode((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-in-eprime")) {
                assert (arrayList.size() > 0) : ".eprime file missing";
                CmdFlags.setEprimeFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-in-param")) {
                assert (arrayList.size() > 0) : ".param file missing";
                CmdFlags.setParamFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-params")) {
                assert (arrayList.size() > 0) : "parameter string missing";
                CmdFlags.setParamString((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-minion")) {
                assert (arrayList.size() > 0) : "Minion output file name missing";
                CmdFlags.setMinionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-sat")) {
                assert (arrayList.size() > 0) : "SAT output file name missing";
                CmdFlags.setSatFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-minizinc")) {
                assert (arrayList.size() > 0) : "minizinc output file name missing";
                CmdFlags.setMinizincFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-solution")) {
                assert (arrayList.size() > 0) : "solution file name missing";
                CmdFlags.setSolutionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-info")) {
                assert (arrayList.size() > 0) : "statistics file name missing";
                CmdFlags.setInfoFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-aux")) {
                assert (arrayList.size() > 0) : "aux file name missing";
                CmdFlags.setAuxFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-minion-sol-file")) {
                assert (arrayList.size() > 0) : "missing Minion solution file name";
                CmdFlags.setMinionSolutionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-dominion")) {
                assert (arrayList.size() > 0) : "Missing Dominion output file name";
                CmdFlags.setDominionFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-out-gecode")) {
                assert (arrayList.size() > 0) : "Missing Gecode output file name";
                CmdFlags.setGecodeFile((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-seed")) {
                assert (arrayList.size() > 0) : "Missing value for seed";
                seed = Integer.parseInt((String)arrayList.get(0));
                arrayList.remove(0);
                continue;
            }
            if (string.equals("-mode")) {
                assert (arrayList.size() > 0) : "Missing mode argument";
                String string3 = (String)arrayList.get(0);
                if (string3.equals("Normal")) {
                    CmdFlags.setMode(1);
                } else if (string3.equals("ReadSolution")) {
                    CmdFlags.setMode(2);
                } else if (string3.equals("Multi")) {
                    CmdFlags.setMode(3);
                } else {
                    CmdFlags.errorExit("-mode argument not followed by Normal, ReadSolution or Multi.");
                }
                arrayList.remove(0);
                continue;
            }
            if (string.length() >= 7 && string.substring(string.length() - 7, string.length()).equals(".eprime") && eprimefile == null) {
                eprimefile = string;
                continue;
            }
            if (string.length() >= 6 && string.substring(string.length() - 6, string.length()).equals(".param") && paramfile == null) {
                paramfile = string;
                continue;
            }
            System.err.println("ERROR: Failed to parse the following argument: " + string);
            System.err.println("ERROR: Remaining arguments: " + arrayList);
            CmdFlags.printUsage();
            CmdFlags.exit();
        }
        if (CmdFlags.getMode() == 1 || CmdFlags.getMode() == 3) {
            if (eprimefile == null) {
                CmdFlags.println("ERROR: Not given Essence' model file.");
                CmdFlags.printUsage();
                CmdFlags.exit();
            }
            if (dominionfile == null) {
                String string = eprimefile;
                if (string.substring(string.length() - 7, string.length()).equals(".eprime")) {
                    string = string.substring(0, string.length() - 7);
                }
                dominionfile = string + ".dominion";
            }
            if (minionfile == null) {
                minionfile = paramfile != null ? paramfile + ".minion" : eprimefile + ".minion";
            }
            if (satfile == null) {
                satfile = paramfile != null ? paramfile + ".dimacs" : eprimefile + ".dimacs";
            }
            if (auxfile == null) {
                auxfile = paramfile != null ? paramfile + ".aux" : eprimefile + ".aux";
            }
            if (gecodefile == null) {
                gecodefile = paramfile != null ? paramfile + ".fzn" : eprimefile + ".fzn";
            }
            if (solutionfile == null) {
                solutionfile = paramfile != null ? paramfile + ".solution" : eprimefile + ".solution";
            }
            if (infofile == null) {
                infofile = paramfile != null ? paramfile + ".info" : eprimefile + ".info";
            }
            if (minizincfile == null) {
                minizincfile = paramfile != null ? paramfile + ".mzn" : eprimefile + ".mzn";
            }
            if (satsolverpath == null) {
                satsolverpath = satfamily;
            }
            if (!(CmdFlags.getMinizinctrans() || CmdFlags.getGecodetrans() || CmdFlags.getClasstrans())) {
                CmdFlags.setMiniontrans();
            }
        } else if (CmdFlags.getMode() == 2) {
            if (auxfile == null) {
                CmdFlags.errorExit("When using ReadSolution mode, -out-aux must be used to specify the .aux file.");
            }
            if (solutionfile == null) {
                CmdFlags.errorExit("When using ReadSolution mode, -out-solution must be used to specify the name for the Essence' solution file(s).");
            }
            if (minionsolfile == null) {
                CmdFlags.errorExit("When using ReadSolution mode, -minion-sol-file must be used to specify the name of the Minion solution table file.");
            }
        } else assert (false) : "Mode not recognised";
    }

    public static void printUsage() {
        System.out.println("Savile Row " + version + " (Repository Version: " + RepositoryVersion.repositoryVersion + ")\n" + "Specifying the input files (for Normal mode):\n" + "\n" + "  -in-eprime <filename>          :   Specifies file name for Essence' constraint model file.\n" + "                                     If the file name ends with .eprime, it may be used directly\n" + "                                     on the command line without the -in-eprime flag.\n" + "\n" + "  -in-param <filename>           :   Specifies file name for Essence' parameter file\n" + "                                     If the file name ends with .param, it may be used directly\n" + "                                     on the command line without the -in-param flag.\n" + "\n" + "  -params <string>               :   Specifies Essence' parameters on the command line.\n" + "                                     The format of <string> is the same as for a parameter file (where,\n" + "                                     incidentally, the language line is optional so a parameter file can\n" + "                                     contain only letting statements). \n" + "                                     The string should contain statements \"letting identifier be value\"\n" + "                                     or \"letting identifier=value\". \n" + "                                     For example: \n" + "                                     -params \"letting n_nurses=4 letting Demand=[[1,0,1,0],[0,2,1,0]]\"\n" + "\n" + "Specifying output format (for Normal mode):\n" + "\n" + "  -minion  (default)             :   Create output in Minion 3 format.\n" + "                                     This format is flat for numerical expressions and non-flat for And and Or since\n" + "                                     these are implemented using watched-and and watched-or metaconstraints.\n" + "\n" + "  -gecode                        :   Create output in Flatzinc suitable for Gecode's fzn-gecode tool.\n" + "                                     This uses the same translation pipeline as Minion output as far as possible.\n" + "                                     The main differences are that the model is entirely flat and some constraints\n" + "                                     are rewritten where required for reification.\n" + "\n" + "  -minizinc                      :   Create output in a partly flat, instance-level subset of the Minizinc language.\n" + "                                     This allows access via mzn2fzn to several solvers.\n" + "                                     The output is as close as possible to the Minion 3 output.\n" + "\n" + "  -sat                           :   Create SAT output in DIMACS format for use by a SAT solver.\n" + "\n" + "  -dominion                      :   Create output in the Dominion Input Language (experimental)\n" + "                                     Perform class-level flattening if necessary (i.e. if some parameters are\n" + "                                     not instantiated) and produce output in the Dominion Input Language.\n" + "                                     This uses a separate translation pipeline from Minion, Gecode and Minizinc output.\n" + "\n" + "Output file options (each has a default value so none of these are required):\n" + "\n" + "  -out-minion <filename>         :   Specifies file name for Minion output.\n" + "  -out-gecode <filename>         :   Specifies file name for Gecode (flatzinc) output.\n" + "  -out-minizinc <filename>       :   Specifies file name for Minizinc output.\n" + "  -out-sat <filename>            :   Specifies file name for SAT (DIMACS) output.\n" + "  -out-dominion <filename>       :   Specifies file name for Dominion output.\n" + "\n" + "  -out-solution <filename>       :   Specifies file name for output of the solution if Savile Row runs a solver and\n" + "                                     parses the solver's output.\n" + "  -out-info <filename>           :   Specifies file name for output of info file (statistics from Savile Row and Minion).\n" + "  -out-aux <filename>            :   Specifies file name for the .aux file containing the symbol table.\n" + "                                     The .aux file is required for ReadSolution mode.\n" + "\n" + "Optimisation levels:\n" + "\n" + "  -O0                            :   Optimisation level 0. Switches off all optional optimisations, however Savile Row\n" + "                                     will still simplify expressions. For example, the boolean expression\n" + "                                     3+4=10 would simplify to false.\n" + "  -O1                            :   Optimisation level 1. Applies optimisations that are very efficient in both space and time.\n" + "                                     Currently -O1 is equivalent to -active-cse and -deletevars.\n" + "  -O2  (default)                 :   Optimisation level 2. Applies a generally recommended set of optimisations.\n" + "                                     Currently -O2 is equivalent to -active-cse, -deletevars, -reduce-domains and -aggregate.\n" + "                                     Optimisation level 2 requires Minion to be available to filter variable domains.\n" + "  -O3                            :   Optimisation level 3. Applies most available optimisations.\n" + "                                     Currently -O3 is equivalent to -active-cse, -deletevars, -reduce-domains, \n" + "                                     -ac-cse and -aggregate.\n" + "\n" + "Translation Options:\n" + "\n" + "  -no-cse                        :   Switches off all common subexpression elimination (CSE).\n" + "  -identical-cse                 :   Switches on Identical CSE. This matches identical subexpressions only.\n" + "  -ac-cse                        :   Switches on Associative-Commutative CSE (AC-CSE) for the operators And (/\\), Or (\\/),\n" + "                                     Product and Sum. AC-CSE exploits associativity and commutativity to reveal common\n" + "                                     subexpressions.\n" + "  -active-cse                    :   Switches on Active CSE. May be used with the option above.\n" + "                                     Active CSE attempts to match expressions that are semantically equivalent after some\n" + "                                     simple transformation such as Boolean negation.\n" + "  -active-ac-cse                 :   Switches on Active AC-CSE. This extends AC-CSE on sums by matching subexpressions where\n" + "                                     one subexpression is the negation of another. For example it able to extract \n" + "                                     x+y from the expressions x+y+z, w-x-y and 10-x-y.\n" + "                                     Active AC-CSE is identical to AC-CSE on And, Or and Product.\n" + "  -deletevars                    :   Switch on variable deletion for variables that are equal to a constant or equal to\n" + "                                     another decision variable.\n" + "  -reduce-domains                :   This option filters the domains of the 'find' decision variables. This option only functions\n" + "                                     when Minion is available. It calls Minion to perform SACBounds preprocessing, a\n" + "                                     restricted form of SAC where the SAC test is applied to the upper and lower bound\n" + "                                     of each variable.\n" + "  -reduce-domains-extend         :   An extension of -reduce-domains that filters the domains of auxiliary variables as\n" + "                                     well as 'find' variables.\n" + "  -aggregate                     :   Collect constraints into global constraints where possible. Currently performs two\n" + "                                     types of aggregation: constructing AllDifferent constraints from not-equal, less-than\n" + "                                     and shorter AllDifferents, and constructing GCC from atleast and atmost.\n" + "  -nomappers                     :   When translating to Dominion, do not use mappers (views).\n" + "  -minionmappers                 :   When translating to Dominion, only use mappers when a comparable mapped constraint is\n" + "                                     also available in Minion (e.g. multiplication mappers inside a sum constraint are\n" + "                                     allowed because Minion contains a weighted sum constraint).\n" + "  -no-bound-vars                 :   When translating to Minion, never use Minion's BOUND type variables. Instead always use\n" + "                                     DISCRETE even for very large domains. The default behaviour is to use DISCRETE for domains\n" + "                                     of size less than or equal to 10,000, and BOUND when the domain is larger than 10,000.\n" + "                                     Using BOUND type variables can reduce the level of consistency enforced for some\n" + "                                     constraints.\n" + "  -remove-redundant-vars         :   Remove redundant vars by adding a constraint assigning any variables that are not\n" + "                                     mentioned in any existing constraint or the objective function.\n" + "                                     It is off by default.\n" + "                                     Note that enabling this flag may lose solutions.\n" + "\n" + "Controlling Savile Row:\n" + "  -timelimit <time>              :   Specifies a time limit in milliseconds. Savile Row will stop when the time limit is\n" + "                                     reached, unless it has completed the translation and is running a solver to find a\n" + "                                     solution. The time measured is wallclock time not CPU time.\n" + "                                     To apply a time limit to Minion as well as Savile Row, use\n" + "                                     -solver-options \"-cpulimit <time>\"\n" + "  -cnflimit <size>               :   Limit the number of clauses in the SAT output file to a maximum of <size>.\n" + "  -seed <integer>                :   Some transformations use a pseudorandom number generator, this option allows setting the seed value.\n" + "\n" + "Solver control:\n" + "  -run-solver                    :   Run the selected solver and parse its output. Currently implemented for\n" + "                                     Minion and Gecode.\n" + "  -all-solutions                 :   Find all solutions. These are output in a sequence of numbered files,\n" + "                                     for example, nurses.param.solution.000001 to nurses.param.solution.000871\n" + "                                     This option cannot be used on optimisation problems.\n" + "  -num-solutions <n>             :   Find <n> solutions. These are output in a sequence of numbered files,\n" + "                                     for example, nurses.param.solution.000001 to nurses.param.solution.000050\n" + "                                     This option cannot be used on optimisation problems.\n" + "  -solutions-to-stdout           :   Instead of writing solutions to files, send them to stdout separated by\n" + "                                     a line of 10 minus signs.\n" + "  -solutions-to-null             :   Do not output solutions in any way.\n" + "  -solver-options <string>       :   Pass through some additional command-line options to the solver.\n" + "\n" + "Solver control -- Minion:\n" + "  -minion-bin <filename>         :   Tell Savile Row where the Minion binary is. Default is to use the Minion binary\n" + "                                     included in the Savile Row distribution.\n" + "  -preprocess                    :   Specifies preprocessing option to be passed to Minion both for solving (when\n" + "                                     using -run-solver) and for domain filtering (when using -reduce-domains or -O2\n" + "                                     or higher).\n" + "                                     Possible values: None, GAC, SAC, SSAC, SACBounds, SSACBounds.\n" + "                                     By default GAC will be used when there are large variable domains, otherwise\n" + "                                     SACBounds will be used.\n" + "\n" + "Solver control -- Gecode:\n" + "  -gecode-bin <filename>         :   Tell Savile Row the command to run the Gecode Flatzinc binary (default is \"fzn-gecode\").\n" + "\n" + "Solver control -- SAT solver:\n" + "  -sat-family <name>             :   Specify the family of the SAT solver (one of \"minisat\", \"lingeling\").\n" + "                                     Allows Savile Row to parse the output of the solver when using the -run-solver flag.\n" + "                                     Default is \"lingeling\".\n" + "  -satsolver-bin <filename>      :   Tell Savile Row where the SAT solver binary is.\n" + "                                     Default is \"lingeling\" when the SAT family is lingeling, and \"minisat\" otherwise.\n" + "\n" + "Specifying mode of operation:\n" + "  -mode [Normal | ReadSolution]  :   Normal mode reads an Essence' model file and optional parameter file\n" + "                                     and produces output for a constraint solver. It may also run a solver\n" + "                                     and parse the solutions.\n" + "                                     ReadSolution mode takes a solution table file created by Minion and\n" + "                                     produces an Essence' solution file. If the solution table file contains\n" + "                                     multiple solutions, the flag -all-solutions can be used to parse them all,\n" + "                                     or the flag -num-solutions <n> may be used to parse the first n solutions.\n" + "  -minion-sol-file <filename>    :   Specifies the solution table file (produced by Minion's -solsout flag).\n" + "                                     In ReadSolution mode, the flags -out-aux and -out-solution are required,\n" + "                                     the first so that Savile Row can load its symbol table that was saved when\n" + "                                     translating the problem instance, and the second to specify where to write\n" + "                                     the solutions. The flags -all-solutions and -num-solutions are optional in\n" + "                                     ReadSolution mode.\n" + "\n" + "Examples:\n" + "\n" + "    ./savilerow examples/sudoku/sudoku.eprime examples/sudoku/sudoku.param -run-solver\n" + "    Runs Savile Row on the Sudoku puzzle example, with default optimisation (-O2) and\n" + "    the default solver (Minion). Minion is called twice, first to filter the variable\n" + "    domains and second to solve the problem instance.\n" + "\n" + "    ./savilerow examples/carSequencing/carSequencing.eprime examples/carSequencing/carSequencing10.param -O3 -sat -run-solver\n" + "    Runs Savile Row on an instance of car sequencing, using the highest level of\n" + "    optimisation (-O3) and targeting SAT. No SAT solver is specified so the default\n" + "    (lingeling) will be used. Requires the 'lingeling' SAT solver binary to be in\n" + "    the path.\n");
    }

    static {
        use_var_symmetry_breaking = false;
        use_eliminate_vars = false;
        graph_col_sym_break = false;
        accse_heuristic = 1;
        use_aggressive_ac_cse = false;
        dryruns = false;
        use_delete_vars = true;
        use_propagate = true;
        use_propagate_extend = false;
        use_propagate_extend2 = false;
        remove_redundant_vars = false;
        opt_warm_start = false;
        find_all_solutions = false;
        find_num_solutions = -1L;
        solutions_to_stdout_one_line = false;
        solutions_to_stdout = false;
        solutions_to_null = false;
        use_boundvars = true;
        boundvar_threshold = 10000;
        use_aggregate = true;
        test_solutions = false;
        output_ready = false;
        after_aggregate = false;
        seed = 1234;
        randomGen = null;
        mode = 1;
        version = "1.6.5";
        minionStatsTempFile = ".MINIONSTATS" + System.currentTimeMillis() + Math.abs(new Random().nextInt());
        minionSolsTempFile = ".MINIONSOLS" + System.currentTimeMillis() + Math.abs(new Random().nextInt());
        startTime = System.currentTimeMillis();
        preprocess = null;
        eprimefile = null;
        paramfile = null;
        paramstring = null;
        solutionfile = null;
        minionsolfile = null;
        infofile = null;
        minionfile = null;
        dominionfile = null;
        gecodefile = null;
        minizincfile = null;
        satfile = null;
        auxfile = null;
        timelimit = 0L;
        cnflimit = 0L;
        runningSolver = false;
        stats = new LinkedHashMap();
        ctnum = 0;
    }
}

