/*
 * Decompiled with CFR 0.152.
 */
package savilerow.eprimeparser;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeSyntaxException;
import savilerow.eprimeparser.EPrimeTokenizer;
import savilerow.eprimeparser.ShuntingYard;
import savilerow.expression.ASTNode;
import savilerow.expression.Absolute;
import savilerow.expression.AllDifferent;
import savilerow.expression.AllDifferentExcept;
import savilerow.expression.And;
import savilerow.expression.AndVector;
import savilerow.expression.AtLeast;
import savilerow.expression.AtMost;
import savilerow.expression.AuxBubble;
import savilerow.expression.BinOpPlaceholder;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomain;
import savilerow.expression.Bubble;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.ComprehensionForall;
import savilerow.expression.ComprehensionMatrix;
import savilerow.expression.Concatenate;
import savilerow.expression.ConcatenateMatrix;
import savilerow.expression.Container;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.ExistsExpression;
import savilerow.expression.Factorial;
import savilerow.expression.Find;
import savilerow.expression.Flatten;
import savilerow.expression.ForallExpression;
import savilerow.expression.Given;
import savilerow.expression.GlobalCard;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.MatrixSlice;
import savilerow.expression.Max;
import savilerow.expression.MaxVector;
import savilerow.expression.Maximising;
import savilerow.expression.Min;
import savilerow.expression.MinVector;
import savilerow.expression.Minimising;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.OrVector;
import savilerow.expression.Power;
import savilerow.expression.QuantifiedSum;
import savilerow.expression.Range;
import savilerow.expression.SumVector;
import savilerow.expression.Table;
import savilerow.expression.TimesVector;
import savilerow.expression.Top;
import savilerow.expression.UnaryMinus;
import savilerow.expression.Union;
import savilerow.expression.Where;
import savilerow.model.Model;
import savilerow.model.SymbolTable;

public final class EPrimeReader {
    private EPrimeTokenizer tokens;
    private static final boolean VB_MTDS = false;
    static String[] ops = new String[]{"+", "-", "/", "*", "**", "%", "\\/", "/\\", "=>", "->", "<=>", "<->", "=", "!=", "<=", "<", ">=", ">", "<lex", "<=lex", ">lex", ">=lex", "union", "intersect", "in"};
    static String[] keywds = new String[]{"forall", "forAll", "exists", "sum", "such", "that", "letting", "given", "where", "find", "language", "int", "bool", "union", "intersect", "in", "false", "true"};
    private SymbolTable global_symbols;
    private ASTNode branchingon;
    private String heuristic;
    private HashSet<String> binops;
    private HashSet<String> keywords;
    private HashMap<String, FunctionDescription> funcs;

    public EPrimeReader(String string) {
        this.tokens = new EPrimeTokenizer(string);
        this.binops = new HashSet<String>(Arrays.asList(ops));
        this.global_symbols = new SymbolTable();
        this.keywords = new HashSet<String>(Arrays.asList(keywds));
        this.funcs = new HashMap();
        this.funcs.put("toSet", new FunctionDescription("ToSet", 1));
        this.funcs.put("popcount", new FunctionDescription("Popcount", 1));
        this.funcs.put("toInt", new FunctionDescription("ToInt", 1));
    }

    public EPrimeReader(String string, boolean bl) {
        assert (bl);
        this.tokens = new EPrimeTokenizer(string, true);
        this.binops = new HashSet<String>(Arrays.asList(ops));
        this.global_symbols = new SymbolTable();
        this.keywords = new HashSet<String>(Arrays.asList(keywds));
        this.funcs = new HashMap();
        this.funcs.put("toSet", new FunctionDescription("ToSet", 1));
        this.funcs.put("popcount", new FunctionDescription("Popcount", 1));
        this.funcs.put("toInt", new FunctionDescription("ToInt", 1));
    }

    public Model readModel() {
        ASTNode aSTNode = null;
        ASTNode aSTNode2 = null;
        try {
            this.tokens.mark("model1");
            this.readHeader();
            this.tokens.commit("Read header line successfully.");
            this.readDeclarations();
            try {
                this.tokens.mark("model2");
                aSTNode2 = this.readObjective();
                this.tokens.eraseMark("model2");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("model2");
            }
            aSTNode = this.readConstraints();
            this.tokens.eraseMark("model1");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("model1");
            CmdFlags.errorExit("Failed to read header line. Expected the following:  language ESSENCE' 1.0");
        }
        return new Model(aSTNode, this.global_symbols, aSTNode2, this.branchingon, this.heuristic);
    }

    public ArrayList<ASTNode> readParameterFile(Model model) {
        this.global_symbols = model.global_symbols;
        this.branchingon = null;
        this.heuristic = null;
        try {
            this.tokens.mark("paramhead");
            this.readHeader();
            this.tokens.eraseMark("paramhead");
            this.tokens.commit("Successfully parsed language line.");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("paramhead");
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            while (true) {
                this.tokens.mark("param");
                try {
                    this.tokens.mark("rpf");
                    ASTNode aSTNode = this.readLetting();
                    arrayList.add(aSTNode);
                    this.tokens.eraseMark("rpf");
                    this.tokens.commit("Successfully parsed letting statement.");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException) {
                    this.tokens.reset("rpf");
                    try {
                        this.tokens.mark("rpf2");
                        this.readHeuristic();
                        this.tokens.eraseMark("rpf2");
                        this.tokens.commit("Successfully parsed heuristic.");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                        this.tokens.reset("rpf2");
                        this.readBranchingOn();
                        this.tokens.commit("Successfully parsed branching on statement.");
                    }
                }
                this.tokens.eraseMark("param");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("param");
            try {
                this.tokens.nextToken();
                if (this.tokens.tokenType == 3) {
                    if (this.heuristic != null) {
                        if (model.heuristic != null) {
                            CmdFlags.println("WARNING: Parameter file overrides 'heuristic' statement in model file.");
                        }
                        model.heuristic = this.heuristic;
                    }
                    if (this.branchingon != null) {
                        if (model.branchingon != null) {
                            CmdFlags.println("WARNING: Parameter file overrides 'branching on' statement in model file.");
                        }
                        model.branchingon = this.branchingon;
                    }
                    return arrayList;
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                // empty catch block
            }
            this.tokens.raiseError();
            return null;
        }
    }

    private void readHeader() throws EPrimeSyntaxException {
        this.readTerminalString("language");
        try {
            this.tokens.mark("ess");
            this.readTerminalString("ESSENCE'");
            this.tokens.eraseMark("ess");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("ess");
            this.readTerminalString("Essence");
        }
        this.readInt();
        this.readTerminalString(".");
        this.readInt();
    }

    private void readDeclarations() throws EPrimeSyntaxException {
        try {
            while (true) {
                this.readDeclaration();
                this.tokens.commit("Successfully parsed declaration.");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            return;
        }
    }

    private void readDeclaration() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            this.readGiven();
            this.tokens.eraseMark();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readWhere();
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                try {
                    this.tokens.mark();
                    ASTNode aSTNode = this.readLetting();
                    this.tokens.eraseMark();
                    this.global_symbols.lettings_givens.add(aSTNode);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset();
                    try {
                        this.tokens.mark();
                        this.readFind();
                        this.tokens.eraseMark();
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset();
                        try {
                            this.tokens.mark();
                            this.readBranchingOn();
                            this.tokens.eraseMark();
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset();
                            try {
                                this.tokens.mark();
                                this.readHeuristic();
                                this.tokens.eraseMark();
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset();
                                throw new EPrimeSyntaxException("Given, Where, Letting, Find, Branching on, Heuristic", "expression beginning: " + this.tokens.toString());
                            }
                        }
                    }
                }
            }
        }
    }

    private void readGiven() throws EPrimeSyntaxException {
        this.readTerminalString("given");
        this.tokens.commit("Parsed 'given' keyword.");
        ASTNode aSTNode = this.readIdList();
        try {
            this.tokens.mark("given");
            this.readTerminalString(":");
            this.tokens.commit("Parsed 'given ... :'.");
            ASTNode aSTNode2 = this.readDomain();
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            for (ASTNode aSTNode3 : arrayList) {
                this.global_symbols.lettings_givens.add(new Given(aSTNode3, aSTNode2));
            }
            this.tokens.eraseMark("given");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("given");
            this.readTerminalString("new");
            this.readTerminalString("domain");
            this.readTerminalString("int");
            this.tokens.commit("Successfully parsed 'given ... new domain int'.");
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            for (ASTNode aSTNode4 : arrayList) {
                this.global_symbols.lettings_givens.add(new Given(aSTNode4, new IntegerDomain(new Range(null, null))));
            }
        }
    }

    private void readWhere() throws EPrimeSyntaxException {
        this.readTerminalString("where");
        this.tokens.commit("Successfully parsed 'where' keyword.");
        ASTNode aSTNode = this.readExpression();
        this.global_symbols.lettings_givens.add(new Where(aSTNode));
    }

    private ASTNode readLetting() throws EPrimeSyntaxException {
        this.readTerminalString("letting");
        this.tokens.commit("Parsed 'letting' keyword.");
        ASTNode aSTNode = this.readIdentifier();
        this.tokens.commit("Parsed 'letting' keyword and identifier.");
        try {
            this.tokens.mark("rl");
            this.readTerminalString("be");
            this.readTerminalString("domain");
            this.tokens.commit("Successfully parsed 'letting ... be domain'.");
            ASTNode aSTNode2 = this.readDomain();
            this.tokens.eraseMark("rl");
            return new Letting(aSTNode, aSTNode2);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            ASTNode aSTNode3;
            this.tokens.reset("rl");
            try {
                this.tokens.mark("rldom");
                this.readTerminalString(":");
                this.tokens.commit("Successfully parsed 'letting ... :'.");
                aSTNode3 = this.readDomain();
                this.tokens.eraseMark("rldom");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("rldom");
                aSTNode3 = null;
            }
            try {
                this.tokens.mark("rlp");
                this.readTerminalString("be");
                this.tokens.eraseMark("rlp");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("rlp");
                this.readTerminalString("=");
            }
            this.tokens.commit("Successfully parsed 'letting ... be'.");
            ASTNode aSTNode4 = null;
            try {
                this.tokens.mark("quick");
                aSTNode4 = this.readQuickConstantMatrixNotDeref();
                this.tokens.eraseMark("quick");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                this.tokens.reset("quick");
            }
            if (aSTNode4 == null) {
                aSTNode4 = this.readExpression();
            }
            this.tokens.commit("Letting statement read successfully");
            if (aSTNode3 == null) {
                return new Letting(aSTNode, aSTNode4);
            }
            return new Letting(aSTNode, aSTNode4, aSTNode3);
        }
    }

    private void readFind() throws EPrimeSyntaxException {
        this.readTerminalString("find");
        this.tokens.commit("Parsed 'find' keyword.");
        ASTNode aSTNode = this.readIdList();
        this.tokens.commit("Parsed 'find' keyword and list of identifiers.");
        this.readTerminalString(":");
        this.tokens.commit("Parsed 'find ... :'.");
        ASTNode aSTNode2 = this.readDomain();
        ArrayList<ASTNode> arrayList = aSTNode.getChildren();
        for (ASTNode aSTNode3 : arrayList) {
            this.global_symbols.lettings_givens.add(new Find(aSTNode3, aSTNode2.copy()));
        }
    }

    private void readBranchingOn() throws EPrimeSyntaxException {
        this.readTerminalString("branching");
        this.readTerminalString("on");
        this.tokens.commit("Parsed 'branching on'.");
        this.readTerminalString("[");
        this.tokens.commit("Parsed 'branching on ['.");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark("bo");
                arrayList.add(this.readPartExpression());
                this.tokens.eraseMark("bo");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("bo");
                break;
            }
            try {
                this.tokens.mark("comma");
                this.readTerminalString(",");
                this.tokens.eraseMark("comma");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("comma");
                break;
            }
        }
        this.readTerminalString("]");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((ASTNode)arrayList.get(i)).getDimension() == 0) {
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                arrayList2.add(arrayList.get(i));
                arrayList.set(i, new CompoundMatrix(arrayList2));
            }
            arrayList.set(i, new Flatten(arrayList.get(i)));
        }
        if (this.branchingon != null) {
            throw new EPrimeSyntaxException("At most one 'branching on' statement.", "A second 'branching on' statement.");
        }
        this.branchingon = new Concatenate(arrayList);
    }

    private void readHeuristic() throws EPrimeSyntaxException {
        this.readTerminalString("heuristic");
        this.tokens.commit("Successfully parsed 'heuristic' keyword.");
        String string = this.readTerminalString();
        String string2 = null;
        if (string.equals("static")) {
            string2 = "STATIC";
        } else if (string.equals("sdf")) {
            string2 = "SDF";
        } else if (string.equals("conflict")) {
            string2 = "CONFLICT";
        } else if (string.equals("srf")) {
            string2 = "SRF";
        }
        if (string2 == null) {
            throw new EPrimeSyntaxException("static, sdf, conflict or srf", string);
        }
        if (this.heuristic != null) {
            throw new EPrimeSyntaxException("At most one 'heuristic' statement.", "A second 'heuristic' statement.");
        }
        this.heuristic = string2;
    }

    private ASTNode readDomain() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("dom");
            ASTNode aSTNode = this.readMatrixDomain();
            this.tokens.eraseMark("dom");
            return aSTNode;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("dom");
            return this.readSimpleDomain();
        }
    }

    private ASTNode readSimpleDomain() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.readPartSimpleDomain());
        try {
            while (true) {
                this.tokens.mark("rsd");
                ASTNode aSTNode = this.readSimpleDomainBinOp();
                ASTNode aSTNode2 = this.readPartSimpleDomain();
                this.tokens.eraseMark("rsd");
                arrayList.add(aSTNode);
                arrayList.add(aSTNode2);
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rsd");
            ShuntingYard shuntingYard = new ShuntingYard();
            ASTNode aSTNode = shuntingYard.convertToTree(arrayList);
            return aSTNode;
        }
    }

    private ASTNode readPartSimpleDomain() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("atom");
            ASTNode aSTNode = this.readSimpleDomainAtom();
            this.tokens.eraseMark("atom");
            return aSTNode;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("atom");
            this.readTerminalString("(");
            ASTNode aSTNode = this.readSimpleDomain();
            this.readTerminalString(")");
            return aSTNode;
        }
    }

    private ASTNode readSimpleDomainAtom() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("rsd");
            this.readTerminalString("bool");
            this.tokens.eraseMark("rsd");
            return new BooleanDomain();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rsd");
            try {
                this.tokens.mark("rsd2");
                this.readTerminalString("int");
                try {
                    ASTNode aSTNode;
                    this.tokens.mark("rsd3");
                    this.readTerminalString("(");
                    try {
                        this.tokens.mark("rsd5");
                        aSTNode = this.readUnboundedSetOfRanges();
                        this.tokens.eraseMark("rsd5");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                        this.tokens.reset("rsd5");
                        aSTNode = new IntegerDomain(new EmptyRange());
                    }
                    this.readTerminalString(")");
                    this.tokens.eraseMark("rsd3");
                    this.tokens.eraseMark("rsd2");
                    return aSTNode;
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("rsd3");
                    this.tokens.eraseMark("rsd2");
                    return new IntegerDomain(new Range(null, null));
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                this.tokens.reset("rsd2");
                ASTNode aSTNode = this.readIdentifier();
                return aSTNode;
            }
        }
    }

    private ASTNode readSimpleDomainBinOp() throws EPrimeSyntaxException {
        if (this.tryReadTerminalString("intersect")) {
            return new BinOpPlaceholder("intersect");
        }
        if (this.tryReadTerminalString("union")) {
            return new BinOpPlaceholder("union");
        }
        if (this.tryReadTerminalString("-")) {
            return new BinOpPlaceholder("-");
        }
        throw new EPrimeSyntaxException("intersect, union or -", "");
    }

    private ASTNode readMatrixDomain() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.readTerminalString("matrix");
        this.tokens.commit("Successfully parsed 'matrix' keyword.");
        this.readTerminalString("indexed");
        this.readTerminalString("by");
        this.tokens.commit("Successfully parsed 'matrix indexed by'.");
        this.readTerminalString("[");
        arrayList.add(this.readDomain());
        this.tokens.commit("Parsed 'matrix indexed by [...'.");
        try {
            while (true) {
                this.tokens.mark("rmdom");
                this.readTerminalString(",");
                this.tokens.commit("Parsed 'matrix indexed by [... ,'.");
                ASTNode aSTNode = this.readDomain();
                this.tokens.commit("Parsed 'matrix indexed by [...'.");
                this.tokens.eraseMark("rmdom");
                arrayList.add(aSTNode);
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rmdom");
            this.readTerminalString("]");
            this.readTerminalString("of");
            this.tokens.commit("Successfully parsed 'matrix indexed by ... of'.");
            ASTNode aSTNode = this.readSimpleDomain();
            return new MatrixDomain(aSTNode, arrayList);
        }
    }

    private ASTNode readObjective() throws EPrimeSyntaxException {
        ASTNode aSTNode = null;
        try {
            this.tokens.mark();
            aSTNode = this.readMaximising();
            this.tokens.eraseMark();
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                aSTNode = this.readMinimising();
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                throw new EPrimeSyntaxException("Objective", this.tokens.toString());
            }
        }
        return aSTNode;
    }

    private ASTNode readMinimising() throws EPrimeSyntaxException {
        this.readTerminalString("minimising");
        this.tokens.commit("Successfully parsed 'minimising' keyword.");
        ASTNode aSTNode = this.readExpression();
        return new Minimising(aSTNode);
    }

    private ASTNode readMaximising() throws EPrimeSyntaxException {
        this.readTerminalString("maximising");
        this.tokens.commit("Successfully parsed 'maximising' keyword.");
        ASTNode aSTNode = this.readExpression();
        return new Maximising(aSTNode);
    }

    private ASTNode readConstraints() throws EPrimeSyntaxException {
        this.readTerminalString("such");
        this.readTerminalString("that");
        this.tokens.commit("Successfully parsed 'such that'.");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            this.tokens.mark("con1");
            arrayList.add(this.readExpression());
            this.tokens.eraseMark("con1");
            try {
                while (true) {
                    this.tokens.mark("con2");
                    this.readTerminalString(",");
                    this.tokens.commit("Parsed comma.");
                    arrayList.add(this.readExpression());
                    this.tokens.eraseMark("con2");
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("con2");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("con1");
        }
        this.tokens.nextToken();
        if (this.tokens.tokenType == 3) {
            return new Top(new And(arrayList));
        }
        throw new EPrimeSyntaxException("constraint", this.tokens.toString());
    }

    private ASTNode readExpression() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.readPartExpression());
        this.tokens.commit("Successfully read part expression:" + arrayList.get(0));
        try {
            while (true) {
                this.tokens.mark("inreadexpression");
                ASTNode aSTNode = this.readBinOp();
                this.tokens.commit("Successfully read binop:" + aSTNode);
                ASTNode aSTNode2 = this.readPartExpression();
                this.tokens.commit("Successfully read part expression:" + aSTNode2);
                this.tokens.eraseMark("inreadexpression");
                arrayList.add(aSTNode);
                arrayList.add(aSTNode2);
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("inreadexpression");
            ShuntingYard shuntingYard = new ShuntingYard();
            ASTNode aSTNode = shuntingYard.convertToTree(arrayList);
            return aSTNode;
        }
    }

    private ASTNode readPartExpression() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("rpe");
            aSTNode = this.readBracketedExpression();
            this.tokens.eraseMark("rpe");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rpe");
            try {
                this.tokens.mark("rpe2");
                aSTNode = this.readUnaryExpression();
                this.tokens.eraseMark("rpe2");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("rpe2");
                try {
                    this.tokens.mark("rpe3");
                    aSTNode = this.readConstant();
                    this.tokens.eraseMark("rpe3");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("rpe3");
                    try {
                        this.tokens.mark("rpe4");
                        aSTNode = this.readGlobalConstraint();
                        this.tokens.eraseMark("rpe4");
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset("rpe4");
                        try {
                            this.tokens.mark("rpe5");
                            aSTNode = this.readQuantifiedExpression();
                            this.tokens.eraseMark("rpe5");
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset("rpe5");
                            try {
                                this.tokens.mark("rpe6");
                                aSTNode = this.readArrayExpression();
                                this.tokens.eraseMark("rpe6");
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset("rpe6");
                                try {
                                    this.tokens.mark("rpe7");
                                    aSTNode = this.readBubble();
                                    this.tokens.eraseMark("rpe7");
                                }
                                catch (EPrimeSyntaxException ePrimeSyntaxException7) {
                                    this.tokens.reset("rpe7");
                                    aSTNode = this.readSimpleDomain();
                                }
                            }
                        }
                    }
                }
            }
        }
        return aSTNode;
    }

    private ASTNode readBracketedExpression() throws EPrimeSyntaxException {
        this.readTerminalString("(");
        ASTNode aSTNode = this.readExpression();
        this.readTerminalString(")");
        try {
            this.tokens.mark("slice");
            aSTNode = this.readSliceOrDeref(aSTNode);
            this.tokens.eraseMark("slice");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("slice");
        }
        return aSTNode;
    }

    private ASTNode readUnaryExpression() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            this.readTerminalString("!");
            this.tokens.commit("Read '!' (negation)");
            ASTNode aSTNode = this.readPartExpression();
            this.tokens.eraseMark();
            return new Negate(aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark("unaryminus");
                this.readTerminalString("-");
                this.tokens.commit("Read '-' (unary minus)");
                ASTNode aSTNode = this.readPartExpression();
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                try {
                    while (true) {
                        this.tokens.mark("trypow");
                        this.readTerminalString("**");
                        this.tokens.commit("Read '**' (power)");
                        arrayList.add(this.readPartExpression());
                        this.tokens.eraseMark("trypow");
                    }
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset("trypow");
                    this.tokens.eraseMark("unaryminus");
                    if (arrayList.size() > 0) {
                        ASTNode aSTNode2 = (ASTNode)arrayList.get(arrayList.size() - 1);
                        arrayList.remove(arrayList.size() - 1);
                        while (arrayList.size() > 0) {
                            aSTNode2 = new Power((ASTNode)arrayList.get(arrayList.size() - 1), aSTNode2);
                            arrayList.remove(arrayList.size() - 1);
                        }
                        aSTNode2 = new Power(aSTNode, aSTNode2);
                        return new UnaryMinus(aSTNode2);
                    }
                    return new UnaryMinus(aSTNode);
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("unaryminus");
                this.readTerminalString("|");
                this.tokens.commit("Read '|' (absolute value)");
                ASTNode aSTNode = this.readExpression();
                this.readTerminalString("|");
                return new Absolute(aSTNode);
            }
        }
    }

    private ASTNode readBubble() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("bubble-find");
            this.readTerminalString("{");
            ASTNode aSTNode = this.readIdentifier();
            this.readTerminalString("@");
            int n = this.global_symbols.lettings_givens.size();
            this.readFind();
            int n2 = this.global_symbols.lettings_givens.size();
            assert (n2 == n + 1);
            ASTNode aSTNode2 = this.global_symbols.lettings_givens.removeLast();
            this.readTerminalString("such");
            this.readTerminalString("that");
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(this.readExpression());
            try {
                while (true) {
                    this.tokens.mark("con2");
                    this.readTerminalString(",");
                    arrayList.add(this.readExpression());
                    this.tokens.eraseMark("con2");
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("con2");
                this.readTerminalString("}");
                this.tokens.eraseMark("bubble-find");
                return new AuxBubble(aSTNode, aSTNode2, new And(arrayList));
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("bubble-find");
            this.readTerminalString("{");
            ASTNode aSTNode = this.readExpression();
            this.readTerminalString("@");
            this.readTerminalString("such");
            this.readTerminalString("that");
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(this.readExpression());
            try {
                while (true) {
                    this.tokens.mark("con2");
                    this.readTerminalString(",");
                    arrayList.add(this.readExpression());
                    this.tokens.eraseMark("con2");
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("con2");
                this.readTerminalString("}");
                return new Bubble(aSTNode, new And(arrayList));
            }
        }
    }

    private ASTNode readGlobalConstraint() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            try {
                this.tokens.mark("alldiff");
                this.readTerminalString("alldifferent");
                this.tokens.eraseMark("alldiff");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("alldiff");
                this.readTerminalString("allDiff");
            }
            this.tokens.commit("Parsed keyword 'allDiff'");
            this.readTerminalString("(");
            ASTNode aSTNode = this.readArrayExpression();
            this.readTerminalString(")");
            this.tokens.eraseMark();
            return new AllDifferent(aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readTerminalString("gcc");
                this.tokens.commit("Parsed keyword 'gcc'");
                this.readTerminalString("(");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(",");
                ASTNode aSTNode2 = this.readArrayExpression();
                this.readTerminalString(",");
                ASTNode aSTNode3 = this.readArrayExpression();
                this.readTerminalString(")");
                this.tokens.eraseMark();
                return new GlobalCard(aSTNode, aSTNode2, aSTNode3);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                try {
                    this.tokens.mark("readtab");
                    ASTNode aSTNode = this.readTableConstraint();
                    this.tokens.eraseMark("readtab");
                    return aSTNode;
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("readtab");
                    try {
                        this.tokens.mark();
                        this.readTerminalString("atmost");
                        this.tokens.commit("Parsed keyword 'atmost'");
                        this.readTerminalString("(");
                        ASTNode aSTNode = this.readArrayExpression();
                        this.readTerminalString(",");
                        ASTNode aSTNode4 = this.readArrayExpression();
                        this.readTerminalString(",");
                        ASTNode aSTNode5 = this.readArrayExpression();
                        this.readTerminalString(")");
                        this.tokens.eraseMark();
                        return new AtMost(aSTNode, aSTNode4, aSTNode5);
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset();
                        try {
                            this.tokens.mark();
                            this.readTerminalString("atleast");
                            this.tokens.commit("Parsed keyword 'atleast'");
                            this.readTerminalString("(");
                            ASTNode aSTNode = this.readArrayExpression();
                            this.readTerminalString(",");
                            ASTNode aSTNode6 = this.readArrayExpression();
                            this.readTerminalString(",");
                            ASTNode aSTNode7 = this.readArrayExpression();
                            this.readTerminalString(")");
                            this.tokens.eraseMark();
                            return new AtLeast(aSTNode, aSTNode6, aSTNode7);
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset();
                            try {
                                this.tokens.mark("ade");
                                this.readTerminalString("alldifferent_except");
                                this.tokens.commit("Parsed keyword 'alldifferent_except'");
                                this.readTerminalString("(");
                                ASTNode aSTNode = this.readArrayExpression();
                                this.readTerminalString(",");
                                ASTNode aSTNode8 = this.readExpression();
                                this.readTerminalString(")");
                                this.tokens.eraseMark("ade");
                                return new AllDifferentExcept(aSTNode, aSTNode8);
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset("ade");
                                try {
                                    this.tokens.mark("func");
                                    ASTNode aSTNode = this.readFunction();
                                    this.tokens.eraseMark("func");
                                    return aSTNode;
                                }
                                catch (EPrimeSyntaxException ePrimeSyntaxException7) {
                                    this.tokens.reset("func");
                                    try {
                                        this.tokens.mark("funcgeneric");
                                        ASTNode aSTNode = this.readFunctionGeneric();
                                        this.tokens.eraseMark("funcgeneric");
                                        return aSTNode;
                                    }
                                    catch (EPrimeSyntaxException ePrimeSyntaxException8) {
                                        this.tokens.reset("funcgeneric");
                                        throw new EPrimeSyntaxException("A global constraint", "");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private ASTNode readFunction() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("min");
            this.readTerminalString("min");
            this.tokens.commit("Parsed keyword 'min'");
            this.tokens.eraseMark("min");
            this.readTerminalString("(");
            ASTNode aSTNode = this.readExpression();
            boolean bl = this.tryReadTerminalString(",");
            if (bl) {
                ASTNode aSTNode2 = this.readExpression();
                this.readTerminalString(")");
                return new Min(aSTNode, aSTNode2);
            }
            this.readTerminalString(")");
            return new MinVector(aSTNode);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("min");
            try {
                this.tokens.mark("max");
                this.readTerminalString("max");
                this.tokens.commit("Parsed keyword 'max'");
                this.tokens.eraseMark("max");
                this.readTerminalString("(");
                ASTNode aSTNode = this.readExpression();
                boolean bl = this.tryReadTerminalString(",");
                if (bl) {
                    ASTNode aSTNode3 = this.readExpression();
                    this.readTerminalString(")");
                    return new Max(aSTNode, aSTNode3);
                }
                this.readTerminalString(")");
                return new MaxVector(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("max");
                try {
                    this.tokens.mark("fact");
                    this.readTerminalString("factorial");
                    this.tokens.commit("Parsed keyword 'factorial'");
                    this.readTerminalString("(");
                    ASTNode aSTNode = this.readExpression();
                    this.readTerminalString(")");
                    this.tokens.eraseMark("fact");
                    return new Factorial(aSTNode);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("fact");
                    try {
                        this.tokens.mark("prod");
                        this.readTerminalString("product");
                        this.tokens.commit("Parsed keyword 'product'");
                        this.readTerminalString("(");
                        ASTNode aSTNode = this.readArrayExpression();
                        this.readTerminalString(")");
                        this.tokens.eraseMark("prod");
                        return new TimesVector(aSTNode);
                    }
                    catch (EPrimeSyntaxException ePrimeSyntaxException4) {
                        this.tokens.reset("prod");
                        try {
                            this.tokens.mark("sumvector");
                            this.readTerminalString("sum");
                            this.readTerminalString("(");
                            this.tokens.commit("Parsed keyword 'sum'");
                            ASTNode aSTNode = this.readArrayExpression();
                            this.readTerminalString(")");
                            this.tokens.eraseMark("sumvector");
                            return new SumVector(aSTNode);
                        }
                        catch (EPrimeSyntaxException ePrimeSyntaxException5) {
                            this.tokens.reset("sumvector");
                            try {
                                this.tokens.mark("andvector");
                                this.readTerminalString("and");
                                this.tokens.commit("Parsed keyword 'and'");
                                this.readTerminalString("(");
                                ASTNode aSTNode = this.readArrayExpression();
                                this.readTerminalString(")");
                                this.tokens.eraseMark("andvector");
                                return new AndVector(aSTNode);
                            }
                            catch (EPrimeSyntaxException ePrimeSyntaxException6) {
                                this.tokens.reset("andvector");
                                this.readTerminalString("or");
                                this.tokens.commit("Parsed keyword 'or'");
                                this.readTerminalString("(");
                                ASTNode aSTNode = this.readArrayExpression();
                                this.readTerminalString(")");
                                return new OrVector(aSTNode);
                            }
                        }
                    }
                }
            }
        }
    }

    private ASTNode readFunctionGeneric() throws EPrimeSyntaxException {
        this.tokens.mark("readfuncg");
        try {
            String string = this.readTerminalString();
            if (!this.funcs.containsKey(string)) {
                throw new EPrimeSyntaxException("Generic Function", "Unknown");
            }
            this.tokens.commit("Parsed function name " + string);
            FunctionDescription functionDescription = this.funcs.get(string);
            this.readTerminalString("(");
            this.tokens.commit("Parsed function name " + string + " and open bracket.");
            ASTNode aSTNode = this.readExpression();
            ASTNode aSTNode2 = null;
            ASTNode aSTNode3 = null;
            if (functionDescription.numArgs > 1) {
                this.readTerminalString(",");
                aSTNode2 = this.readExpression();
                if (functionDescription.numArgs > 2) {
                    this.readTerminalString(",");
                    aSTNode3 = this.readExpression();
                }
            }
            this.readTerminalString(")");
            ASTNode aSTNode4 = functionDescription.construct(aSTNode, aSTNode2, aSTNode3);
            this.tokens.eraseMark("readfuncg");
            return aSTNode4;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readfuncg");
            throw ePrimeSyntaxException;
        }
    }

    private ASTNode readTableConstraint() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        this.readTerminalString("table");
        this.tokens.commit("Parsed keyword 'table'");
        this.readTerminalString("(");
        ASTNode aSTNode2 = this.readArrayExpression();
        this.readTerminalString(",");
        this.tokens.commit("Parsed 'table(...,', expecting matrix of satisfying tuples.");
        try {
            this.tokens.mark();
            this.readTerminalString("[");
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            while (true) {
                try {
                    this.tokens.mark();
                    arrayList.add(this.readTuple());
                    this.tokens.eraseMark();
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException) {
                    this.tokens.reset();
                    break;
                }
                try {
                    this.tokens.mark();
                    this.readTerminalString(",");
                    this.tokens.eraseMark();
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException) {
                    this.tokens.reset();
                    break;
                }
            }
            this.readTerminalString("]");
            this.tokens.eraseMark();
            aSTNode = CompoundMatrix.makeCompoundMatrix(arrayList);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            aSTNode = this.readArrayExpression();
        }
        this.readTerminalString(")");
        return new Table(aSTNode2, aSTNode);
    }

    private ASTNode readQuantifiedExpression() throws EPrimeSyntaxException {
        int n;
        try {
            this.tokens.mark();
            try {
                this.tokens.mark("forall");
                this.readTerminalString("forall");
                this.tokens.eraseMark("forall");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("forall");
                this.readTerminalString("forAll");
            }
            this.tokens.eraseMark();
            n = 1;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readTerminalString("exists");
                this.tokens.eraseMark();
                n = 2;
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                this.readTerminalString("sum");
                n = 3;
            }
        }
        ASTNode aSTNode = this.readIdList();
        this.readTerminalString(":");
        ASTNode aSTNode2 = this.readDomain();
        this.readTerminalString(".");
        ASTNode aSTNode3 = this.readExpression();
        for (int i = aSTNode.numChildren() - 1; i >= 0; --i) {
            if (n == 1) {
                aSTNode3 = new ForallExpression(aSTNode.getChild(i), aSTNode2, aSTNode3);
                continue;
            }
            if (n == 2) {
                aSTNode3 = new ExistsExpression(aSTNode.getChild(i), aSTNode2, aSTNode3);
                continue;
            }
            assert (n == 3);
            aSTNode3 = new QuantifiedSum(aSTNode.getChild(i), aSTNode2, aSTNode3);
        }
        return aSTNode3;
    }

    private ASTNode readSliceOrDeref(ASTNode aSTNode) throws EPrimeSyntaxException {
        Object object;
        this.readTerminalString("[");
        this.tokens.commit("Parsed '[' (start of matrix deref or slice)");
        ArrayList<ASTNode> arrayList = this.readSliceRangeList();
        this.readTerminalString("]");
        boolean bl = false;
        for (ASTNode aSTNode2 : arrayList) {
            if (!aSTNode2.isSet()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tokens.commit("Parsed ']' (end of matrix slice)");
            object = new MatrixSlice(aSTNode, arrayList, this.global_symbols);
        } else {
            this.tokens.commit("Parsed ']' (end of matrix deref)");
            object = new MatrixDeref(aSTNode, arrayList);
        }
        if (bl) {
            try {
                this.tokens.mark("readslicerecurse");
                object = this.readSliceOrDeref((ASTNode)object);
                this.tokens.eraseMark("readslicerecurse");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("readslicerecurse");
            }
        }
        return object;
    }

    private ASTNode readArrayExpression() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("arrayfunc");
            aSTNode = this.readArrayFunction();
            this.tokens.eraseMark("arrayfunc");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("arrayfunc");
            try {
                this.tokens.mark("arrayvarious");
                aSTNode = this.readArrayExpressionInner();
                this.tokens.eraseMark("arrayvarious");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("arrayvarious");
                this.readTerminalString("(");
                aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
            }
        }
        try {
            this.tokens.mark("slice");
            aSTNode = this.readSliceOrDeref(aSTNode);
            this.tokens.eraseMark("slice");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("slice");
        }
        return aSTNode;
    }

    private ASTNode readArrayFunction() throws EPrimeSyntaxException {
        try {
            this.tokens.mark("flattn");
            this.readTerminalString("flatten");
            this.readTerminalString("(");
            this.tokens.commit("Read flatten(");
            try {
                this.tokens.mark("flattn2");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
                this.tokens.eraseMark("flattn2");
                this.tokens.eraseMark("flattn");
                return new Flatten(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                int n;
                this.tokens.reset("flattn2");
                if (n < 0) {
                    throw new EPrimeSyntaxException("Integer >=0 in flatten", String.valueOf(n));
                }
                this.readTerminalString(",");
                ASTNode aSTNode = this.readArrayExpression();
                this.readTerminalString(")");
                this.tokens.eraseMark("flattn");
                for (n = this.readInt(); n > 0; --n) {
                    aSTNode = new ConcatenateMatrix(aSTNode);
                }
                return aSTNode;
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("flattn");
            return this.readFunctionGeneric();
        }
    }

    private ASTNode readArrayExpressionInner() throws EPrimeSyntaxException {
        ASTNode aSTNode;
        try {
            this.tokens.mark("comparray");
            aSTNode = this.readCompoundOrComprehensionArrayExpression();
            this.tokens.eraseMark("comparray");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("comparray");
            aSTNode = this.readIdentifier();
        }
        return aSTNode;
    }

    private ArrayList<ASTNode> readSliceRangeList() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        try {
            this.tokens.mark("readdotdot");
            this.readTerminalString("..");
            arrayList.add(new IntegerDomain(new Range(null, null)));
            this.tokens.eraseMark("readdotdot");
            this.tokens.commit("Read '..' in matrix slice or deref.");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readdotdot");
            arrayList.add(this.readExpression());
        }
        try {
            this.tokens.mark("rrl");
            this.readTerminalString(",");
            this.tokens.commit("Read ',' in matrix slice or deref.");
            arrayList.addAll(this.readSliceRangeList());
            this.tokens.eraseMark("rrl");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rrl");
        }
        return arrayList;
    }

    private ASTNode readCompoundOrComprehensionArrayExpression() throws EPrimeSyntaxException {
        this.readTerminalString("[");
        this.tokens.commit("Parsed '[' (start of matrix literal or matrix comprehension)");
        try {
            this.tokens.mark("emptymatrix");
            this.readTerminalString("]");
            this.tokens.commit("Parsed '[ ]' (empty matrix)");
            try {
                this.tokens.mark("empty2");
                this.readTerminalString(":");
                this.tokens.commit("Parsed '[ ] :' (empty matrix with type annotation)");
                this.readTerminalString("`");
                this.tokens.commit("Parsed '[ ] : `' (empty matrix with type annotation)");
                ASTNode aSTNode = this.readMatrixDomain();
                this.readTerminalString("`");
                this.tokens.eraseMark("empty2");
                this.tokens.eraseMark("emptymatrix");
                return new EmptyMatrix(aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("empty2");
                this.tokens.eraseMark("emptymatrix");
                return CompoundMatrix.makeCompoundMatrix(new ArrayList<ASTNode>());
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            boolean bl;
            this.tokens.reset("emptymatrix");
            boolean bl2 = false;
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            while (true) {
                try {
                    this.tokens.mark();
                    ASTNode aSTNode = this.readExpression();
                    this.tokens.eraseMark();
                    arrayList.add(aSTNode);
                    if (arrayList.size() == 1) {
                        this.tokens.commit("Parsed first element in matrix literal or comprehension.");
                    } else {
                        this.tokens.commit("Parsed element in matrix literal.");
                    }
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset();
                    break;
                }
                boolean bl3 = bl2 = !this.tryReadTerminalString(",");
                if (bl2) break;
                this.tokens.commit("Parsed ',' in matrix literal or comprehension.");
            }
            if (bl2 && arrayList.size() == 1 && (bl = this.tryReadTerminalString("|"))) {
                this.tokens.commit("Parsed '|' (in comprehension)");
                return this.readComprehensionInner(arrayList.get(0));
            }
            ASTNode aSTNode = null;
            try {
                this.tokens.mark("optdom");
                this.readTerminalString(";");
                aSTNode = this.readSimpleDomain();
                this.tokens.eraseMark("optdom");
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                this.tokens.reset("optdom");
            }
            this.readTerminalString("]");
            if (aSTNode == null) {
                return CompoundMatrix.makeCompoundMatrix(arrayList);
            }
            return CompoundMatrix.makeCompoundMatrix(aSTNode, arrayList, false);
        }
    }

    private ASTNode readComprehensionInner(ASTNode aSTNode) throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        boolean bl = true;
        try {
            while (true) {
                this.tokens.mark("cquant");
                if (!bl) {
                    this.readTerminalString(",");
                }
                ASTNode aSTNode2 = this.readIdList();
                this.readTerminalString(":");
                ASTNode aSTNode3 = this.readDomain();
                this.tokens.eraseMark("cquant");
                for (int i = 0; i < aSTNode2.numChildren(); ++i) {
                    arrayList.add(new ComprehensionForall(aSTNode2.getChild(i), aSTNode3));
                }
                bl = false;
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("cquant");
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            try {
                while (true) {
                    this.tokens.mark("ccond");
                    if (!bl) {
                        this.readTerminalString(",");
                    }
                    ASTNode aSTNode4 = this.readExpression();
                    this.tokens.eraseMark("ccond");
                    arrayList2.add(aSTNode4);
                    bl = false;
                }
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset("ccond");
                ASTNode aSTNode5 = null;
                try {
                    this.tokens.mark("optdom");
                    this.readTerminalString(";");
                    aSTNode5 = this.readSimpleDomain();
                    this.tokens.eraseMark("optdom");
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException3) {
                    this.tokens.reset("optdom");
                }
                this.readTerminalString("]");
                if (aSTNode5 == null) {
                    return new ComprehensionMatrix(aSTNode, arrayList, (ASTNode)new And(arrayList2));
                }
                return new ComprehensionMatrix(aSTNode, arrayList, (ASTNode)new And(arrayList2), aSTNode5);
            }
        }
    }

    private ASTNode readQuickConstantMatrixNotDeref() throws EPrimeSyntaxException {
        ASTNode aSTNode = this.readQuickConstantMatrix();
        this.tokens.mark("brac");
        boolean bl = false;
        try {
            this.readTerminalString("[");
            bl = true;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            // empty catch block
        }
        this.tokens.reset("brac");
        if (bl) {
            throw new EPrimeSyntaxException("quick matrix", "matrix deref");
        }
        return aSTNode;
    }

    private ASTNode readQuickConstantMatrix() throws EPrimeSyntaxException {
        this.readTerminalString("[");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark();
                int n = this.readInt();
                this.tokens.eraseMark();
                arrayList.add(new NumberConstant(n));
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                try {
                    this.tokens.mark("nested");
                    ASTNode aSTNode = this.readQuickConstantMatrix();
                    this.tokens.eraseMark("nested");
                    arrayList.add(aSTNode);
                }
                catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                    this.tokens.reset("nested");
                    break;
                }
            }
            try {
                this.tokens.mark();
                this.readTerminalString(",");
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
        }
        this.readTerminalString("]");
        return CompoundMatrix.makeCompoundMatrix(arrayList);
    }

    private ArrayList<ASTNode> readRangeList() throws EPrimeSyntaxException {
        ASTNode aSTNode = this.readOpenRange();
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        try {
            this.tokens.mark("rrl");
            this.readTerminalString(",");
            arrayList.addAll(this.readRangeList());
            this.tokens.eraseMark("rrl");
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("rrl");
        }
        return arrayList;
    }

    private ASTNode readOpenRange() throws EPrimeSyntaxException {
        boolean bl = this.tryReadTerminalString("..");
        if (bl) {
            try {
                this.tokens.mark("oprange");
                ASTNode aSTNode = this.readExpression();
                this.tokens.eraseMark("oprange");
                return new Range(null, aSTNode);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("oprange");
                return new Range(null, null);
            }
        }
        ASTNode aSTNode = this.readExpression();
        boolean bl2 = this.tryReadTerminalString("..");
        if (bl2) {
            try {
                this.tokens.mark("oprange2");
                ASTNode aSTNode2 = this.readExpression();
                this.tokens.eraseMark("oprange2");
                return new Range(aSTNode, aSTNode2);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset("oprange2");
                return new Range(aSTNode, null);
            }
        }
        return aSTNode;
    }

    private ASTNode readBinOp() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (!(this.tokens.tokenType == 1 || this.tokens.tokenType == 0 && this.binops.contains(this.tokens.wordToken))) {
            throw new EPrimeSyntaxException("Binary operator", this.tokens.toString());
        }
        String string = this.tokens.tokenType == 1 ? this.tokens.otherToken : this.tokens.wordToken;
        if (!this.binops.contains(string)) {
            throw new EPrimeSyntaxException("Binary operator", string);
        }
        return new BinOpPlaceholder(string);
    }

    private ASTNode readIdList() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(this.readIdentifier());
        try {
            while (true) {
                this.tokens.mark("readidlist");
                this.readTerminalString(",");
                arrayList.add(this.readIdentifier());
                this.tokens.eraseMark("readidlist");
            }
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("readidlist");
            return new Container(arrayList);
        }
    }

    private ASTNode readTuple() throws EPrimeSyntaxException {
        this.readTerminalString("<");
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        while (true) {
            try {
                this.tokens.mark();
                arrayList.add(this.readConstant());
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
            try {
                this.tokens.mark();
                this.readTerminalString(",");
                this.tokens.eraseMark();
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException) {
                this.tokens.reset();
                break;
            }
        }
        this.readTerminalString(">");
        return CompoundMatrix.makeCompoundMatrix(arrayList);
    }

    private ASTNode readIdentifier() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 0) {
            throw new EPrimeSyntaxException("an identifier string", this.tokens.toString());
        }
        if (this.keywords.contains(this.tokens.wordToken)) {
            throw new EPrimeSyntaxException("an identifier string", this.tokens.toString());
        }
        return new Identifier(this.tokens.wordToken, this.global_symbols);
    }

    private ASTNode makeUnionOfRanges(ArrayList<ASTNode> arrayList, int n, int n2) {
        if (n2 - n < 5) {
            ASTNode aSTNode = new IntegerDomain(arrayList.get(n));
            for (int i = n + 1; i < n2; ++i) {
                aSTNode = new Union(aSTNode, new IntegerDomain(arrayList.get(i)));
            }
            return aSTNode;
        }
        return new Union(this.makeUnionOfRanges(arrayList, n, n + (n2 - n) / 2), this.makeUnionOfRanges(arrayList, n + (n2 - n) / 2, n2));
    }

    private ASTNode readUnboundedSetOfRanges() throws EPrimeSyntaxException {
        ArrayList<ASTNode> arrayList = this.readRangeList();
        return this.makeUnionOfRanges(arrayList, 0, arrayList.size());
    }

    private ASTNode readConstant() throws EPrimeSyntaxException {
        try {
            this.tokens.mark();
            int n = this.readInt();
            this.tokens.eraseMark();
            return new NumberConstant(n);
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset();
            try {
                this.tokens.mark();
                this.readTerminalString("true");
                this.tokens.eraseMark();
                return new BooleanConstant(true);
            }
            catch (EPrimeSyntaxException ePrimeSyntaxException2) {
                this.tokens.reset();
                this.readTerminalString("false");
                return new BooleanConstant(false);
            }
        }
    }

    private int readInt() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType == 2) {
            return this.tokens.intToken;
        }
        throw new EPrimeSyntaxException("integer", this.tokens.toString());
    }

    private boolean tryReadTerminalString(String string) {
        try {
            this.tokens.mark("trts");
            this.readTerminalString(string);
            this.tokens.eraseMark("trts");
            return true;
        }
        catch (EPrimeSyntaxException ePrimeSyntaxException) {
            this.tokens.reset("trts");
            return false;
        }
    }

    private void readTerminalString(String string) throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType != 0 && this.tokens.tokenType != 1) {
            throw new EPrimeSyntaxException(string, this.tokens.toString());
        }
        if (this.tokens.tokenType == 0 && !this.tokens.wordToken.equals(string)) {
            throw new EPrimeSyntaxException(string, this.tokens.toString());
        }
        if (this.tokens.tokenType == 1 && !this.tokens.otherToken.equals(string)) {
            throw new EPrimeSyntaxException(string, this.tokens.toString());
        }
    }

    private String readTerminalString() throws EPrimeSyntaxException {
        this.tokens.nextToken();
        if (this.tokens.tokenType == 0) {
            return this.tokens.wordToken;
        }
        if (this.tokens.tokenType == 1) {
            return this.tokens.otherToken;
        }
        throw new EPrimeSyntaxException("", this.tokens.toString());
    }

    public class FunctionDescription {
        public String className;
        public int numArgs;

        FunctionDescription(String string, int n) {
            this.className = string;
            this.numArgs = n;
        }

        public ASTNode construct(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
            try {
                Class<?> clazz = Class.forName("savilerow.expression." + this.className);
                Class<?> clazz2 = Class.forName("savilerow.expression.ASTNode");
                if (this.numArgs == 1) {
                    Constructor<?> constructor = clazz.getConstructor(clazz2);
                    return (ASTNode)constructor.newInstance(aSTNode);
                }
                if (this.numArgs == 2) {
                    Constructor<?> constructor = clazz.getConstructor(clazz2, clazz2);
                    return (ASTNode)constructor.newInstance(aSTNode, aSTNode2);
                }
                if (this.numArgs == 3) {
                    Constructor<?> constructor = clazz.getConstructor(clazz2, clazz2, clazz2);
                    return (ASTNode)constructor.newInstance(aSTNode, aSTNode2, aSTNode3);
                }
            }
            catch (Exception exception) {
                CmdFlags.errorExit("Failed to construct function " + this.className + " with exception " + exception);
            }
            return null;
        }
    }
}

