/*
 * Decompiled with CFR 0.152.
 */
package savilerow.eprimeparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import savilerow.CmdFlags;
import savilerow.eprimeparser.EPrimeSyntaxException;
import savilerow.expression.Intpair;

public final class EPrimeTokenizer {
    private int ln;
    private char[] file;
    private int idx;
    private Stack<Integer> markStack;
    private Stack<String> markNames;
    private int commitMark;
    private String commitMsg;
    public int tokenType;
    public static final int TT_WORD = 0;
    public static final int TT_OTHER = 1;
    public static final int TT_INT = 2;
    public static final int TT_EOF = 3;
    public String wordToken;
    public String otherToken;
    public int intToken;
    static final boolean VB_TOKENS = false;

    public EPrimeTokenizer(String string) {
        File file = new File(string);
        this.ln = (int)file.length();
        this.file = new char[this.ln];
        try {
            FileReader fileReader = new FileReader(string);
            int n = fileReader.read(this.file, 0, this.ln);
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(-1);
        }
        this.idx = 0;
        this.markStack = new Stack();
        this.markNames = new Stack();
    }

    public EPrimeTokenizer(String string, boolean bl) {
        assert (bl);
        this.ln = string.length();
        this.file = new char[this.ln];
        for (int i = 0; i < this.ln; ++i) {
            this.file[i] = string.charAt(i);
        }
        this.idx = 0;
        this.markStack = new Stack();
        this.markNames = new Stack();
    }

    public void mark() {
        this.markStack.push(new Integer(this.idx));
        this.markNames.push("moo");
    }

    public void mark(String string) {
        this.markStack.push(new Integer(this.idx));
        this.markNames.push(string);
    }

    public void eraseMark() {
        this.markStack.pop();
        String string = this.markNames.pop();
        assert (string.equals("moo"));
    }

    public void eraseMark(String string) {
        this.markStack.pop();
        String string2 = this.markNames.pop();
        if (!string.equals(string2)) {
            System.out.println(string + ", " + string2);
        }
        assert (string.equals(string2));
    }

    public void reset() {
        this.idx = this.markStack.pop();
        if (this.idx < this.commitMark) {
            this.raiseError();
        }
        String string = this.markNames.pop();
        assert (string.equals("moo"));
    }

    public void reset(String string) {
        String string2;
        this.idx = this.markStack.pop();
        if (this.idx < this.commitMark) {
            this.raiseError();
        }
        if (!string.equals(string2 = this.markNames.pop())) {
            System.out.println(string + ", " + string2);
        }
        assert (string.equals(string2));
    }

    public void raiseError() {
        Intpair intpair = this.linecolNumber(this.commitMark);
        this.printMarker(intpair.lower, intpair.upper);
        if (this.commitMsg != null) {
            CmdFlags.errorExit(this.commitMsg, "Failed when parsing rest of structure following line:" + intpair.lower + " column:" + intpair.upper);
        } else {
            CmdFlags.errorExit("Failed when parsing rest of structure following line:" + intpair.lower + " column:" + intpair.upper);
        }
    }

    public void commit(String string) {
        this.commitMark = this.idx;
        this.commitMsg = string;
    }

    public String toString() {
        switch (this.tokenType) {
            case 0: {
                return "Token[" + this.wordToken + "]";
            }
            case 2: {
                return "Token[" + Integer.toString(this.intToken) + "]";
            }
            case 1: {
                return "Token[" + this.otherToken + "]";
            }
            case 3: {
                return "EOF";
            }
        }
        return "Unknown token type!!";
    }

    public Intpair linecolNumber(int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.file[n2] != '\n') continue;
            ++n3;
        }
        n2 = 1;
        for (int i = 0; i < n; ++i) {
            ++n2;
            if (this.file[i] != '\n') continue;
            n2 = 0;
        }
        return new Intpair(n3, n2);
    }

    public void printMarker(long l, long l2) {
        int n;
        int n2 = 1;
        for (n = 0; n < this.file.length; ++n) {
            if ((long)n2 == l) {
                System.err.print(this.file[n]);
            }
            if (this.file[n] != '\n') continue;
            ++n2;
        }
        System.err.println("");
        n = 0;
        while ((long)n < l2) {
            System.err.print("-");
            ++n;
        }
        System.err.println("^");
    }

    public void nextToken() throws EPrimeSyntaxException {
        this.skipWS();
        if (this.tokenType == 3 && this.idx >= this.ln - 1) {
            return;
        }
        char c = this.file[this.idx];
        if ('A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c) {
            this.nextWordToken();
        } else if ('0' <= c && '9' >= c) {
            this.nextIntToken();
        } else {
            this.nextOtherToken();
        }
        this.skipWSaftertoken();
    }

    private void nextWordToken() {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(this.file[this.idx++]);
        } while (this.idx != this.ln && (this.file[this.idx] >= '0' && this.file[this.idx] <= '9' || this.file[this.idx] >= 'A' && this.file[this.idx] <= 'Z' || this.file[this.idx] >= 'a' && this.file[this.idx] <= 'z' || this.file[this.idx] == '_' || this.file[this.idx] == '\''));
        this.wordToken = stringBuilder.toString();
        this.tokenType = 0;
    }

    private void nextIntToken() {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(this.file[this.idx++]);
        } while (this.idx != this.ln && this.file[this.idx] >= '0' && this.file[this.idx] <= '9');
        try {
            this.intToken = Integer.parseInt(stringBuilder.toString());
            this.tokenType = 2;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
            System.out.println("This should not be possible!");
            System.exit(-1);
        }
    }

    private void nextOtherToken() throws EPrimeSyntaxException {
        switch (this.file[this.idx++]) {
            case ',': {
                this.otherToken = ",";
                break;
            }
            case ':': {
                this.otherToken = ":";
                break;
            }
            case ';': {
                this.otherToken = ";";
                break;
            }
            case '[': {
                this.otherToken = "[";
                break;
            }
            case ']': {
                this.otherToken = "]";
                break;
            }
            case '(': {
                this.otherToken = "(";
                break;
            }
            case ')': {
                this.otherToken = ")";
                break;
            }
            case '{': {
                this.otherToken = "{";
                break;
            }
            case '}': {
                this.otherToken = "}";
                break;
            }
            case '@': {
                this.otherToken = "@";
                break;
            }
            case '`': {
                this.otherToken = "`";
                break;
            }
            case '*': {
                if (this.ln > this.idx && this.file[this.idx] == '*') {
                    ++this.idx;
                    this.otherToken = "**";
                    break;
                }
                this.otherToken = "*";
                break;
            }
            case '+': {
                this.otherToken = "+";
                break;
            }
            case '-': {
                if (this.ln > this.idx && this.file[this.idx] == '>') {
                    ++this.idx;
                    this.otherToken = "->";
                    break;
                }
                this.otherToken = "-";
                break;
            }
            case '|': {
                this.otherToken = "|";
                break;
            }
            case '%': {
                this.otherToken = "%";
                break;
            }
            case '/': {
                if (this.ln > this.idx && this.file[this.idx] == '\\') {
                    ++this.idx;
                    this.otherToken = "/\\";
                    break;
                }
                this.otherToken = "/";
                break;
            }
            case '\\': {
                if (this.ln > this.idx && this.file[this.idx] == '/') {
                    ++this.idx;
                    this.otherToken = "\\/";
                    break;
                }
                throw new EPrimeSyntaxException("OtherToken", "Unknown token beginning with '\\'");
            }
            case '.': {
                if (this.ln > this.idx && this.file[this.idx] == '.') {
                    ++this.idx;
                    this.otherToken = "..";
                    break;
                }
                this.otherToken = ".";
                break;
            }
            case '>': {
                if (this.ln > this.idx + 2 && this.file[this.idx] == 'l' && this.file[this.idx + 1] == 'e' && this.file[this.idx + 2] == 'x') {
                    this.idx += 3;
                    this.otherToken = ">lex";
                    break;
                }
                if (this.ln > this.idx + 3 && this.file[this.idx] == '=' && this.file[this.idx + 1] == 'l' && this.file[this.idx + 2] == 'e' && this.file[this.idx + 3] == 'x') {
                    this.idx += 4;
                    this.otherToken = ">=lex";
                    break;
                }
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = ">=";
                    break;
                }
                this.otherToken = ">";
                break;
            }
            case '<': {
                if (this.ln > this.idx + 2 && this.file[this.idx] == 'l' && this.file[this.idx + 1] == 'e' && this.file[this.idx + 2] == 'x') {
                    this.idx += 3;
                    this.otherToken = "<lex";
                    break;
                }
                if (this.ln > this.idx + 3 && this.file[this.idx] == '=' && this.file[this.idx + 1] == 'l' && this.file[this.idx + 2] == 'e' && this.file[this.idx + 3] == 'x') {
                    this.idx += 4;
                    this.otherToken = "<=lex";
                    break;
                }
                if (this.ln > this.idx + 1 && this.file[this.idx] == '=' && this.file[this.idx + 1] == '>') {
                    this.idx += 2;
                    this.otherToken = "<=>";
                    break;
                }
                if (this.ln > this.idx + 1 && this.file[this.idx] == '-' && this.file[this.idx + 1] == '>') {
                    this.idx += 2;
                    this.otherToken = "<->";
                    break;
                }
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = "<=";
                    break;
                }
                this.otherToken = "<";
                break;
            }
            case '!': {
                if (this.ln > this.idx && this.file[this.idx] == '=') {
                    ++this.idx;
                    this.otherToken = "!=";
                    break;
                }
                this.otherToken = "!";
                break;
            }
            case '=': {
                if (this.ln > this.idx && this.file[this.idx] == '>') {
                    ++this.idx;
                    this.otherToken = "=>";
                    break;
                }
                this.otherToken = "=";
                break;
            }
            default: {
                throw new EPrimeSyntaxException("OtherToken", "Unknown token beginning with " + Character.toString(this.file[this.idx - 1]));
            }
        }
        this.tokenType = 1;
    }

    private void skipWS() {
        boolean bl = false;
        while (this.idx < this.ln) {
            if (bl) {
                if (this.file[this.idx] == '\n' || this.file[this.idx] == '\r') {
                    bl = false;
                }
                ++this.idx;
                continue;
            }
            if (this.file[this.idx] == '$') {
                bl = true;
            } else if (this.file[this.idx] > ' ') {
                return;
            }
            ++this.idx;
        }
        this.tokenType = 3;
    }

    private void skipWSaftertoken() {
        boolean bl = false;
        while (this.idx < this.ln) {
            if (bl) {
                if (this.file[this.idx] == '\n' || this.file[this.idx] == '\r') {
                    bl = false;
                }
                ++this.idx;
                continue;
            }
            if (this.file[this.idx] == '$') {
                bl = true;
            } else if (this.file[this.idx] > ' ') {
                return;
            }
            ++this.idx;
        }
    }
}

