/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import savilerow.CmdFlags;
import savilerow.expression.AllDifferent;
import savilerow.expression.And;
import savilerow.expression.BinOp;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Equals;
import savilerow.expression.ExistsExpression;
import savilerow.expression.ForallExpression;
import savilerow.expression.Identifier;
import savilerow.expression.Iff;
import savilerow.expression.InSet;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LessEqual;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixSlice;
import savilerow.expression.NegInfinity;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.Or;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.expression.Quantifier;
import savilerow.expression.SATLiteral;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Top;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public abstract class ASTNode
implements Serializable {
    public static final long serialVersionUID = 1L;
    ASTNode[] children;
    private ASTNode parent;
    private int childno;
    int hashCache;
    public static final int Constant = 0;
    public static final int Parameter = 1;
    public static final int Quantifier = 2;
    public static final int Decision = 3;
    public static final int Auxiliary = 10;
    public static final int ConstantMatrix = 11;
    public static final int Dim = 12;
    public static final int Undeclared = 20;

    ASTNode() {
        this.setChildren();
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ASTNode aSTNode) {
        this.setChildren(aSTNode);
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ASTNode aSTNode, ASTNode aSTNode2) {
        this.setChildren(aSTNode, aSTNode2);
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        this.setChildren(aSTNode, aSTNode2, aSTNode3);
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        this.setChildren(aSTNode, aSTNode2, aSTNode3, aSTNode4);
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ASTNode[] aSTNodeArray) {
        this.setChildren(aSTNodeArray);
        this.hashCache = Integer.MIN_VALUE;
    }

    ASTNode(ArrayList<ASTNode> arrayList) {
        this.setChildren(arrayList);
        this.hashCache = Integer.MIN_VALUE;
    }

    public final ArrayList<ASTNode> getChildren() {
        return this.children == null ? new ArrayList<ASTNode>() : new ArrayList<ASTNode>(Arrays.asList(this.children));
    }

    public final ASTNode[] getChildrenArray() {
        if (this.children == null) {
            return null;
        }
        ASTNode[] aSTNodeArray = new ASTNode[this.children.length];
        System.arraycopy(this.children, 0, aSTNodeArray, 0, this.children.length);
        return aSTNodeArray;
    }

    public final void setChildren(ASTNode[] aSTNodeArray) {
        for (int i = 0; i < aSTNodeArray.length; ++i) {
            if (aSTNodeArray[i].getParent() != null) {
                aSTNodeArray[i] = aSTNodeArray[i].copy();
            }
            aSTNodeArray[i].setParent(this);
            aSTNodeArray[i].childno = i;
        }
        this.children = aSTNodeArray;
    }

    public final void setChildren(ArrayList<ASTNode> arrayList) {
        this.setChildren(arrayList.toArray(new ASTNode[arrayList.size()]));
    }

    public final void setChildren() {
        this.children = null;
    }

    public final void setChildren(ASTNode aSTNode) {
        this.children = new ASTNode[1];
        this.children[0] = aSTNode.getParent() == null ? aSTNode : aSTNode.copy();
        this.children[0].setParent(this);
        this.children[0].childno = 0;
    }

    public final void setChildren(ASTNode aSTNode, ASTNode aSTNode2) {
        this.children = new ASTNode[2];
        this.children[0] = aSTNode.getParent() == null ? aSTNode : aSTNode.copy();
        this.children[0].setParent(this);
        this.children[0].childno = 0;
        this.children[1] = aSTNode2.getParent() == null ? aSTNode2 : aSTNode2.copy();
        this.children[1].setParent(this);
        this.children[1].childno = 1;
    }

    public final void setChildren(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        ASTNode[] aSTNodeArray = new ASTNode[]{aSTNode, aSTNode2, aSTNode3};
        this.setChildren(aSTNodeArray);
    }

    public final void setChildren(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        ASTNode[] aSTNodeArray = new ASTNode[]{aSTNode, aSTNode2, aSTNode3, aSTNode4};
        this.setChildren(aSTNodeArray);
    }

    public final ASTNode getParent() {
        return this.parent;
    }

    public final void setParent(ASTNode aSTNode) {
        this.parent = aSTNode;
    }

    public boolean isParentTransitive(ASTNode aSTNode) {
        for (ASTNode aSTNode2 = aSTNode.getParent(); aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            if (!this.equals(aSTNode2)) continue;
            return true;
        }
        return false;
    }

    public final void setChild(int n, ASTNode aSTNode) {
        if (aSTNode == null) {
            this.children[n] = null;
        } else if (aSTNode.getParent() == null) {
            this.children[n] = aSTNode;
            aSTNode.setParent(this);
            aSTNode.childno = n;
        } else {
            this.children[n] = aSTNode.copy();
            this.children[n].setParent(this);
            this.children[n].childno = n;
        }
        for (ASTNode aSTNode2 = this; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            aSTNode2.hashCache = Integer.MIN_VALUE;
        }
    }

    public final void setChild_nocopy(int n, ASTNode aSTNode) {
        if (aSTNode == null) {
            this.children[n] = null;
        } else {
            this.children[n] = aSTNode;
            aSTNode.setParent(this);
            aSTNode.childno = n;
        }
        for (ASTNode aSTNode2 = this; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            aSTNode2.hashCache = Integer.MIN_VALUE;
        }
    }

    public final ASTNode getChild(int n) {
        return this.children[n];
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string + "(";
        if (this.children == null) {
            string = string + "NULL-POINTER";
        } else {
            for (int i = 0; i < this.numChildren(); ++i) {
                string = string + this.getChild(i);
                if (i >= this.numChildren() - 1) continue;
                string = string + ", ";
            }
        }
        return string + ")";
    }

    public String generic_to_string(String string) {
        String string2 = string + "(";
        if (this.children == null) {
            string2 = string2 + "NULL-POINTER";
        } else {
            for (int i = 0; i < this.numChildren(); ++i) {
                string2 = string2 + this.getChild(i);
                if (i >= this.numChildren() - 1) continue;
                string2 = string2 + ", ";
            }
        }
        return string2 + ")";
    }

    public int numChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public int getChildNo() {
        return this.childno;
    }

    public void setChildNo(int n) {
        this.childno = n;
    }

    public abstract ASTNode copy();

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ArrayList<ASTNode> arrayList = ((ASTNode)object).getChildren();
        if (this.numChildren() != arrayList.size()) {
            return false;
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).equals(arrayList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n = this.getClass().getName().hashCode();
            this.hashCache = n = n * 13 + Arrays.hashCode(this.children);
            return n;
        }
        return this.hashCache;
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isSet() {
        return false;
    }

    public boolean isBooleanSet() {
        return false;
    }

    public boolean isFiniteSet() {
        return false;
    }

    public boolean isFiniteSetUpper() {
        return false;
    }

    public boolean isFiniteSetLower() {
        return false;
    }

    public boolean isCommAssoc() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public long getValue() {
        System.out.println("Missing getValue method: type:" + this.getClass().getName());
        assert (false);
        return 0L;
    }

    public boolean toFlatten(boolean bl) {
        if (this instanceof Identifier || this instanceof MatrixDeref || this instanceof SafeMatrixDeref || this instanceof MatrixSlice || this.isConstant() || this instanceof Top || this instanceof SATLiteral) {
            return false;
        }
        if (this.isRelation()) {
            ASTNode aSTNode = this.getParent();
            if (CmdFlags.getGecodetrans() && !bl) {
                return !(aSTNode instanceof Top) && (!(aSTNode instanceof And) || !(aSTNode.getParent() instanceof Top));
            }
            if (CmdFlags.getSattrans() && !bl) {
                if (aSTNode instanceof Top || aSTNode instanceof And && aSTNode.getParent() instanceof Top) {
                    return false;
                }
                if ((this instanceof Equals || this instanceof Less || this instanceof LessEqual || this instanceof Iff) && (this.getChild(0).isConstant() || this.getChild(1).isConstant())) {
                    return false;
                }
                if (this instanceof AllDifferent && this.getChild(0) instanceof CompoundMatrix && (this.getChild(0).getChild(1).isConstant() || this.getChild(0).getChild(2).isConstant())) {
                    return false;
                }
                return !(this instanceof Negate);
            }
            return !(aSTNode instanceof Top) && !(aSTNode instanceof And) && !(aSTNode instanceof Or) && !(aSTNode instanceof ForallExpression) && !(aSTNode instanceof ExistsExpression);
        }
        return false;
    }

    public final boolean toCSE() {
        if (this instanceof Identifier || this instanceof MatrixDeref || this instanceof SafeMatrixDeref || this.isConstant() || this instanceof Top) {
            return false;
        }
        if (this.getDimension() > 0) {
            return false;
        }
        if (this.isNumerical()) {
            return true;
        }
        if (this.isRelation()) {
            if (CmdFlags.getGecodetrans()) {
                return true;
            }
            if (CmdFlags.getSattrans()) {
                if ((this instanceof Equals || this instanceof Less || this instanceof LessEqual || this instanceof Iff) && (this.getChild(0).isConstant() || this.getChild(1).isConstant())) {
                    return false;
                }
                if (this instanceof Negate) {
                    return false;
                }
                if (this instanceof AllDifferent && this.getChild(0) instanceof CompoundMatrix && (this.getChild(0).getChild(1).isConstant() || this.getChild(0).getChild(2).isConstant())) {
                    return false;
                }
            } else {
                if (this instanceof Negate && this.getChild(0) instanceof Identifier) {
                    return false;
                }
                if (this.getParent() instanceof And || this.getParent() instanceof Or) {
                    if ((this instanceof Equals || this instanceof Less || this instanceof LessEqual || this instanceof Iff) && (this.getChild(0).isConstant() || this.getChild(1).isConstant())) {
                        return false;
                    }
                    if (this instanceof AllDifferent && this.getChild(0) instanceof CompoundMatrix && (this.getChild(0).getChild(1).isConstant() || this.getChild(0).getChild(2).isConstant())) {
                        return false;
                    }
                    if (this instanceof InSet) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        return true;
    }

    public int getCategory() {
        int n = 0;
        for (int i = 0; i < this.numChildren(); ++i) {
            int n2 = this.getChild(i).getCategory();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getDimension() {
        return 0;
    }

    public ArrayList<ASTNode> getIndexDomains() {
        return null;
    }

    public ASTNode simplify() {
        return this;
    }

    public ArrayList<Long> getValueSet() {
        if (this.isConstant()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(this.getValue());
            return arrayList;
        }
        System.out.println("type:" + this.getClass().getName());
        assert (false);
        return null;
    }

    public ArrayList<Intpair> getIntervalSet() {
        if (this.isConstant()) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            arrayList.add(new Intpair(this.getValue(), this.getValue()));
            return arrayList;
        }
        System.out.println("type:" + this.getClass().getName());
        assert (false);
        return null;
    }

    public Intpair getBounds() {
        if (this.isConstant()) {
            long l = this.getValue();
            return new Intpair(l, l);
        }
        if (this.isRelation()) {
            return new Intpair(0L, 1L);
        }
        System.out.println("Missing getBounds method for type:" + this.getClass().getName());
        assert (false);
        return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public Intpair lookupBounds(Intpair intpair) {
        if (CmdFlags.currentModel != null && CmdFlags.getUsePropagateExtend2()) {
            Intpair intpair2 = CmdFlags.currentModel.filt.lookupBounds(this);
            return intpair2.intersect(intpair);
        }
        return intpair;
    }

    public PairASTNode getBoundsAST() {
        if (this.isConstant()) {
            long l = this.getValue();
            return new PairASTNode(new NumberConstant(l), new NumberConstant(l));
        }
        if (this.isRelation()) {
            return new PairASTNode(new NumberConstant(0L), new NumberConstant(1L));
        }
        System.out.println("Missing getBoundsAST method for type:" + this.getClass().getName());
        assert (false);
        return new PairASTNode(new NegInfinity(), new PosInfinity());
    }

    public boolean exceedsBoundThreshold() {
        Intpair intpair = this.getBounds();
        return intpair.upper - intpair.lower + 1L > (long)CmdFlags.getBoundVarThreshold();
    }

    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        System.out.println("Missing toMinion method. type:" + this.getClass().getName());
        assert (false);
    }

    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        System.out.println("Missing toMinionWithAuxVar method. type:" + this.getClass().getName());
        assert (false);
    }

    public final void toDominion(StringBuilder stringBuilder, boolean bl) {
        if (this.getCategory() <= 2) {
            if (bl) {
                stringBuilder.append(CmdFlags.getCtName() + " ");
                stringBuilder.append("constantwrap(");
                this.toDominionParam(stringBuilder);
                stringBuilder.append(")");
            } else {
                this.toDominionParam(stringBuilder);
            }
            return;
        }
        this.toDominionInner(stringBuilder, bl);
    }

    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        System.out.println("Missing toDominionWithAuxVar method. type:" + this.getClass().getName());
        assert (false);
    }

    public void toDominionParam(StringBuilder stringBuilder) {
        System.out.println("Missing toDominionParam method. type:" + this.getClass().getName());
        assert (false);
    }

    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        System.out.println("Missing toDominionInner method. type:" + this.getClass().getName());
        assert (false);
    }

    public ASTNode normalise() {
        return this;
    }

    public static boolean sortByHashcode(ArrayList<ASTNode> arrayList) {
        int n;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(arrayList.size());
        for (n = 0; n < arrayList.size(); n += 1) {
            arrayList2.add(arrayList.get(n).hashCode());
        }
        n = 0;
        for (int i = 1; i < arrayList.size(); ++i) {
            for (int j = i - 1; j >= 0 && (Integer)arrayList2.get(j + 1) < (Integer)arrayList2.get(j); --j) {
                ASTNode aSTNode = arrayList.get(j + 1);
                arrayList.set(j + 1, arrayList.get(j));
                arrayList.set(j, aSTNode);
                int n2 = (Integer)arrayList2.get(j + 1);
                arrayList2.set(j + 1, (Integer)arrayList2.get(j));
                arrayList2.set(j, n2);
                n = 1;
            }
        }
        return n != 0;
    }

    public boolean isDetached() {
        if (this.getParent() != null) {
            if (this.getParent().isDetached()) {
                return true;
            }
            return this.getParent().getChild(this.childno) != this;
        }
        return false;
    }

    public ASTNode getQuantifier(ASTNode aSTNode) {
        assert (this instanceof Identifier);
        assert (this.getCategory() == 2);
        for (ASTNode aSTNode2 = aSTNode; aSTNode2 != null; aSTNode2 = aSTNode2.getParent()) {
            if (!(aSTNode2 instanceof Quantifier)) continue;
            ArrayList<ASTNode> arrayList = aSTNode2.getChild(0).getChildren();
            for (ASTNode aSTNode3 : arrayList) {
                if (!aSTNode3.equals(this)) continue;
                return aSTNode2;
            }
        }
        return null;
    }

    public ASTNode getDomainForId(ASTNode aSTNode) {
        if (this.getParent() != null) {
            return this.getParent().getDomainForId(aSTNode);
        }
        return null;
    }

    public boolean inTopConjunction() {
        return false;
    }

    public boolean inTopAnd() {
        return false;
    }

    public boolean unary() {
        if (this instanceof Identifier || this instanceof MatrixDeref || this instanceof SafeMatrixDeref) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i).unary()) {
                if (bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (this.getChild(i).isConstant()) continue;
            return false;
        }
        return bl;
    }

    public ASTNode applyShift(int n) {
        if (this.isNumerical()) {
            return BinOp.makeBinOp("+", this, new NumberConstant(n));
        }
        System.out.println("Missing applyShift method. type:" + this.getClass().getName());
        assert (false);
        return null;
    }

    public boolean containsValue(long l) {
        if (this.isConstant()) {
            return l == this.getValue();
        }
        System.out.println("Missing containsValue method. type:" + this.getClass().getName());
        assert (false);
        return false;
    }

    public boolean contains(ASTNode aSTNode) {
        if (this.equals(aSTNode)) {
            return true;
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).contains(aSTNode)) continue;
            return true;
        }
        return false;
    }

    public int treesize() {
        int n = 1;
        for (int i = 0; i < this.numChildren(); ++i) {
            n += this.getChild(i).treesize();
        }
        return n;
    }

    public boolean containsAux() {
        if (this instanceof Identifier && ((Identifier)this).global_symbols.category.get((Object)this.toString()).cat == 10) {
            return true;
        }
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).containsAux()) continue;
            return true;
        }
        return false;
    }

    public boolean isNegatable() {
        return false;
    }

    public ASTNode negation() {
        System.out.println("negation method not implemented:" + this.getClass().getName());
        assert (false);
        return null;
    }

    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        System.out.println("Missing toFlatzinc method. type:" + this.getClass().getName());
        assert (false);
    }

    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        System.out.println("Missing toFlatzincWithAuxVar method. type:" + this.getClass().getName());
        assert (false);
    }

    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        System.out.println("Missing toMinizinc method. type:" + this.getClass().getName());
        assert (false);
    }

    public ArrayList<ASTNode> list() {
        return new ArrayList<ASTNode>();
    }

    public ArrayList<ASTNode> list(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        return arrayList;
    }

    public ArrayList<ASTNode> list(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        return arrayList;
    }

    public Long toSATLiteral(Sat sat) {
        return null;
    }

    public void toSAT(Sat sat) throws IOException {
        if (!(this instanceof Top)) {
            CmdFlags.errorExit("Missing toSAT method. type:" + this.getClass().getName());
        }
        this.getChild(0).toSAT(sat);
    }

    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        CmdFlags.errorExit("Missing toSATWithAuxVar(long) method. type:" + this.getClass().getName() + " " + this + " " + this.getParent());
    }

    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        CmdFlags.errorExit("Missing toSATWithAuxVar(AST) method. type:" + this.getClass().getName() + " " + this + " " + this.getParent());
    }

    public boolean test(long l, long l2, long l3) {
        CmdFlags.errorExit("Missing test method. type:" + this.getClass().getName());
        return false;
    }

    public boolean test(long l, long l2) {
        CmdFlags.errorExit("Missing test method. type:" + this.getClass().getName());
        return false;
    }

    public boolean test(long l) {
        CmdFlags.errorExit("Missing test method. type:" + this.getClass().getName());
        return false;
    }

    public long func(long l, long l2) {
        CmdFlags.errorExit("Missing func method. type:" + this.getClass().getName());
        return 0L;
    }

    public long directEncode(Sat sat, long l) {
        CmdFlags.errorExit("Missing directEncode method. type:" + this.getClass().getName());
        return 0L;
    }

    public long orderEncode(Sat sat, long l) {
        CmdFlags.errorExit("Missing orderEncode method. type:" + this.getClass().getName());
        return 0L;
    }

    public void toJSONHeader(StringBuilder stringBuilder, boolean bl) {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        stringBuilder.append("{\n\"type\": \"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        if (this.numChildren() > 0) {
            stringBuilder.append(",\n\"symmetricChildren\": " + this.childrenAreSymmetric());
        }
        if (bl) {
            stringBuilder.append(",\n");
        } else {
            stringBuilder.append("\n");
        }
    }

    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Children\": [");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append("\n");
            this.getChild(i).toJSON(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]\n}");
    }

    public boolean childrenAreSymmetric() {
        return false;
    }

    public boolean isChildSymmetric(int n) {
        return false;
    }

    public boolean isMyOnlyOtherSiblingEqualZero(int n) {
        if (this.numChildren() != 2) {
            return false;
        }
        ASTNode aSTNode = n == 0 ? this.getChild(1) : this.getChild(0);
        return aSTNode instanceof NumberConstant && aSTNode.getValue() == 0L;
    }

    public boolean canChildBeConvertedToDifference(int n) {
        return false;
    }
}

