/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Unary;
import savilerow.expression.UnaryMinus;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Absolute
extends Unary {
    public static final long serialVersionUID = 1L;

    public Absolute(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Absolute(this.getChild(0));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            long l = this.getChild(0).getValue();
            if (l < 0L) {
                return new NumberConstant(-l);
            }
            return new NumberConstant(l);
        }
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower >= 0L) {
            return this.getChild(0);
        }
        if (intpair.upper <= 0L) {
            return new UnaryMinus(this.getChild(0));
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            CmdFlags.println("ERROR: Cannot apply absolute value operation to a matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower == Long.MIN_VALUE) {
            ++intpair.lower;
        }
        if (intpair.upper < 0L) {
            long l = intpair.upper;
            intpair.upper = -intpair.lower;
            intpair.lower = -l;
        } else if (intpair.lower < 0L) {
            if (intpair.upper > -intpair.lower) {
                intpair.lower = 0L;
            } else {
                intpair.upper = -intpair.lower;
                intpair.lower = 0L;
            }
        }
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        PairASTNode pairASTNode2 = new PairASTNode(null, null);
        pairASTNode2.e1 = new Max(pairASTNode.e1, new NumberConstant(0L));
        pairASTNode2.e2 = new Max(pairASTNode.e2, new UnaryMinus(pairASTNode.e1));
        return pairASTNode2;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("abs(");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("abs(");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Abs(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "|" + this.getChild(0) + "|";
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint int_abs(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("abs(");
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.supportEncodingBinary(this, this.getChild(0), aSTNode);
    }

    @Override
    public boolean test(long l, long l2) {
        return (l < 0L ? -l : l) == l2;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return true;
    }
}

