/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Equals;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class AllDifferent
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public AllDifferent(ASTNode aSTNode) {
        super(aSTNode);
    }

    public AllDifferent(ASTNode aSTNode, ASTNode aSTNode2) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        arrayList.add(aSTNode);
        arrayList.add(aSTNode2);
        this.setChildren(new CompoundMatrix(arrayList));
    }

    @Override
    public ASTNode copy() {
        assert (this.numChildren() == 1);
        return new AllDifferent(this.getChild(0));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in allDiff constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof EmptyMatrix) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof CompoundMatrix) {
            int n;
            ASTNode aSTNode = this.getChild(0);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                for (n = i + 1; n < aSTNode.numChildren(); ++n) {
                    if (aSTNode.getChild(i).equals(aSTNode.getChild(n))) {
                        return new BooleanConstant(false);
                    }
                    if (!aSTNode.getChild(i).isConstant() || !aSTNode.getChild(n).isConstant() || aSTNode.getChild(i).getValue() != aSTNode.getChild(n).getValue()) continue;
                    return new BooleanConstant(false);
                }
            }
            if (aSTNode.numChildren() < 3) {
                return new BooleanConstant(true);
            }
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            arrayList.remove(0);
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).isConstant()) continue;
                boolean bl = false;
                long l = arrayList.get(i).getValue();
                for (int j = 0; j < arrayList.size(); ++j) {
                    ASTNode aSTNode2;
                    if (i == j) continue;
                    Intpair intpair = arrayList.get(j).getBounds();
                    if (l < intpair.lower || l > intpair.upper) continue;
                    if (arrayList.get(j) instanceof Identifier && (aSTNode2 = ((Identifier)arrayList.get(j)).getDomain()).getCategory() == 0) {
                        if (!aSTNode2.containsValue(l)) continue;
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.remove(i);
                --i;
                n = 1;
            }
            if (n != 0) {
                return new AllDifferent(CompoundMatrix.makeCompoundMatrix(arrayList));
            }
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public ASTNode negation() {
        assert (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3);
        return new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2));
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
        arrayList.remove(0);
        boolean bl = AllDifferent.sortByHashcode(arrayList);
        if (bl) {
            return new AllDifferent(new CompoundMatrix(arrayList));
        }
        return this;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("diseq(");
            aSTNode.getChild(1).toMinion(stringBuilder, false);
            stringBuilder.append(",");
            aSTNode.getChild(2).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            String string = "gacalldiff";
            if (aSTNode instanceof CompoundMatrix) {
                for (int i = 1; i < aSTNode.numChildren(); ++i) {
                    if (!CmdFlags.getUseBoundVars() || !aSTNode.getChild(i).exceedsBoundThreshold()) continue;
                    string = "alldiff";
                    break;
                }
            }
            stringBuilder.append(string);
            stringBuilder.append("(");
            this.getChild(0).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        assert (this.getChild(0) instanceof CompoundMatrix);
        assert (this.getChild(0).numChildren() == 3);
        stringBuilder.append("(");
        this.getChild(0).getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("!=");
        this.getChild(0).getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getCategory() <= 2) {
            this.toDominionParam(stringBuilder);
            return;
        }
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("noteq(");
            aSTNode.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            aSTNode.getChild(2).toDominion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("alldiff(flatten(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append("))");
        }
    }

    @Override
    public String toString() {
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            return "(" + this.getChild(0).getChild(1) + " != " + this.getChild(0).getChild(2) + ")";
        }
        return "allDiff(" + this.getChild(0) + ")";
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        assert (this.numChildren() == 1);
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("constraint int_ne(");
            aSTNode.getChild(1).toFlatzinc(stringBuilder, false);
            stringBuilder.append(",");
            aSTNode.getChild(2).toFlatzinc(stringBuilder, false);
            stringBuilder.append(");");
        } else {
            stringBuilder.append("constraint all_different_int(");
            this.getChild(0).toFlatzinc(stringBuilder, false);
            stringBuilder.append(")::domain;");
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof CompoundMatrix && aSTNode.numChildren() == 3) {
            stringBuilder.append("(");
            aSTNode.getChild(1).toMinizinc(stringBuilder, false);
            stringBuilder.append("!=");
            aSTNode.getChild(2).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            stringBuilder.append("all_different(");
            this.getChild(0).toMinizinc(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0).getChild(1);
        ASTNode aSTNode2 = this.getChild(0).getChild(2);
        if (aSTNode.isConstant()) {
            return -aSTNode2.directEncode(sat, aSTNode.getValue());
        }
        if (aSTNode2.isConstant()) {
            return -aSTNode.directEncode(sat, aSTNode2.getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        ASTNode aSTNode = this.getChild(0);
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = i + 1; j < aSTNode.numChildren(); ++j) {
                sat.directEncoding(this, aSTNode.getChild(i), aSTNode.getChild(j));
            }
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        assert (this.getChild(0).numChildren() == 3);
        new Equals(this.getChild(0).getChild(1), this.getChild(0).getChild(2)).toSATWithAuxVar(sat, -l);
    }

    @Override
    public boolean test(long l, long l2) {
        return l != l2;
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        this.toJSONHeader(stringBuilder, true);
        stringBuilder.append("\"Children\": [");
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3) {
            this.getChild(0).getChild(1).toJSON(stringBuilder);
            stringBuilder.append(", ");
            this.getChild(0).getChild(2).toJSON(stringBuilder);
        } else {
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append("\n");
                this.getChild(i).toJSON(stringBuilder);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("]\n}");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return this.getChild(0) instanceof CompoundMatrix && this.getChild(0).numChildren() == 3;
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return !(this.getChild(0) instanceof CompoundMatrix) || this.getChild(0).numChildren() != 3;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return this.isMyOnlyOtherSiblingEqualZero(n);
    }
}

