/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Negate;
import savilerow.expression.Or;
import savilerow.expression.SATLiteral;
import savilerow.expression.Top;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class And
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public And(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public And(ASTNode aSTNode, ASTNode aSTNode2) {
        this.setChildren(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new And(this.getChildren());
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        boolean bl = false;
        ArrayList<ASTNode> arrayList = this.getChildren();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof And)) continue;
            bl = true;
            ASTNode aSTNode = arrayList.remove(n);
            --n;
            arrayList.addAll(aSTNode.getChildren());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isConstant()) continue;
            long l = arrayList.get(n).getValue();
            if (l == 1L) {
                bl = true;
                arrayList.remove(n);
                --n;
                continue;
            }
            return new BooleanConstant(false);
        }
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>(arrayList);
        if (hashSet.size() < arrayList.size()) {
            bl = true;
            arrayList.clear();
            arrayList.addAll(hashSet);
        }
        if (arrayList.size() == 0) {
            return new BooleanConstant(true);
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (bl) {
            return new And(arrayList);
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(new Negate(this.getChild(i)));
        }
        return new Or(arrayList);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: 'And' contains something other than a relation:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        if (this.getParent() instanceof Top) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = And.sortByHashcode(arrayList);
        if (bl) {
            return new And(arrayList);
        }
        return this;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinion(stringBuilder, true);
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append("watched-and({");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinion(stringBuilder, true);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("})");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append(this.getChild(i).toString());
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",\n");
            }
        } else {
            stringBuilder.append("(");
            for (int i = 0; i < this.numChildren(); ++i) {
                stringBuilder.append(this.getChild(i).toString());
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(" /\\ ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getParent() instanceof Top) {
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, true);
                stringBuilder.append("\n");
            }
        } else {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("and([");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toDominion(stringBuilder, true);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("])");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("And([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        assert (this.inTopConjunction());
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof Identifier) {
                stringBuilder.append("constraint bool_eq(");
                this.getChild(i).toFlatzinc(stringBuilder, true);
                stringBuilder.append(",true);\n");
                continue;
            }
            this.getChild(i).toFlatzinc(stringBuilder, false);
            stringBuilder.append("\n");
        }
    }

    @Override
    public boolean inTopConjunction() {
        return this.getParent().inTopConjunction();
    }

    @Override
    public boolean inTopAnd() {
        return this.getParent().inTopAnd();
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint array_bool_and([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],");
        aSTNode.toFlatzinc(stringBuilder, true);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.inTopConjunction()) {
            for (int i = 0; i < this.numChildren(); ++i) {
                if (this.getChild(i) instanceof Identifier) {
                    stringBuilder.append("constraint ");
                    this.getChild(i).toMinizinc(stringBuilder, true);
                    stringBuilder.append(" <-> true;\n");
                    continue;
                }
                stringBuilder.append("constraint ");
                this.getChild(i).toMinizinc(stringBuilder, true);
                stringBuilder.append(";\n");
            }
        } else {
            stringBuilder.append("(");
            for (int i = 0; i < this.numChildren(); ++i) {
                this.getChild(i).toMinizinc(stringBuilder, true);
                if (i >= this.numChildren() - 1) continue;
                stringBuilder.append(" /\\ ");
            }
            stringBuilder.append(")");
        }
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(i);
            sat.addComment(String.valueOf(aSTNode).replaceAll("\n", " "));
            if (aSTNode instanceof Negate) {
                sat.addClause(String.valueOf(aSTNode.getChild(0).directEncode(sat, 0L)));
                continue;
            }
            if (aSTNode instanceof Identifier) {
                sat.addClause(String.valueOf(aSTNode.directEncode(sat, 1L)));
                continue;
            }
            aSTNode.toSAT(sat);
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.numChildren());
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(i);
            assert (aSTNode instanceof SATLiteral);
            arrayList.add(-((SATLiteral)aSTNode).getLit());
        }
        sat.addClauseReified(arrayList, -l);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

