/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.model.SymbolTable;

public class AndVector
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public AndVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new AndVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(0).isRelation()) {
            System.out.println("ERROR: 'And' function contains something other than a boolean matrix:" + this);
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in and function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            return new And(arrayList);
        }
        return this;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        return "and(" + this.getChild(0) + ")";
    }
}

