/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.GlobalCard;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.model.SymbolTable;

public class AtLeast
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public AtLeast(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new AtLeast(this.getChild(0), this.getChild(1), this.getChild(2));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 3; ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() == 1) continue;
            CmdFlags.println("ERROR: Expected one-dimensional matrix for each argument of atleast constraint: " + this);
            return false;
        }
        if (this.getChild(1).getCategory() > 2 || this.getChild(2).getCategory() > 2) {
            CmdFlags.println("ERROR: Atleast functions do not allow decision variables in the second or third arguments: " + this);
            return false;
        }
        if ((this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) && (this.getChild(2) instanceof CompoundMatrix || this.getChild(2) instanceof EmptyMatrix) && this.getChild(1).numChildren() != this.getChild(2).numChildren()) {
            CmdFlags.println("ERROR: Atleast function expects second and third arguments to be the same length: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(1) instanceof EmptyMatrix) {
            assert (this.getChild(2) instanceof EmptyMatrix);
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(1) instanceof CompoundMatrix && this.getChild(2) instanceof CompoundMatrix) {
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                if (!this.getChild(1).getChild(i).isConstant()) continue;
                if (this.getChild(1).getChild(i).getValue() <= 0L) {
                    ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
                    arrayList.remove(i);
                    arrayList.remove(0);
                    ArrayList<ASTNode> arrayList2 = this.getChild(2).getChildren();
                    arrayList2.remove(i);
                    arrayList2.remove(0);
                    return new AtLeast(this.getChild(0), CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
                }
                if (this.getChild(1).getChild(i).getValue() <= (long)(this.getChild(0).numChildren() - 1)) continue;
                return new BooleanConstant(false);
            }
        }
        if (this.getChild(0) instanceof EmptyMatrix && (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix)) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                arrayList.add(new LessEqual(this.getChild(1).getChild(i), new NumberConstant(0L)));
            }
            return new And(arrayList);
        }
        if (this.getChild(0) instanceof CompoundMatrix && this.getChild(1).getCategory() == 0 && this.getChild(2).getCategory() == 0) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            ArrayList<ASTNode> arrayList3 = this.getChild(2).getChildren();
            arrayList3.remove(0);
            ArrayList<ASTNode> arrayList4 = this.getChild(1).getChildren();
            arrayList4.remove(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get(i).isConstant()) continue;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    if (!arrayList3.get(j).equals(arrayList.get(i))) continue;
                    arrayList4.set(j, BinOp.makeBinOp("-", arrayList4.get(j), new NumberConstant(1L)));
                }
                arrayList.remove(i);
                return new AtLeast(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList4), this.getChild(2));
            }
        }
        return this;
    }

    @Override
    public ASTNode normalise() {
        if (!(this.getChild(0) instanceof CompoundMatrix)) {
            return this;
        }
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
        arrayList.remove(0);
        boolean bl = AtLeast.sortByHashcode(arrayList);
        if (bl) {
            return new AtLeast(new CompoundMatrix(arrayList), this.getChild(1), this.getChild(2));
        }
        return this;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (this.getChild(2).getCategory() == 0);
        assert (bl);
        assert (this.getChild(1) instanceof CompoundMatrix && this.getChild(1).numChildren() == 2);
        assert (this.getChild(2) instanceof CompoundMatrix && this.getChild(2).numChildren() == 2);
        stringBuilder.append("occurrencegeq(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(2).getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (this.getChild(2).getCategory() == 0);
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("occurrencegeq(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(2).getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint at_least_int(");
        this.getChild(1).getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(2).getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public String toString() {
        return "atleast(" + this.getChild(0) + "," + this.getChild(1) + "," + this.getChild(2) + ")";
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("at_least(");
        this.getChild(1).getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(2).getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        GlobalCard.toAlternateJSON(this, stringBuilder);
    }

    @Override
    public boolean isChildSymmetric(int n) {
        return n == 0;
    }
}

