/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.model.SymbolTable;

public class Concatenate
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Concatenate(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    @Override
    public ASTNode copy() {
        return new Concatenate(this.getChildren());
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() >= 1) continue;
            System.out.println("ERROR: Expected 1-dimensional or greater matrix inside concatenate: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (this.getChild(i) instanceof CompoundMatrix || this.getChild(i) instanceof EmptyMatrix) continue;
            return this;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ArrayList<ASTNode> arrayList2 = this.getChild(i).getChildren();
            arrayList2.remove(0);
            arrayList.addAll(arrayList2);
        }
        return CompoundMatrix.makeCompoundMatrix(arrayList);
    }

    @Override
    public int getDimension() {
        if (this.numChildren() == 0) {
            return 1;
        }
        return this.getChild(0).getDimension();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("concatenate(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i));
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

