/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Concatenate;
import savilerow.expression.EmptyMatrix;
import savilerow.model.SymbolTable;

public class ConcatenateMatrix
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ConcatenateMatrix(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new ConcatenateMatrix(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() < 2) {
            System.out.println("ERROR: Expected 2-dimensional or greater matrix inside concatenate: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            return new Concatenate(arrayList);
        }
        return this;
    }

    @Override
    public int getDimension() {
        return this.getChild(0).getDimension() - 1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("concatenate(");
        stringBuilder.append(this.getChild(0));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

