/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Element;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;

public class ElementOne
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ElementOne(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ElementOne(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix) {
            if (this.getChild(1).isConstant()) {
                long l = this.getChild(1).getValue();
                if (l < 1L || l >= (long)this.getChild(0).numChildren()) {
                    return this;
                }
                return this.getChild(0).getChild((int)l);
            }
            Intpair intpair = this.getChild(1).getBounds();
            int n = this.getChild(0).numChildren() - 1;
            if (intpair.upper < (long)n) {
                ArrayList<ASTNode> arrayList = this.list();
                int n2 = 1;
                while ((long)n2 <= intpair.upper) {
                    arrayList.add(this.getChild(0).getChild(n2));
                    ++n2;
                }
                return new ElementOne(CompoundMatrix.makeCompoundMatrix(arrayList), this.getChild(1));
            }
            if (this.getChild(1).toFlatten(false) && (intpair.lower > 1L || intpair.upper < (long)n)) {
                ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
                if (intpair.lower < 1L) {
                    intpair.lower = 1L;
                }
                if (intpair.upper > (long)n) {
                    intpair.upper = n;
                }
                for (long i = intpair.lower; i <= intpair.upper; ++i) {
                    arrayList.add(this.getChild(0).getChild((int)i));
                }
                return new ElementOne(CompoundMatrix.makeCompoundMatrix(arrayList), BinOp.makeBinOp("-", this.getChild(1), new NumberConstant(intpair.lower - 1L)));
            }
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
        arrayList.set(0, new NumberConstant(0L));
        Element element = new Element(CompoundMatrix.makeCompoundMatrix(arrayList), this.getChild(1));
        ((ASTNode)element).toMinionWithAuxVar(stringBuilder, aSTNode);
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint array_int_element(");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append("[");
        this.getChild(1).toMinizinc(stringBuilder, bl);
        stringBuilder.append("])");
    }
}

