/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.AllDifferent;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.WeightedSum;
import savilerow.model.Sat;
import savilerow.treetransformer.TransformSimplify;

public class Equals
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Equals(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Equals(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        Pair<ASTNode, ASTNode> pair;
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof Negate && this.getChild(0).getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(false);
        }
        if (this.getChild(1) instanceof Negate && this.getChild(1).getChild(0).equals(this.getChild(0))) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(false);
        }
        TransformSimplify transformSimplify = new TransformSimplify();
        if (this.getChild(0) instanceof Identifier && this.getChild(1).isConstant() && ((ASTNode)((Object)(pair = ((Identifier)this.getChild(0)).getDomain()))).getCategory() == 0 && !((ASTNode)((Object)(pair = transformSimplify.transform((ASTNode)((Object)pair))))).containsValue(this.getChild(1).getValue())) {
            return new BooleanConstant(false);
        }
        if (this.getChild(1) instanceof Identifier && this.getChild(0).isConstant() && ((ASTNode)((Object)(pair = ((Identifier)this.getChild(1)).getDomain()))).getCategory() == 0 && !((ASTNode)((Object)(pair = transformSimplify.transform((ASTNode)((Object)pair))))).containsValue(this.getChild(0).getValue())) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            return new Equals(BinOp.makeBinOp("-", this.getChild(0), this.getChild(1)), new NumberConstant(0L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(0)).retrieveConstant()) != null) {
            return new Equals(pair.getSecond(), BinOp.makeBinOp("-", this.getChild(1), pair.getFirst()));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(1)).retrieveConstant()) != null) {
            return new Equals(BinOp.makeBinOp("-", this.getChild(0), pair.getFirst()), pair.getSecond());
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new AllDifferent(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode normalise() {
        if (this.getChild(0).hashCode() > this.getChild(1).hashCode()) {
            return new Equals(this.getChild(1), this.getChild(0));
        }
        return this;
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "=" + this.getChild(1) + ")";
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        if (this.getChild(0).isConstant()) {
            if (CmdFlags.getUseBoundVars() && this.getChild(1).exceedsBoundThreshold()) {
                stringBuilder.append("eq(");
            } else {
                stringBuilder.append("w-literal(");
            }
            this.getChild(1).toMinion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(0).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else if (this.getChild(1).isConstant()) {
            if (CmdFlags.getUseBoundVars() && this.getChild(0).exceedsBoundThreshold()) {
                stringBuilder.append("eq(");
            } else {
                stringBuilder.append("w-literal(");
            }
            this.getChild(0).toMinion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(1).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        } else {
            if (CmdFlags.getUseBoundVars() && (this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
                stringBuilder.append("eq(");
            } else {
                stringBuilder.append("gaceq(");
            }
            this.getChild(0).toMinion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(1).toMinion(stringBuilder, false);
            stringBuilder.append(")");
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0).getCategory() <= 2) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(0).toDominionParam(stringBuilder);
            stringBuilder.append(")");
            return;
        }
        if (this.getChild(1).getCategory() <= 2) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(1).toDominionParam(stringBuilder);
            stringBuilder.append(")");
            return;
        }
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("eq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("=");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint int_eq(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("==");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        this.encodeEquality(sat, false, 0L);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.encodeEquality(sat, true, l);
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(this.getChild(0));
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(this.getChild(1));
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                sat.addClause(String.valueOf(-this.getChild(0).directEncode(sat, i)) + " " + String.valueOf(-this.getChild(1).directEncode(sat, i)) + " " + String.valueOf(l));
            }
        }
    }

    private void encodeEquality(Sat sat, boolean bl, long l) throws IOException {
        long l2;
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(this.getChild(0));
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(this.getChild(1));
        for (Intpair intpair : arrayList) {
            for (l2 = intpair.lower; l2 <= intpair.upper; ++l2) {
                if (bl) {
                    sat.addClause(String.valueOf(-this.getChild(0).directEncode(sat, l2)) + " " + String.valueOf(this.getChild(1).directEncode(sat, l2)) + " " + String.valueOf(-l));
                    continue;
                }
                sat.addClause(String.valueOf(-this.getChild(0).directEncode(sat, l2)) + " " + String.valueOf(this.getChild(1).directEncode(sat, l2)));
            }
        }
        for (Intpair intpair : arrayList2) {
            for (l2 = intpair.lower; l2 <= intpair.upper; ++l2) {
                if (bl) {
                    sat.addClause(String.valueOf(-this.getChild(1).directEncode(sat, l2)) + " " + String.valueOf(this.getChild(0).directEncode(sat, l2)) + " " + String.valueOf(-l));
                    continue;
                }
                sat.addClause(String.valueOf(-this.getChild(1).directEncode(sat, l2)) + " " + String.valueOf(this.getChild(0).directEncode(sat, l2)));
            }
        }
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }

    @Override
    public boolean canChildBeConvertedToDifference(int n) {
        return this.isMyOnlyOtherSiblingEqualZero(n);
    }
}

