/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.model.SymbolTable;

public class Factorial
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Factorial(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Factorial(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getCategory() >= 3) {
            System.out.println("ERROR: Factorial may not contain decision variables:" + this);
            return false;
        }
        if (this.getChild(0).getDimension() > 0) {
            System.out.println("ERROR: Factorial may not contain a matrix:" + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            long l = this.getChild(0).getValue();
            if (l < 0L) {
                return this;
            }
            if (l > 20L) {
                CmdFlags.errorExit("Cannot evaluate factorial of number greater than 20 (because of overflow of 64-bit integer):" + this);
            }
            return new NumberConstant(this.fact(l));
        }
        return this;
    }

    private long fact(long l) {
        long l2 = 1L;
        int n = 2;
        while ((long)n <= l) {
            l2 *= (long)n;
            ++n;
        }
        return l2;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        long l = 1L;
        long l2 = this.fact(20L);
        if (intpair.upper <= 20L) {
            l2 = intpair.upper < 0L ? 0L : this.fact(intpair.upper);
        }
        if (intpair.lower > 1L) {
            if (intpair.lower > 20L) {
                l2 = 0L;
                l = 1L;
            } else {
                l = this.fact(intpair.lower);
            }
        }
        intpair.lower = l;
        intpair.upper = l2;
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = new Factorial(pairASTNode.e1);
        pairASTNode.e2 = new Factorial(pairASTNode.e2);
        return pairASTNode;
    }

    @Override
    public String toString() {
        return "factorial(" + this.getChild(0) + ")";
    }
}

