/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Implies;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.Quantifier;
import savilerow.expression.SimpleDomain;
import savilerow.treetransformer.ReplaceASTNode;

public class ForallExpression
extends Quantifier {
    public static final long serialVersionUID = 1L;

    public ForallExpression(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, aSTNode2, aSTNode3, new BooleanConstant(true));
    }

    public ForallExpression(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) {
        super(aSTNode, aSTNode2, aSTNode3, aSTNode4);
    }

    @Override
    public ASTNode copy() {
        return new ForallExpression(this.getChild(0), this.getChild(1), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public String toString() {
        if (!this.getChild(3).equals(new BooleanConstant(true))) {
            return "(forall " + this.getChild(0) + " : " + this.getChild(1) + " , " + this.getChild(3) + " . " + this.getChild(2) + ")";
        }
        return "(forall " + this.getChild(0) + " : " + this.getChild(1) + " . " + this.getChild(2) + ")";
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(2) instanceof BooleanConstant && this.getChild(2).getValue() == 1L) {
            return new BooleanConstant(true);
        }
        if (this.getChild(1) instanceof SimpleDomain && this.getChild(1).getCategory() == 0 && !CmdFlags.getClasstrans()) {
            Intpair intpair = this.getChild(1).getBounds();
            if (intpair.lower + 100L >= intpair.upper) {
                ArrayList<Long> arrayList = this.getChild(1).getValueSet();
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    ASTNode aSTNode = this.getChild(2).copy();
                    if (!this.getChild(3).equals(new BooleanConstant(true))) {
                        aSTNode = new Implies(this.getChild(3), aSTNode);
                    }
                    ReplaceASTNode replaceASTNode = new ReplaceASTNode(this.getChild(0), new NumberConstant(arrayList.get(i)));
                    aSTNode = replaceASTNode.transform(aSTNode);
                    arrayList2.add(aSTNode);
                }
                return new And(arrayList2);
            }
        }
        return this;
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Min([");
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("|");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        if (this.getChild(2) instanceof Implies && this.getChild(2).getChild(0).getCategory() <= 2) {
            stringBuilder.append(", ");
            ASTNode aSTNode = this.getChild(2).getChild(0);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    aSTNode.getChild(i).toDominionParam(stringBuilder);
                    if (i >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                this.getChild(2).getChild(0).toDominionParam(stringBuilder);
            }
        }
        stringBuilder.append("])");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (!this.getParent().inTopAnd()) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("and(");
        }
        stringBuilder.append("[");
        boolean bl2 = false;
        if (this.getChild(2) instanceof Implies && this.getChild(2).getChild(0).getCategory() <= 2) {
            this.getChild(2).getChild(1).toDominion(stringBuilder, true);
            bl2 = true;
        } else {
            this.getChild(2).toDominion(stringBuilder, true);
        }
        stringBuilder.append(" | ");
        ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(" in {");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append("}");
        if (bl2) {
            stringBuilder.append(", ");
            ASTNode aSTNode = this.getChild(2).getChild(0);
            if (aSTNode instanceof And) {
                for (int i = 0; i < aSTNode.numChildren(); ++i) {
                    aSTNode.getChild(i).toDominionParam(stringBuilder);
                    if (i >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                this.getChild(2).getChild(0).toDominionParam(stringBuilder);
            }
        }
        stringBuilder.append("]");
        if (!this.getParent().inTopAnd()) {
            stringBuilder.append(")");
        }
    }

    @Override
    public boolean inTopConjunction() {
        return this.getParent().inTopConjunction();
    }
}

