/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.HoleyMatrixDomain;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Identifier
extends ASTNode {
    public static final long serialVersionUID = 1L;
    private String name;
    public SymbolTable global_symbols;

    public Identifier(String string, SymbolTable symbolTable) {
        this.name = string;
        this.global_symbols = symbolTable;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public ASTNode copy() {
        return new Identifier(this.name, this.global_symbols);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Identifier)) {
            return false;
        }
        return ((Identifier)object).name.equals(this.name);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int n;
            this.hashCache = n = this.name.hashCode();
            return n;
        }
        return this.hashCache;
    }

    @Override
    public boolean isRelation() {
        if (this.global_symbols.hasVariable(this.name)) {
            return this.global_symbols.isRelational(this.name);
        }
        ASTNode aSTNode = this.getDomainForId(this);
        if (aSTNode instanceof BooleanDomain) {
            return true;
        }
        return aSTNode instanceof MatrixDomain && aSTNode.getChild(0) instanceof BooleanDomain;
    }

    @Override
    public boolean isNumerical() {
        return !this.isRelation() && !this.isSet();
    }

    @Override
    public boolean isSet() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(this.global_symbols.lettings_givens);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof Letting) || !arrayList.get(i).getChild(0).equals(this) || !arrayList.get(i).getChild(1).isSet()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCategory() {
        if (this.global_symbols.hasVariable(this.name)) {
            return this.global_symbols.getCategory(this.name);
        }
        if (this.getDomainForId(this) != null) {
            return 2;
        }
        return 20;
    }

    public boolean isAuxiliary() {
        return this.global_symbols.getCategories().get((Object)this.name).cat == 10;
    }

    @Override
    public int getDimension() {
        ASTNode aSTNode = this.getDomainForId(this);
        if (aSTNode == null) {
            aSTNode = this.global_symbols.getDomain(this.name);
        }
        if (aSTNode instanceof MatrixDomain) {
            return aSTNode.numChildren() - 3;
        }
        if (aSTNode instanceof HoleyMatrixDomain) {
            return aSTNode.getChild(0).numChildren() - 3;
        }
        return 0;
    }

    @Override
    public ArrayList<ASTNode> getIndexDomains() {
        if (this.getDimension() == 0) {
            return null;
        }
        ASTNode aSTNode = this.getDomainForId(this);
        if (aSTNode == null) {
            aSTNode = this.global_symbols.getDomain(this.name);
        }
        if (aSTNode instanceof MatrixDomain) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            arrayList.remove(0);
            arrayList.remove(0);
            arrayList.remove(0);
            return arrayList;
        }
        assert (false);
        return null;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        assert (symbolTable == this.global_symbols);
        if (this.global_symbols.hasVariable(this.name)) {
            return true;
        }
        if (this.getDomainForId(this) != null) {
            return true;
        }
        System.out.println("ERROR: Identifier not defined: " + this);
        return false;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.global_symbols.replacements.get(this);
        if (aSTNode != null) {
            return aSTNode.copy();
        }
        return this;
    }

    public ASTNode getDomain() {
        ASTNode aSTNode = this.global_symbols.getDomain(this.name);
        if (aSTNode == null) {
            aSTNode = this.getDomainForId(this);
        }
        assert (aSTNode != null);
        return aSTNode;
    }

    @Override
    public Intpair getBounds() {
        ASTNode aSTNode = this.getDomain();
        if (aSTNode instanceof MatrixDomain) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode.getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        int n = this.getCategory();
        if (n == 20) {
            System.out.println(this);
        }
        assert (n != 20);
        if (n == 1 || n == 0) {
            ASTNode aSTNode = this.global_symbols.getDomain(this.name);
            if (aSTNode instanceof SimpleDomain) {
                return new PairASTNode(this, this);
            }
            if (aSTNode instanceof MatrixDomain) {
                return aSTNode.getChild(0).getBoundsAST();
            }
            System.out.println("Strange parameter type in Identifier.java");
            assert (false);
            return new PairASTNode(this, this);
        }
        if (n == 2) {
            ASTNode aSTNode = this.getDomainForId(this);
            assert (aSTNode != null);
            if (aSTNode instanceof MatrixDomain) {
                aSTNode = aSTNode.getChild(0);
            }
            PairASTNode pairASTNode = aSTNode.getBoundsAST();
            while (pairASTNode.e1.getCategory() > 1) {
                pairASTNode.e1 = pairASTNode.e1.getBoundsAST().e1;
            }
            while (pairASTNode.e2.getCategory() > 1) {
                pairASTNode.e2 = pairASTNode.e2.getBoundsAST().e2;
            }
            return pairASTNode;
        }
        assert (n == 3);
        ASTNode aSTNode = this.global_symbols.getDomain(this.name);
        if (aSTNode instanceof MatrixDomain) {
            aSTNode = aSTNode.getChild(0);
        }
        return aSTNode.getBoundsAST();
    }

    public boolean setBounds(long l, long l2) {
        int n;
        ArrayList<Intpair> arrayList = this.global_symbols.getDomain(this.name).getIntervalSet();
        ArrayList<Intpair> arrayList2 = new ArrayList<Intpair>();
        boolean bl = false;
        Intpair intpair = new Intpair(l, l2);
        for (n = 0; n < arrayList.size(); ++n) {
            Intpair intpair2 = intpair.intersect(arrayList.get(n));
            if (intpair2.equals(arrayList.get(n))) {
                arrayList2.add(intpair2);
                continue;
            }
            bl = true;
            if (intpair2.isEmpty()) continue;
            arrayList2.add(intpair2);
        }
        if (bl) {
            n = this.global_symbols.getDomain(this.name) instanceof BooleanDomain;
            this.global_symbols.setDomain(this.name, Intpair.makeDomain(arrayList2, n != 0));
        }
        return bl;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            if (CmdFlags.getUseBoundVars() && this.exceedsBoundThreshold()) {
                stringBuilder.append("eq(");
            } else {
                stringBuilder.append("w-literal(");
            }
            stringBuilder.append(this.name);
            stringBuilder.append(",1)");
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
            stringBuilder.append(this.name);
            stringBuilder.append(",1)");
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append(this.name);
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.global_symbols.getDomain(this.name);
        if (this.global_symbols.hasVariable(this.name) && (aSTNode instanceof BooleanDomain || aSTNode.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L)))))) {
            if (bl) {
                stringBuilder.append(this.name + "_BOOL");
            } else {
                stringBuilder.append(this.name + "_INTEGER");
            }
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        ASTNode aSTNode = this.global_symbols.getDomain(this.name);
        if (this.global_symbols.hasVariable(this.name) && (aSTNode instanceof BooleanDomain || aSTNode.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L)))))) {
            if (bl) {
                stringBuilder.append(this.name + "_BOOL");
            } else {
                stringBuilder.append(this.name + "_INTEGER");
            }
        } else {
            stringBuilder.append(this.name);
        }
    }

    @Override
    public long directEncode(Sat sat, long l) {
        return sat.getDirectVariable(this.name, l);
    }

    @Override
    public long orderEncode(Sat sat, long l) {
        return sat.getOrderVariable(this.name, l);
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.isRelation()) {
            return sat.getDirectVariable(this.name, 1L);
        }
        return null;
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        long l2 = sat.getDirectVariable(this.name, 1L);
        sat.addClause(-l + " " + l2);
        sat.addClause(l + " " + -l2);
    }

    @Override
    public void toJSON(StringBuilder stringBuilder) {
        stringBuilder.append("\"$" + this.name + "\"\n");
    }
}

