/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.LogicBinOp;
import savilerow.expression.Negate;
import savilerow.expression.SATLiteral;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Iff
extends LogicBinOp {
    public static final long serialVersionUID = 1L;

    public Iff(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Iff(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 1L) {
            return this.getChild(1);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            return this.getChild(0);
        }
        if (this.getChild(0).isConstant() && this.getChild(0).getValue() == 0L) {
            return new Negate(this.getChild(1));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L) {
            return new Negate(this.getChild(0));
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            return new BooleanConstant(this.getChild(0).getValue() == this.getChild(1).getValue());
        }
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        if (this.getChild(0) instanceof Negate && this.getChild(0).getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(false);
        }
        if (this.getChild(1) instanceof Negate && this.getChild(1).getChild(0).equals(this.getChild(0))) {
            return new BooleanConstant(false);
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        if (this.getChild(0) instanceof Identifier) {
            return new Iff(new Negate(this.getChild(0)), this.getChild(1));
        }
        if (this.getChild(1) instanceof Identifier) {
            return new Iff(this.getChild(0), new Negate(this.getChild(1)));
        }
        if (this.getChild(0).isNegatable()) {
            return new Iff(new Negate(this.getChild(0)), this.getChild(1));
        }
        return new Iff(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public ASTNode normalise() {
        if (this.getChild(0).hashCode() > this.getChild(1).hashCode()) {
            return new Iff(this.getChild(1), this.getChild(0));
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: Iff contains non-relation expression:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("eq(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("eq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("=");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint bool_eq(");
        this.getChild(0).toFlatzinc(stringBuilder, true);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, true);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append("<->");
        this.getChild(1).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            return this.getChild(1).directEncode(sat, this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            return this.getChild(0).directEncode(sat, this.getChild(1).getValue());
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        if (this.getChild(0) instanceof SATLiteral) {
            this.getChild(1).toSATWithAuxVar(sat, ((SATLiteral)this.getChild(0)).getLit());
        } else if (this.getChild(1) instanceof SATLiteral) {
            this.getChild(0).toSATWithAuxVar(sat, ((SATLiteral)this.getChild(1)).getLit());
        } else {
            long l = sat.createAuxSATVariable();
            this.getChild(0).toSATWithAuxVar(sat, l);
            this.getChild(1).toSATWithAuxVar(sat, l);
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        long l2 = sat.createAuxSATVariable();
        long l3 = sat.createAuxSATVariable();
        this.getChild(0).toSATWithAuxVar(sat, l2);
        this.getChild(1).toSATWithAuxVar(sat, l3);
        String string = -l + " " + -l2 + " " + l3;
        String string2 = -l + " " + l2 + " " + -l3;
        String string3 = l + " " + l2 + " " + l3;
        String string4 = l + " " + -l2 + " " + -l3;
        sat.addClause(string);
        sat.addClause(string2);
        sat.addClause(string3);
        sat.addClause(string4);
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " <-> " + this.getChild(1) + ")";
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

