/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.model.SymbolTable;

public class Max
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Max(ArrayList<ASTNode> arrayList) {
        super(arrayList);
        assert (arrayList.size() >= 1);
    }

    public Max(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Max(this.getChildren());
    }

    @Override
    public boolean isRelation() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        int n2;
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = false;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (!(arrayList.get(n2) instanceof Max)) continue;
            arrayList.addAll(arrayList.get(n2).getChildren());
            arrayList.remove(n2);
            --n2;
            bl = true;
        }
        n2 = 0;
        long l = Long.MIN_VALUE;
        for (n = 0; n < arrayList.size(); ++n) {
            long l2;
            if (arrayList.get(n) instanceof PosInfinity) {
                return arrayList.get(n);
            }
            if (!arrayList.get(n).isConstant()) continue;
            if (n2 != 0) {
                bl = true;
            }
            l = l > (l2 = arrayList.get(n).getValue()) ? l : l2;
            arrayList.remove(n);
            --n;
            n2 = 1;
        }
        if (n2 != 0) {
            arrayList.add(new NumberConstant(l));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                if (!arrayList.get(n).equals(arrayList.get(i))) continue;
                arrayList.remove(i);
                --i;
                bl = true;
            }
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (bl) {
            return new Max(arrayList);
        }
        return this;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Max.sortByHashcode(arrayList);
        if (bl) {
            return new Max(arrayList);
        }
        return this;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!this.getChild(i).typecheck(symbolTable)) {
                return false;
            }
            if (this.getChild(i).getDimension() <= 0) continue;
            CmdFlags.println("ERROR: Unexpected matrix in max: " + this);
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        long l = intpair.lower;
        long l2 = intpair.upper;
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            if (intpair2.lower > l) {
                l = intpair2.lower;
            }
            if (intpair2.upper <= l2) continue;
            l2 = intpair2.upper;
        }
        intpair.lower = l;
        intpair.upper = l2;
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode = this.getChild(i).getBoundsAST();
            arrayList.add(pairASTNode.e1);
            arrayList2.add(pairASTNode.e2);
        }
        return new PairASTNode(new Max(arrayList), new Max(arrayList2));
    }

    @Override
    public String toString() {
        return this.generic_to_string("max");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Max([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("max([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("max([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        assert (this.numChildren() == 2);
        stringBuilder.append("constraint int_max(");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(",");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("max([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, bl);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

