/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Times;
import savilerow.treetransformer.TransformSimplify;

public class MultiplyMapper
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public MultiplyMapper(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new MultiplyMapper(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public ASTNode simplify() {
        assert (this.getChild(0).getCategory() == 3 || this.getChild(0).getCategory() == 20);
        assert (this.getChild(1).getCategory() <= 2 || this.getChild(1).getCategory() == 20);
        if (this.getChild(1).equals(new NumberConstant(1L))) {
            return this.getChild(0);
        }
        if (this.getChild(1).equals(new NumberConstant(0L))) {
            return new NumberConstant(0L);
        }
        if (this.getChild(0) instanceof MultiplyMapper) {
            ASTNode aSTNode = BinOp.makeBinOp("*", this.getChild(1), this.getChild(0).getChild(1));
            return new MultiplyMapper(this.getChild(0).getChild(0), aSTNode);
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        for (int i = 1; i < this.numChildren(); ++i) {
            Intpair intpair2 = this.getChild(i).getBounds();
            long l = Times.multiply(intpair.lower, intpair2.lower);
            long l2 = Times.multiply(intpair.upper, intpair2.lower);
            long l3 = Times.multiply(intpair.lower, intpair2.upper);
            long l4 = Times.multiply(intpair.upper, intpair2.upper);
            intpair.lower = Math.min(l, Math.min(l2, Math.min(l3, l4)));
            intpair.upper = Math.max(l, Math.max(l2, Math.max(l3, l4)));
        }
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        for (int i = 1; i < this.numChildren(); ++i) {
            PairASTNode pairASTNode2 = this.getChild(i).getBoundsAST();
            Times times = new Times(pairASTNode.e1, pairASTNode2.e1);
            Times times2 = new Times(pairASTNode.e2, pairASTNode2.e1);
            Times times3 = new Times(pairASTNode.e1, pairASTNode2.e2);
            Times times4 = new Times(pairASTNode.e2, pairASTNode2.e2);
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            arrayList.add(times);
            arrayList.add(times2);
            arrayList.add(times3);
            arrayList.add(times4);
            pairASTNode.e1 = new Min(arrayList);
            pairASTNode.e2 = new Max(arrayList);
        }
        return pairASTNode;
    }

    @Override
    public String toString() {
        return "mult(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(1).equals(new NumberConstant(-1L))) {
            stringBuilder.append("neg(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append(")");
            return;
        }
        PairASTNode pairASTNode = this.getChild(1).getBoundsAST();
        TransformSimplify transformSimplify = new TransformSimplify();
        pairASTNode.e1 = transformSimplify.transform(pairASTNode.e1);
        if (pairASTNode.e1.isConstant() && pairASTNode.e1.getValue() >= 0L) {
            stringBuilder.append("posmult(");
            this.getChild(0).toDominion(stringBuilder, false);
            stringBuilder.append(",");
            this.getChild(1).toDominion(stringBuilder, false);
            stringBuilder.append(")");
            return;
        }
        stringBuilder.append("mult(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

