/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Table;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class NegativeTable
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public NegativeTable(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new NegativeTable(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(1).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: First argument of negativetable should be 1-dimensional matrix: " + this);
            return false;
        }
        if (this.getChild(1).getDimension() != 2) {
            CmdFlags.println("ERROR: Second argument of negativetable should be 2-dimensional matrix: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ASTNode aSTNode = this.getChild(1);
            if (aSTNode instanceof Identifier) {
                aSTNode = ((Identifier)aSTNode).global_symbols.getConstantMatrix(aSTNode.toString());
            }
            if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
                if (aSTNode instanceof EmptyMatrix) {
                    return new BooleanConstant(true);
                }
                if (this.getChild(0) instanceof EmptyMatrix) {
                    return new BooleanConstant(false);
                }
                ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
                arrayList.remove(0);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isConstant()) continue;
                    long l = arrayList.get(i).getValue();
                    arrayList.remove(i);
                    ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                    for (int j = 1; j < aSTNode.numChildren(); ++j) {
                        if (aSTNode.getChild(j).getChild(i + 1).getValue() != l) continue;
                        ArrayList<ASTNode> arrayList3 = aSTNode.getChild(j).getChildren();
                        arrayList3.remove(0);
                        arrayList3.remove(i);
                        arrayList2.add(CompoundMatrix.makeCompoundMatrix(arrayList3));
                    }
                    NegativeTable negativeTable = new NegativeTable(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
                    return negativeTable;
                }
            }
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new Table(this.getChild(0), this.getChild(1));
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("negativetable(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(1).getChildren();
            stringBuilder.append("{");
            for (int i = 1; i < arrayList.size(); ++i) {
                ArrayList<ASTNode> arrayList2 = arrayList.get(i).getChildren();
                stringBuilder.append("<");
                for (int j = 1; j < arrayList2.size(); ++j) {
                    arrayList2.get(j).toMinion(stringBuilder, false);
                    if (j >= arrayList2.size() - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(">");
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        } else {
            this.getChild(1).toMinion(stringBuilder, false);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("negativetable(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint table_int_reif(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",[");
        ASTNode aSTNode = this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix ? this.getChild(1) : ((Identifier)this.getChild((int)1)).global_symbols.getConstantMatrix(this.getChild(1).toString());
        for (int i = 1; i < aSTNode.numChildren(); ++i) {
            for (int j = 1; j < aSTNode.getChild(i).numChildren(); ++j) {
                aSTNode.getChild(i).getChild(j).toFlatzinc(stringBuilder, false);
                stringBuilder.append(",");
            }
        }
        stringBuilder.append("], false);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(not table(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        if (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix) {
            stringBuilder.append("[");
            for (int i = 1; i < this.getChild(1).numChildren(); ++i) {
                ASTNode aSTNode = this.getChild(1).getChild(i);
                stringBuilder.append("| ");
                for (int j = 1; j < aSTNode.numChildren(); ++j) {
                    aSTNode.getChild(j).toMinizinc(stringBuilder, false);
                    if (j >= aSTNode.numChildren() - 1) continue;
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append("|]");
        } else {
            this.getChild(1).toMinizinc(stringBuilder, false);
        }
        stringBuilder.append("))");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        ASTNode aSTNode = this.getChild(0);
        ASTNode aSTNode2 = this.getChild(1);
        if (aSTNode2 instanceof Identifier) {
            aSTNode2 = ((Identifier)aSTNode2).global_symbols.getConstantMatrix(aSTNode2.toString());
        }
        for (int i = 1; i < aSTNode2.numChildren(); ++i) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.getChild(i).numChildren(); ++j) {
                long l = aSTNode.getChild(j).directEncode(sat, aSTNode2.getChild(i).getChild(j).getValue());
                arrayList.add(-l);
            }
            sat.addClause(arrayList);
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ASTNode aSTNode = this.getChild(0);
        ASTNode aSTNode2 = this.getChild(1);
        if (aSTNode2 instanceof Identifier) {
            aSTNode2 = ((Identifier)aSTNode2).global_symbols.getConstantMatrix(aSTNode2.toString());
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 1; i < aSTNode2.numChildren(); ++i) {
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (int j = 1; j < aSTNode2.getChild(i).numChildren(); ++j) {
                long l2 = aSTNode.getChild(j).directEncode(sat, aSTNode2.getChild(i).getChild(j).getValue());
                arrayList2.add(-l2);
            }
            Long l3 = sat.createAuxSATVariable();
            arrayList.add(l3);
            sat.addClauseReified(arrayList2, -l3.longValue());
        }
        sat.addClauseReified(arrayList, -l);
    }
}

