/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Divide;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.UnaryMinus;
import savilerow.model.Sat;

public class SafeDivide
extends BinOp {
    public static final long serialVersionUID = 1L;

    public SafeDivide(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new SafeDivide(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 0L) {
            return new NumberConstant(0L);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l;
            long l2 = this.getChild(0).getValue();
            if (l2 % (l = this.getChild(1).getValue()) != 0L && l < 0L) {
                System.out.println("WARNING: Result of integer division is not an integer: " + this + ". Using floor(a/b) semantics.");
            }
            return new NumberConstant(this.div(l2, l));
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == 1L) {
            return this.getChild(0);
        }
        if (this.getChild(1).isConstant() && this.getChild(1).getValue() == -1L) {
            return new UnaryMinus(this.getChild(0));
        }
        return this;
    }

    public long div(long l, long l2) {
        try {
            BigInteger[] bigIntegerArray = BigInteger.valueOf(l).divideAndRemainder(BigInteger.valueOf(l2));
            if (bigIntegerArray[1].compareTo(BigInteger.valueOf(0L)) != 0 && (l < 0L && l2 > 0L || l > 0L && l2 < 0L)) {
                bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(-1L));
            }
            return Intpair.BigIntegerToLong(bigIntegerArray[0]);
        }
        catch (ArithmeticException arithmeticException) {
            return 0L;
        }
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        ArrayList<Long> arrayList = new ArrayList<Long>(9);
        arrayList.add(0L);
        if (intpair2.lower != 0L) {
            arrayList.add(this.div(intpair.lower, intpair2.lower));
            arrayList.add(this.div(intpair.upper, intpair2.lower));
        }
        if (intpair2.upper != 0L) {
            arrayList.add(this.div(intpair.lower, intpair2.upper));
            arrayList.add(this.div(intpair.upper, intpair2.upper));
        }
        if (intpair2.lower <= -1L && intpair2.upper >= -1L) {
            arrayList.add(this.div(intpair.lower, -1L));
            arrayList.add(this.div(intpair.upper, -1L));
        }
        if (intpair2.lower <= 1L && intpair2.upper >= 1L) {
            arrayList.add(this.div(intpair.lower, 1L));
            arrayList.add(this.div(intpair.upper, 1L));
        }
        intpair.lower = (Long)Collections.min(arrayList);
        intpair.upper = (Long)Collections.max(arrayList);
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        if (this.getChild(1).isConstant()) {
            if (this.getChild(1).getValue() == 0L) {
                return new PairASTNode(new NumberConstant(0L), new NumberConstant(0L));
            }
            Min min = new Min(new Divide(pairASTNode.e1, this.getChild(1)), new Min(new Divide(pairASTNode.e2, this.getChild(1)), new NumberConstant(0L)));
            Max max = new Max(new Divide(pairASTNode.e1, this.getChild(1)), new Max(new Divide(pairASTNode.e2, this.getChild(1)), new NumberConstant(0L)));
            return new PairASTNode(min, max);
        }
        Min min = new Min(pairASTNode.e1, new Min(new UnaryMinus(pairASTNode.e2), new NumberConstant(0L)));
        Max max = new Max(pairASTNode.e2, new Max(new UnaryMinus(pairASTNode.e1), new NumberConstant(0L)));
        return new PairASTNode(min, max);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("div_undefzero(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("div(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "/" + this.getChild(1) + ")";
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        assert (this.getCategory() <= 2);
        stringBuilder.append("Div(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint int_div(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" div ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        if (l2 == 0L) {
            return l3 == 0L;
        }
        return this.div(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        return this.div(l, l2);
    }
}

