/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.math.BigInteger;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;

public class ShiftMapper
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ShiftMapper(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new ShiftMapper(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public ASTNode simplify() {
        assert (this.getChild(0).getCategory() == 3 || this.getChild(0).getCategory() == 20);
        assert (this.getChild(1).getCategory() <= 2 || this.getChild(1).getCategory() == 20);
        if (this.getChild(1).equals(new NumberConstant(0L))) {
            return this.getChild(0);
        }
        if (this.getChild(0) instanceof ShiftMapper) {
            ASTNode aSTNode = BinOp.makeBinOp("+", this.getChild(1), this.getChild(0).getChild(1));
            return new ShiftMapper(this.getChild(0).getChild(0), aSTNode);
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        intpair.lower = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.lower).add(BigInteger.valueOf(intpair2.lower)));
        intpair.upper = Intpair.BigIntegerToLong(BigInteger.valueOf(intpair.upper).add(BigInteger.valueOf(intpair2.upper)));
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = BinOp.makeBinOp("+", pairASTNode.e1, this.getChild(1));
        pairASTNode.e2 = BinOp.makeBinOp("+", pairASTNode.e2, this.getChild(1));
        return pairASTNode;
    }

    @Override
    public String toString() {
        return "shift(" + this.getChild(0) + ", " + this.getChild(1) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("shift(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

