/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.NegInfinity;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.expression.WeightedSum;
import savilerow.model.SymbolTable;

public class SumVector
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public SumVector(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new SumVector(this.getChild(0));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix in sum function: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            return new WeightedSum(arrayList);
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(new NegInfinity(), new PosInfinity());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String toString() {
        return "sum(" + this.getChild(0) + ")";
    }
}

