/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import java.util.Collections;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.PairASTNode;
import savilerow.expression.SetBinOp;

public class Union
extends SetBinOp {
    public static final long serialVersionUID = 1L;

    public Union(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Union(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).getCategory() == 0 && this.getChild(1).getCategory() == 0) {
            ArrayList<Intpair> arrayList = this.getChild(0).getIntervalSet();
            ArrayList<Intpair> arrayList2 = this.getChild(1).getIntervalSet();
            arrayList.addAll(arrayList2);
            Collections.sort(arrayList);
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                Intpair intpair = arrayList.get(i).merge(arrayList.get(i + 1));
                if (intpair == null) continue;
                arrayList.set(i, intpair);
                arrayList.remove(i + 1);
                --i;
            }
            return Intpair.makeDomain(arrayList, this.isBooleanSet());
        }
        return this;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public boolean isFiniteSet() {
        return this.getChild(0).isFiniteSet() && this.getChild(1).isFiniteSet();
    }

    @Override
    public boolean isFiniteSetUpper() {
        return this.getChild(0).isFiniteSetUpper() && this.getChild(1).isFiniteSetUpper();
    }

    @Override
    public boolean isFiniteSetLower() {
        return this.getChild(0).isFiniteSetLower() && this.getChild(1).isFiniteSetLower();
    }

    @Override
    public boolean isBooleanSet() {
        return this.getChild(0).isBooleanSet() && this.getChild(1).isBooleanSet();
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds().union(this.getChild(1).getBounds());
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        PairASTNode pairASTNode2 = this.getChild(1).getBoundsAST();
        return new PairASTNode(new Min(pairASTNode.e1, pairASTNode2.e1), new Max(pairASTNode.e2, pairASTNode2.e2));
    }

    @Override
    public boolean containsValue(long l) {
        return this.getChild(0).containsValue(l) || this.getChild(1).containsValue(l);
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " union " + this.getChild(1) + ")";
    }
}

