/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Concatenate;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Find;
import savilerow.expression.Flatten;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Maximising;
import savilerow.expression.Minimising;
import savilerow.expression.Top;
import savilerow.model.FilteredDomainStore;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TransformSimplifyExtended;
import savilerow.treetransformer.TreeTransformer;

public class Model {
    public ASTNode constraints;
    public SymbolTable global_symbols;
    public FilteredDomainStore filt;
    public ASTNode objective;
    public ASTNode branchingon;
    public String heuristic;
    public Sat satModel;
    public ASTNode incumbentSolution;

    public Model(ASTNode aSTNode, SymbolTable symbolTable, ASTNode aSTNode2, ASTNode aSTNode3, String string) {
        assert (aSTNode != null);
        assert (symbolTable != null);
        this.constraints = aSTNode;
        this.global_symbols = symbolTable;
        this.objective = aSTNode2;
        this.branchingon = aSTNode3;
        this.heuristic = string;
        symbolTable.setModel(this);
        if (this.branchingon == null) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(this.global_symbols.lettings_givens);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Find)) continue;
                if (arrayList.get(i).getChild(1) instanceof MatrixDomain) {
                    arrayList2.add(new Flatten(arrayList.get(i).getChild(0)));
                    continue;
                }
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                arrayList3.add(arrayList.get(i).getChild(0));
                arrayList2.add(new CompoundMatrix(arrayList3));
            }
            this.branchingon = new Concatenate(arrayList2);
        }
        this.filt = new FilteredDomainStore(this.global_symbols);
    }

    public Model(ASTNode aSTNode, SymbolTable symbolTable, FilteredDomainStore filteredDomainStore, ASTNode aSTNode2, ASTNode aSTNode3, String string) {
        assert (aSTNode != null);
        assert (symbolTable != null);
        this.constraints = aSTNode;
        this.global_symbols = symbolTable;
        this.objective = aSTNode2;
        this.branchingon = aSTNode3;
        this.heuristic = string;
        symbolTable.setModel(this);
        if (this.branchingon == null) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(this.global_symbols.lettings_givens);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Find)) continue;
                if (arrayList.get(i).getChild(1) instanceof MatrixDomain) {
                    arrayList2.add(new Flatten(arrayList.get(i).getChild(0)));
                    continue;
                }
                ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
                arrayList3.add(arrayList.get(i).getChild(0));
                arrayList2.add(new CompoundMatrix(arrayList3));
            }
            this.branchingon = new Concatenate(arrayList2);
        }
        this.filt = filteredDomainStore;
    }

    public void simplify() {
        TransformSimplify transformSimplify = new TransformSimplify();
        TransformSimplifyExtended transformSimplifyExtended = new TransformSimplifyExtended(this);
        this.global_symbols.simplify();
        if (this.objective != null) {
            this.objective = transformSimplify.transform(this.objective);
            if (this.objective.getChild(0).isConstant()) {
                CmdFlags.println("Dropping objective: " + this.objective);
                this.objective = null;
            }
        }
        if (this.branchingon != null) {
            this.branchingon = transformSimplify.transform(this.branchingon);
        }
        this.constraints = transformSimplifyExtended.transform(this.constraints);
        this.filt.simplify();
    }

    public void substitute(ASTNode aSTNode, ASTNode aSTNode2) {
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode, aSTNode2);
        this.constraints = replaceASTNode.transform(this.constraints);
        if (this.objective != null) {
            this.objective = replaceASTNode.transform(this.objective);
        }
        if (this.branchingon != null) {
            this.branchingon = replaceASTNode.transform(this.branchingon);
        }
        this.global_symbols.substitute(aSTNode, aSTNode2);
    }

    public void substituteExceptTable(ASTNode aSTNode, ASTNode aSTNode2) {
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode, aSTNode2);
        if (this.objective != null) {
            this.objective = replaceASTNode.transform(this.objective);
        }
        if (this.branchingon != null) {
            this.branchingon = replaceASTNode.transform(this.branchingon);
        }
        this.global_symbols.substitute(aSTNode, aSTNode2);
    }

    public boolean typecheck() {
        if (this.branchingon != null && this.branchingon.getDimension() != 1) {
            CmdFlags.println("ERROR: 'branching on' statement may only contain 1-dimensional matrices of decision variables.");
            return false;
        }
        if (this.objective != null) {
            if (!this.objective.typecheck(this.global_symbols)) {
                return false;
            }
            if (!(this.objective instanceof Maximising) && !(this.objective instanceof Minimising)) {
                CmdFlags.println("ERROR: Objective: " + this.objective);
                CmdFlags.println("ERROR: should be either minimising or maximising.");
                return false;
            }
            if (!this.objective.getChild(0).isNumerical() && !this.objective.getChild(0).isRelation()) {
                CmdFlags.println("ERROR: Objective must be numerical or relational.");
                return false;
            }
        }
        if (!this.constraints.typecheck(this.global_symbols)) {
            return false;
        }
        return this.global_symbols.typecheck();
    }

    public boolean transform(TreeTransformer treeTransformer) {
        if (CmdFlags.getVerbose()) {
            System.out.println("Rule:" + treeTransformer.getClass().getName());
        }
        boolean bl = false;
        assert (this.constraints instanceof Top);
        this.constraints = treeTransformer.transform(this.constraints);
        if (treeTransformer.changedTree) {
            bl = true;
        }
        if (this.objective != null) {
            this.objective = treeTransformer.transform(this.objective);
            if (treeTransformer.changedTree) {
                bl = true;
            }
        }
        if (treeTransformer.getContextCts() != null) {
            this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
            bl = true;
        }
        assert (this.branchingon != null);
        this.branchingon = treeTransformer.transform(this.branchingon);
        if (treeTransformer.changedTree) {
            bl = true;
        }
        if (treeTransformer.getContextCts() != null) {
            this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
            bl = true;
        }
        if (CmdFlags.getVerbose() && bl) {
            System.out.println("Model has changed. Model after rule application:\n" + this.toString());
        }
        if (bl) {
            this.simplify();
            if (CmdFlags.getVerbose()) {
                System.out.println("Model after rule application and simplify:\n" + this.toString());
            }
        }
        assert (this.constraints instanceof Top);
        return bl;
    }

    public void transform_all(TreeTransformer treeTransformer) {
        if (CmdFlags.getVerbose()) {
            System.out.println("Rule:" + treeTransformer.getClass().getName());
        }
        assert (this.constraints instanceof Top);
        this.constraints = treeTransformer.transform(this.constraints);
        if (this.objective != null) {
            this.objective = treeTransformer.transform(this.objective);
        }
        if (this.branchingon != null) {
            this.branchingon = treeTransformer.transform(this.branchingon);
        }
        this.global_symbols.transform_all(treeTransformer);
        if (treeTransformer.getContextCts() != null) {
            this.constraints = new Top(new And(this.constraints.getChild(0), treeTransformer.getContextCts()));
        }
        if (CmdFlags.getVerbose()) {
            System.out.println("Model after rule application:\n" + this.toString());
        }
        this.simplify();
        if (CmdFlags.getVerbose()) {
            System.out.println("Model after rule application and simplify:\n" + this.toString());
        }
        assert (this.constraints instanceof Top);
    }

    public int hashCode() {
        return this.constraints.hashCode();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Model model = (Model)object;
        if (!model.constraints.equals(this.constraints)) {
            return false;
        }
        if (!model.global_symbols.equals(this.global_symbols)) {
            return false;
        }
        if (!(this.objective != null ? this.objective.equals(model.objective) : model.objective == null)) {
            return false;
        }
        if (!(this.branchingon != null ? this.branchingon.equals(model.branchingon) : model.branchingon == null)) {
            return false;
        }
        if (!(this.heuristic != null ? this.heuristic.equals(model.heuristic) : model.heuristic == null)) {
            return false;
        }
        if (!model.filt.equals(this.filt)) {
            return false;
        }
        return this.incumbentSolution != null ? this.incumbentSolution.equals(model.incumbentSolution) : model.incumbentSolution == null;
    }

    public Model copy() {
        SymbolTable symbolTable = this.global_symbols.copy();
        FilteredDomainStore filteredDomainStore = this.filt.copy(symbolTable);
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(symbolTable);
        ASTNode aSTNode = transformFixSTRef.transform(this.constraints.copy());
        ASTNode aSTNode2 = null;
        if (this.objective != null) {
            aSTNode2 = transformFixSTRef.transform(this.objective.copy());
        }
        ASTNode aSTNode3 = null;
        if (this.branchingon != null) {
            aSTNode3 = transformFixSTRef.transform(this.branchingon.copy());
        }
        Model model = new Model(aSTNode, symbolTable, filteredDomainStore, aSTNode2, aSTNode3, this.heuristic);
        if (this.incumbentSolution != null) {
            model.incumbentSolution = transformFixSTRef.transform(this.incumbentSolution.copy());
        }
        return model;
    }

    public void toMinion(StringBuilder stringBuilder) {
        this.toMinion(stringBuilder, null);
    }

    public void toMinion(StringBuilder stringBuilder, ArrayList<ASTNode> arrayList) {
        stringBuilder.append("MINION 3\n");
        for (String string : CmdFlags.stats.keySet()) {
            stringBuilder.append("# " + string + " = " + CmdFlags.stats.get(string) + "\n");
        }
        stringBuilder.append("**VARIABLES**\n");
        this.global_symbols.toMinion(stringBuilder);
        stringBuilder.append("**SEARCH**\n");
        if (arrayList == null) {
            this.global_symbols.printPrintStmt(stringBuilder);
        } else {
            stringBuilder.append("PRINT [");
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append("[");
                stringBuilder.append(arrayList.get(i));
                stringBuilder.append("]");
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]\n");
        }
        if (this.objective != null) {
            this.objective.toMinion(stringBuilder, false);
        }
        if (arrayList != null) {
            stringBuilder.append("VARORDER [");
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append(arrayList.get(i));
                if (i >= arrayList.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]\n");
        } else if (this.branchingon != null) {
            stringBuilder.append("VARORDER ");
            if (this.heuristic != null) {
                stringBuilder.append(this.heuristic);
            } else {
                stringBuilder.append("STATIC");
            }
            stringBuilder.append(" ");
            this.branchingon.toMinion(stringBuilder, false);
            stringBuilder.append("\n");
            stringBuilder.append("VARORDER AUX [");
            this.global_symbols.printAllVariables(stringBuilder, 3);
            StringBuilder stringBuilder2 = new StringBuilder();
            this.global_symbols.printAllVariables(stringBuilder2, 10);
            if (stringBuilder2.length() > 0) {
                stringBuilder.append(",");
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            stringBuilder.append("]\n");
        } else {
            if (this.heuristic != null) {
                stringBuilder.append("VARORDER " + this.heuristic + " [");
            } else {
                stringBuilder.append("VARORDER STATIC [");
            }
            this.global_symbols.printAllVariables(stringBuilder, 3);
            stringBuilder.append("]\n");
            stringBuilder.append("VARORDER AUX [");
            this.global_symbols.printAllVariables(stringBuilder, 10);
            stringBuilder.append("]\n");
        }
        stringBuilder.append("**CONSTRAINTS**\n");
        this.constraints.toMinion(stringBuilder, true);
        stringBuilder.append("**EOF**\n");
    }

    public void toDominion(StringBuilder stringBuilder) {
        stringBuilder.append("language Dominion 0.0\n");
        this.global_symbols.toDominion(stringBuilder);
        if (this.objective != null) {
            this.objective.toDominion(stringBuilder, false);
        }
        stringBuilder.append("such that\n");
        this.constraints.toDominion(stringBuilder, true);
        stringBuilder.append("\n");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("language ESSENCE' 1.0\n");
        stringBuilder.append(this.global_symbols.toString());
        if (this.objective != null) {
            stringBuilder.append(this.objective.toString());
        }
        stringBuilder.append("such that\n");
        stringBuilder.append(this.constraints.toString());
        return stringBuilder.toString();
    }

    public void toFlatzinc(StringBuilder stringBuilder) {
        stringBuilder.append("predicate all_different_int(array [int] of var int: xs);\n");
        this.global_symbols.toFlatzinc(stringBuilder);
        this.constraints.toFlatzinc(stringBuilder, true);
        stringBuilder.append("solve :: int_search(");
        if (this.branchingon instanceof EmptyMatrix) {
            stringBuilder.append("[1]");
        } else {
            this.branchingon.toFlatzinc(stringBuilder, false);
        }
        stringBuilder.append(", input_order, indomain_min, complete)\n");
        if (this.objective != null) {
            this.objective.toFlatzinc(stringBuilder, false);
        } else {
            stringBuilder.append(" satisfy;\n");
        }
    }

    public void toMinizinc(StringBuilder stringBuilder) {
        stringBuilder.append("% Minizinc model produced by Savile Row from Essence' file " + CmdFlags.eprimefile);
        if (CmdFlags.paramfile != null) {
            stringBuilder.append(" and parameter file " + CmdFlags.paramfile);
        }
        stringBuilder.append("\n");
        stringBuilder.append("include \"globals.mzn\";\n");
        this.global_symbols.toMinizinc(stringBuilder);
        this.constraints.toMinizinc(stringBuilder, true);
        stringBuilder.append("solve :: int_search([");
        this.global_symbols.printAllVariablesFlatzinc(stringBuilder, 3);
        stringBuilder.append("], input_order, indomain_min, complete)\n");
        if (this.objective != null) {
            this.objective.toMinizinc(stringBuilder, false);
        } else {
            stringBuilder.append(" satisfy;\n");
        }
        stringBuilder.append("output\n [");
        this.global_symbols.showVariablesMinizinc(stringBuilder);
        if (this.objective != null) {
            stringBuilder.append(",show(" + this.objective.getChild(0).toString() + ")");
        }
        stringBuilder.append("];\n");
    }

    public boolean setupSAT() {
        try {
            this.satModel = new Sat(this.global_symbols, CmdFlags.satfile);
            this.satModel.generateVariableEncoding();
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }

    public boolean toSAT() {
        try {
            this.constraints.toSAT(this.satModel);
            this.satModel.finaliseOutput();
            return true;
        }
        catch (IOException iOException) {
            File file = new File(CmdFlags.satfile);
            if (file.exists()) {
                file.delete();
            }
            return false;
        }
    }
}

