/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.SATLiteral;
import savilerow.model.NumberMap;
import savilerow.model.SymbolTable;
import savilerow.model.categoryentry;

public class Sat {
    private long variableNumber = 1L;
    private long numClauses = 0L;
    private TLongObjectHashMap<NumberMap> dimacsMapping = new TLongObjectHashMap();
    public TLongObjectHashMap<NumberMap> orderMappingMin;
    public TLongObjectHashMap<NumberMap> orderMappingMid;
    public TLongObjectHashMap<NumberMap> orderMappingMax;
    private TObjectLongHashMap<NumberMap> directVarMapping = new TObjectLongHashMap();
    private TObjectLongHashMap<NumberMap> orderVarMapping = new TObjectLongHashMap();
    private SymbolTable global_symbols;
    private String satFileName;
    private FileOutputStream fw;
    private BufferedWriter outstream;
    private long trueVar;

    public Sat(SymbolTable symbolTable, String string) {
        this.orderMappingMin = new TLongObjectHashMap();
        this.orderMappingMid = new TLongObjectHashMap();
        this.orderMappingMax = new TLongObjectHashMap();
        this.global_symbols = symbolTable;
        this.satFileName = string;
        assert (this.directVarMapping.getNoEntryValue() == 0L);
        assert (this.orderVarMapping.getNoEntryValue() == 0L);
        try {
            this.fw = new FileOutputStream(this.satFileName);
            this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
            for (int i = 0; i < 10; ++i) {
                this.outstream.write("          ");
            }
            this.outstream.newLine();
            this.trueVar = this.getNextVariableNumber();
            this.addClause(String.valueOf(this.trueVar));
        }
        catch (IOException iOException) {
            CmdFlags.errorExit("Failed to open or write to SAT output file.");
        }
    }

    private long getNextVariableNumber() {
        return this.variableNumber++;
    }

    public NumberMap getDimacsMapping(long l) {
        return this.dimacsMapping.get(l);
    }

    private long createSatVariableDirect(String string, long l) {
        NumberMap numberMap = new NumberMap(l, string);
        long l2 = this.getNextVariableNumber();
        this.directVarMapping.put(numberMap, l2);
        this.dimacsMapping.put(l2, numberMap);
        return l2;
    }

    private long createSatVariableOrder(String string, long l) {
        NumberMap numberMap = new NumberMap(l, string);
        long l2 = this.getNextVariableNumber();
        this.orderVarMapping.put(numberMap, l2);
        return l2;
    }

    public long getOrderVariable(String string, long l) {
        long l2 = this.orderVarMapping.get(new NumberMap(l, string));
        if (l2 == this.orderVarMapping.getNoEntryValue()) {
            Intpair intpair = this.global_symbols.getDomain(string).getBounds();
            if (l < intpair.lower) {
                return -this.trueVar;
            }
            if (l >= intpair.upper) {
                return this.trueVar;
            }
            ArrayList<Intpair> arrayList = this.global_symbols.getDomain(string).getIntervalSet();
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                Intpair intpair2 = arrayList.get(i);
                Intpair intpair3 = arrayList.get(i + 1);
                if (l <= intpair2.upper || l >= intpair3.lower) continue;
                long l3 = this.orderVarMapping.get(new NumberMap(intpair2.upper, string));
                assert (l3 != this.orderVarMapping.getNoEntryValue());
                return l3;
            }
            assert (false);
            return 1L;
        }
        return l2;
    }

    public long getDirectVariable(String string, long l) {
        long l2 = this.directVarMapping.get(new NumberMap(l, string));
        if (l2 == this.directVarMapping.getNoEntryValue()) {
            return -this.trueVar;
        }
        return l2;
    }

    public long getTrue() {
        return this.trueVar;
    }

    public long createAuxSATVariable() {
        return this.getNextVariableNumber();
    }

    public ASTNode createAuxSATVariableAST() {
        long l = this.createAuxSATVariable();
        return new SATLiteral(l, this);
    }

    public void generateVariableEncoding() throws IOException {
        categoryentry categoryentry2 = this.global_symbols.getCategoryFirst();
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                String string = this.global_symbols.represents_ct.get(categoryentry2.name);
                if (string == null) {
                    string = "";
                }
                this.addComment("Encoding variable: " + categoryentry2.name + " with domain: " + this.global_symbols.getDomain(categoryentry2.name) + " (representing constraint " + string + ")");
                ASTNode aSTNode = this.global_symbols.getDomain(categoryentry2.name);
                ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
                long l = 0L;
                for (int i = 0; i < arrayList.size(); ++i) {
                    l = l + arrayList.get((int)i).upper - arrayList.get((int)i).lower + 1L;
                }
                if (l <= 0L) {
                    this.addClause(-this.getTrue());
                } else if (l == 1L) {
                    this.generateVariableEncoding1Val(categoryentry2.name);
                } else if (l == 2L) {
                    this.generateVariableEncoding2Vals(categoryentry2.name);
                } else if (this.global_symbols.isDirectSAT(categoryentry2.name)) {
                    this.generateVariableEncodingInteger(categoryentry2.name);
                } else {
                    this.generateVariableEncodingIntegerNoDirect(categoryentry2.name);
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public void generateVariableEncoding1Val(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        Intpair intpair = aSTNode.getBounds();
        assert (intpair.upper == intpair.lower);
        long l = intpair.lower;
        long l2 = this.getNextVariableNumber();
        this.addComment("Var represented with SAT variable " + l2);
        NumberMap numberMap = new NumberMap(l, string);
        this.directVarMapping.put(numberMap, this.getTrue());
        this.addClause(l2);
        this.dimacsMapping.put(l2, numberMap);
    }

    public void generateVariableEncoding2Vals(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        Intpair intpair = aSTNode.getBounds();
        long l = intpair.lower;
        long l2 = intpair.upper;
        long l3 = this.getNextVariableNumber();
        this.addComment("Var represented with SAT variable " + l3);
        NumberMap numberMap = new NumberMap(l, string);
        NumberMap numberMap2 = new NumberMap(l2, string);
        this.directVarMapping.put(numberMap2, l3);
        this.directVarMapping.put(numberMap, -l3);
        this.orderVarMapping.put(numberMap2, this.trueVar);
        this.orderVarMapping.put(numberMap, -l3);
        this.dimacsMapping.put(l3, numberMap2);
        this.dimacsMapping.put(-l3, numberMap);
    }

    public void generateVariableEncodingInteger(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        long l = -this.trueVar;
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                long l2;
                boolean bl;
                boolean bl2 = bl = j == intpair.upper && i == arrayList.size() - 1;
                if (bl) {
                    l2 = -l;
                    NumberMap numberMap = new NumberMap(j, string);
                    this.directVarMapping.put(numberMap, l2);
                    this.dimacsMapping.put(l2, numberMap);
                } else {
                    l2 = this.createSatVariableDirect(string, j);
                }
                long l3 = this.trueVar;
                if (!bl) {
                    l3 = this.createSatVariableOrder(string, j);
                    if (l != -this.trueVar) {
                        this.addClause(-l + " " + l3);
                    }
                }
                if (!bl) {
                    if (l != -this.trueVar) {
                        this.addClause(l + " " + -l3 + " " + l2);
                    } else {
                        this.addClause(-l3 + " " + l2);
                    }
                    this.addClause(-l2 + " " + l3);
                    if (l != -this.trueVar) {
                        this.addClause(-l2 + " " + -l);
                    }
                }
                l = l3;
            }
        }
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                arrayList2.add(this.getDirectVariable(string, j));
            }
        }
        this.addClause(arrayList2);
    }

    public void generateVariableEncodingIntegerNoDirect(String string) throws IOException {
        ASTNode aSTNode = this.global_symbols.getDomain(string);
        ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
        long l = -this.trueVar;
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            for (long j = intpair.lower; j <= intpair.upper; ++j) {
                boolean bl = j == intpair.upper && i == arrayList.size() - 1;
                NumberMap numberMap = new NumberMap(j, string);
                if (!bl) {
                    long l2 = this.createSatVariableOrder(string, j);
                    if (l != -this.trueVar) {
                        this.addClause(-l + " " + l2);
                        this.orderMappingMid.put(l2, numberMap);
                    } else {
                        this.orderMappingMin.put(l2, numberMap);
                    }
                    l = l2;
                    continue;
                }
                this.orderMappingMax.put(-l, numberMap);
            }
        }
    }

    public void addClause(String string) throws IOException {
        this.outstream.write(string);
        this.outstream.write(" 0");
        this.outstream.newLine();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClause(long l) throws IOException {
        this.outstream.write(String.valueOf(l));
        this.outstream.write(" 0");
        this.outstream.newLine();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClause(ArrayList<Long> arrayList) throws IOException {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.outstream.write(String.valueOf(arrayList.get(i)));
            this.outstream.write(" ");
        }
        this.outstream.write("0");
        this.outstream.newLine();
        ++this.numClauses;
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addClauseReified(ArrayList<Long> arrayList, long l) throws IOException {
        int n;
        this.outstream.write(String.valueOf(-l));
        this.outstream.write(" ");
        for (n = 0; n < arrayList.size(); ++n) {
            this.outstream.write(String.valueOf(arrayList.get(n)));
            this.outstream.write(" ");
        }
        this.outstream.write("0");
        this.outstream.newLine();
        ++this.numClauses;
        for (n = 0; n < arrayList.size(); ++n) {
            this.outstream.write(String.valueOf(-arrayList.get(n).longValue()));
            this.outstream.write(" ");
            this.outstream.write(String.valueOf(l));
            this.outstream.write(" 0");
            this.outstream.newLine();
            ++this.numClauses;
        }
        if (CmdFlags.getCNFLimit() != 0L && this.numClauses > CmdFlags.getCNFLimit()) {
            CmdFlags.println("ERROR: Reached CNF clause limit.");
            throw new IOException();
        }
    }

    public void addComment(String string) throws IOException {
        this.outstream.write("c ");
        this.outstream.write(string);
        this.outstream.newLine();
    }

    public void finaliseOutput() throws IOException {
        this.outstream.flush();
        this.fw.getFD().sync();
        this.outstream.close();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.satFileName, "rws");
        randomAccessFile.seek(0L);
        byte[] byArray = ("p cnf " + (this.variableNumber - 1L) + " " + this.numClauses).getBytes();
        randomAccessFile.write(byArray);
        randomAccessFile.close();
    }

    public void addClauseAfterFinalise(String string) throws IOException {
        this.fw = new FileOutputStream(this.satFileName, true);
        this.outstream = new BufferedWriter(new OutputStreamWriter(this.fw));
        this.addClause(string);
        this.finaliseOutput();
    }

    public static ArrayList<Intpair> getIntervalSetSAT(ASTNode aSTNode) {
        if (aSTNode.isConstant()) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            arrayList.add(new Intpair(aSTNode.getValue(), aSTNode.getValue()));
            return arrayList;
        }
        if (aSTNode instanceof Identifier) {
            Identifier identifier = (Identifier)aSTNode;
            return identifier.global_symbols.getDomain(identifier.getName()).getIntervalSet();
        }
        if (aSTNode instanceof SATLiteral) {
            ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
            arrayList.add(new Intpair(0L, 1L));
            return arrayList;
        }
        return null;
    }

    public void unaryDirectEncoding(ASTNode aSTNode, ASTNode aSTNode2) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (aSTNode.test(i)) continue;
                this.addClause(String.valueOf(-aSTNode2.directEncode(this, i)));
            }
        }
    }

    public void unaryDirectEncodingWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, long l) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                if (!aSTNode.test(i)) {
                    this.addClause(-l + " " + -aSTNode2.directEncode(this, i));
                    continue;
                }
                this.addClause(l + " " + -aSTNode2.directEncode(this, i));
            }
        }
    }

    public void directEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (aSTNode.test(i, j)) continue;
                        String string = -aSTNode2.directEncode(this, i) + " " + -aSTNode3.directEncode(this, j);
                        this.addClause(string);
                    }
                }
            }
        }
    }

    public void directEncodingWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        String string;
                        if (!aSTNode.test(i, j)) {
                            string = -l + " " + -aSTNode2.directEncode(this, i) + " " + -aSTNode3.directEncode(this, j);
                            this.addClause(string);
                            continue;
                        }
                        string = l + " " + -aSTNode2.directEncode(this, i) + " " + -aSTNode3.directEncode(this, j);
                        this.addClause(string);
                    }
                }
            }
        }
    }

    public void ternaryEncoding(ASTNode aSTNode, ASTNode aSTNode2) throws IOException {
        if (aSTNode2 instanceof NumberConstant) {
            this.supportEncodingBinary(aSTNode, aSTNode.getChild(0), aSTNode.getChild(1), aSTNode2.getValue());
        } else {
            this.ternaryFunctionalEncoding(aSTNode, aSTNode.getChild(0), aSTNode.getChild(1), aSTNode2);
        }
    }

    public void ternaryDirectEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        ArrayList<Intpair> arrayList3 = Sat.getIntervalSetSAT(aSTNode4);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        for (Intpair intpair3 : arrayList3) {
                            for (long k = intpair3.lower; k <= intpair3.upper; ++k) {
                                if (aSTNode.test(i, j, k)) continue;
                                this.addClause(-aSTNode2.directEncode(this, i) + " " + -aSTNode3.directEncode(this, j) + " " + -aSTNode4.directEncode(this, k));
                            }
                        }
                    }
                }
            }
        }
    }

    public void ternaryFunctionalEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, ASTNode aSTNode4) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        long l = aSTNode.func(i, j);
                        this.addClause(-aSTNode2.directEncode(this, i) + " " + -aSTNode3.directEncode(this, j) + " " + aSTNode4.directEncode(this, l));
                    }
                }
            }
        }
    }

    public void supportEncodingBinary(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) throws IOException {
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode2, aSTNode3, false, false, 0L);
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode3, aSTNode2, true, false, 0L);
    }

    public void supportEncodingBinary(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode2, aSTNode3, false, true, l);
        this.supportEncodingBinaryGenerateClauses(aSTNode, aSTNode3, aSTNode2, true, true, l);
    }

    private void supportEncodingBinaryGenerateClauses(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, boolean bl, boolean bl2, long l) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                String string = -aSTNode2.directEncode(this, i) + " ";
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (!(!bl2 && (!bl && aSTNode.test(i, j) || bl && aSTNode.test(j, i))) && (!bl2 || (bl || !aSTNode.test(i, j, l)) && (!bl || !aSTNode.test(j, i, l)))) continue;
                        string = string + aSTNode3.directEncode(this, j) + " ";
                    }
                }
                this.addClause(string);
            }
        }
    }

    public void supportEncodingBinaryWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        if (aSTNode2.getCategory() == 0 || aSTNode3.getCategory() == 0) {
            this.directEncodingWithAuxVar(aSTNode, aSTNode2, aSTNode3, l);
        } else {
            this.supportEncodingBinaryGenerateClausesWithAuxVar(aSTNode, aSTNode2, aSTNode3, l, false);
            this.supportEncodingBinaryGenerateClausesWithAuxVar(aSTNode, aSTNode3, aSTNode2, l, true);
        }
    }

    private void supportEncodingBinaryGenerateClausesWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l, boolean bl) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            for (long i = intpair.lower; i <= intpair.upper; ++i) {
                ArrayList<Long> arrayList3 = new ArrayList<Long>();
                arrayList3.add(l);
                arrayList3.add(-aSTNode2.directEncode(this, i));
                ArrayList<Long> arrayList4 = new ArrayList<Long>();
                arrayList4.add(-l);
                arrayList4.add(-aSTNode2.directEncode(this, i));
                for (Intpair intpair2 : arrayList2) {
                    for (long j = intpair2.lower; j <= intpair2.upper; ++j) {
                        if (!bl && aSTNode.test(i, j) || bl && aSTNode.test(j, i)) {
                            arrayList4.add(aSTNode3.directEncode(this, j));
                            continue;
                        }
                        arrayList3.add(aSTNode3.directEncode(this, j));
                    }
                }
                this.addClause(arrayList3);
                this.addClause(arrayList4);
            }
        }
    }

    public void orderEncoding(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            block1: for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (int j = arrayList2.size() - 1; j >= 0; --j) {
                    Intpair intpair2 = arrayList2.get(j);
                    for (long k = intpair2.upper; k >= intpair2.lower; --k) {
                        if (aSTNode.test(i, k)) continue;
                        String string = "";
                        string = string + aSTNode2.orderEncode(this, i - 1L) + " " + -aSTNode3.orderEncode(this, k);
                        this.addClause(string);
                        continue block1;
                    }
                }
            }
        }
    }

    public void orderEncodingWithAuxVar(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3, long l) throws IOException {
        ArrayList<Intpair> arrayList = Sat.getIntervalSetSAT(aSTNode2);
        ArrayList<Intpair> arrayList2 = Sat.getIntervalSetSAT(aSTNode3);
        for (Intpair intpair : arrayList) {
            block1: for (long i = intpair.lower; i <= intpair.upper; ++i) {
                for (int j = arrayList2.size() - 1; j >= 0; --j) {
                    Intpair intpair2 = arrayList2.get(j);
                    for (long k = intpair2.upper; k >= intpair2.lower; --k) {
                        if (aSTNode.test(i, k)) continue;
                        String string = "";
                        String string2 = "";
                        string = string + -l + " " + aSTNode2.orderEncode(this, i - 1L) + " " + -aSTNode3.orderEncode(this, k);
                        string2 = string2 + l + " " + -aSTNode2.orderEncode(this, i - 1L) + " " + aSTNode3.orderEncode(this, k);
                        this.addClause(string2);
                        this.addClause(string);
                        continue block1;
                    }
                }
            }
        }
    }

    public long getNumVars() {
        return this.variableNumber - 1L;
    }

    public long getNumClauses() {
        return this.numClauses;
    }
}

