/*
 * Decompiled with CFR 0.152.
 */
package savilerow.treetransformer;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Find;
import savilerow.expression.ForallExpression;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixSlice;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.expression.SafeMatrixDeref;
import savilerow.model.Model;
import savilerow.treetransformer.NodeReplacement;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class TransformHoleyMatrixToAtoms
extends TreeTransformerBottomUpNoWrapper {
    String matname;
    ASTNode matid;
    ASTNode matrixvars;
    int dimensions;

    public TransformHoleyMatrixToAtoms(String string, Model model) {
        super(model);
        this.matname = string;
        this.matid = new Identifier(this.matname, this.m.global_symbols);
        ASTNode aSTNode = this.m.global_symbols.getDomain(this.matname);
        this.dimensions = aSTNode.getChild(0).numChildren() - 3;
        this.matrixvars = this.populate_matrixvars(aSTNode.getChild(1), new ArrayList<ASTNode>());
        this.m.global_symbols.deleteMatrix(this.matname);
    }

    protected ASTNode populate_matrixvars(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        ArrayList<Object> arrayList2;
        if (aSTNode instanceof Find) {
            String string = this.matname;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = String.format("%05d", arrayList.get(i).getValue());
                string2 = string2.replaceAll("-", "n");
                string = string + "_" + string2;
            }
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3.add(arrayList.get(i).getValue());
            }
            this.m.global_symbols.newVariable(string, aSTNode.getChild(1).copy(), 3, this.matid, arrayList3);
            return new Identifier(string, this.m.global_symbols);
        }
        ASTNode aSTNode2 = aSTNode.getChild(0).getChild(0);
        ArrayList<Long> arrayList4 = aSTNode.getChild(1).getChild(0).getValueSet();
        ArrayList<ASTNode> arrayList5 = new ArrayList<ASTNode>();
        ASTNode aSTNode3 = aSTNode.getChild(2).copy();
        ASTNode aSTNode4 = aSTNode.numChildren() > 3 ? aSTNode.getChild(3) : new BooleanConstant(true);
        if (aSTNode.getChild(0).numChildren() > 1) {
            arrayList2 = aSTNode.getChild(0).getChildren();
            arrayList2.remove(0);
            ArrayList<ASTNode> arrayList6 = aSTNode.getChild(1).getChildren();
            arrayList6.remove(0);
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                aSTNode3 = new ForallExpression((ASTNode)arrayList2.get(i), arrayList6.get(i), aSTNode3, aSTNode4);
                aSTNode4 = new BooleanConstant(true);
            }
            aSTNode4 = new BooleanConstant(true);
        }
        arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList4.size(); ++i) {
            long l = arrayList4.get(i);
            ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode2, new NumberConstant(l));
            ASTNode aSTNode5 = replaceASTNode.transform(aSTNode3.copy());
            TransformSimplify transformSimplify = new TransformSimplify();
            aSTNode5 = transformSimplify.transform(aSTNode5);
            ASTNode aSTNode6 = replaceASTNode.transform(aSTNode4.copy());
            aSTNode6 = transformSimplify.transform(aSTNode6);
            assert (aSTNode6 instanceof BooleanConstant);
            if (!aSTNode6.equals(new BooleanConstant(true))) continue;
            arrayList5.add(new NumberConstant(l));
            ArrayList<ASTNode> arrayList7 = new ArrayList<ASTNode>(arrayList);
            arrayList7.add(new NumberConstant(l));
            arrayList2.add(this.populate_matrixvars(aSTNode5, arrayList7));
        }
        return CompoundMatrix.makeCompoundMatrix(new IntegerDomain(arrayList5), arrayList2, false);
    }

    @Override
    protected NodeReplacement processNode(ASTNode aSTNode) {
        if ((aSTNode instanceof MatrixDeref || aSTNode instanceof SafeMatrixDeref) && aSTNode.getChild(0).equals(this.matid)) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            arrayList.remove(0);
            ASTNode aSTNode2 = this.matrixvars;
            for (int i = 0; i < arrayList.size(); ++i) {
                long l;
                assert (aSTNode2 instanceof CompoundMatrix);
                ArrayList<Long> arrayList2 = aSTNode2.getChild(0).getValueSet();
                if (arrayList2.indexOf(l = arrayList.get(i).getValue()) == -1) {
                    if (aSTNode instanceof MatrixDeref) {
                        CmdFlags.println("WARNING: When constructing holey matrix, found matrix dereference: " + aSTNode);
                        CmdFlags.println("WARNING: that is outside the matrix. ");
                    }
                    return new NodeReplacement(new NumberConstant(0L));
                }
                aSTNode2 = aSTNode2.getChild(1).getChild(arrayList2.indexOf(l));
            }
            assert (aSTNode2 instanceof Identifier);
            return new NodeReplacement(aSTNode2);
        }
        if (aSTNode instanceof MatrixSlice && aSTNode.getChild(0).equals(this.matid)) {
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            arrayList.remove(0);
            ASTNode aSTNode3 = this.collectSlice(this.matrixvars, arrayList, 0);
            return new NodeReplacement(aSTNode3);
        }
        if (aSTNode instanceof Identifier && aSTNode.equals(this.matid) && !(aSTNode.getParent() instanceof MatrixDeref) && !(aSTNode.getParent() instanceof SafeMatrixDeref) && !(aSTNode.getParent() instanceof MatrixSlice)) {
            ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
            for (int i = 0; i < this.dimensions; ++i) {
                arrayList.add(new IntegerDomain(new Range(null, null)));
            }
            ASTNode aSTNode4 = this.collectSlice(this.matrixvars, arrayList, 0);
            return new NodeReplacement(aSTNode4);
        }
        return null;
    }

    ASTNode collectSlice(ASTNode aSTNode, ArrayList<ASTNode> arrayList, int n) {
        if (n == arrayList.size()) {
            assert (aSTNode instanceof Identifier);
            return aSTNode;
        }
        assert (aSTNode instanceof CompoundMatrix);
        ASTNode aSTNode2 = arrayList.get(n);
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        ArrayList<Long> arrayList3 = aSTNode.getChild(0).getValueSet();
        for (int i = 0; i < arrayList3.size(); ++i) {
            long l = arrayList3.get(i);
            if (aSTNode2 instanceof NumberConstant || aSTNode2 instanceof BooleanConstant) {
                if (aSTNode2.getValue() != l) continue;
                arrayList2.add(this.collectSlice(aSTNode.getChild(1).getChild(i), arrayList, n + 1));
                continue;
            }
            if (!aSTNode2.containsValue(l)) continue;
            arrayList2.add(this.collectSlice(aSTNode.getChild(1).getChild(i), arrayList, n + 1));
        }
        return CompoundMatrix.makeCompoundMatrix(arrayList2);
    }
}

