/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.model.SymbolTable;

public class Element
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Element(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Element(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (int i = 0; i < 2; ++i) {
            if (this.getChild(i).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            CmdFlags.println("ERROR: Expected one-dimensional matrix for first argument of element constraint: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0) instanceof CompoundMatrix) {
            if (this.getChild(1).isConstant()) {
                long l = this.getChild(1).getValue();
                if (l < 0L || l >= (long)(this.getChild(0).numChildren() - 1)) {
                    return this;
                }
                return this.getChild(0).getChild((int)l + 1);
            }
            Intpair intpair = this.getChild(1).getBounds();
            int n = this.getChild(0).numChildren() - 1;
            if (intpair.upper < (long)(n - 1)) {
                ArrayList<ASTNode> arrayList = this.list();
                int n2 = 1;
                while ((long)n2 <= intpair.upper + 1L) {
                    arrayList.add(this.getChild(0).getChild(n2));
                    ++n2;
                }
                return new Element(CompoundMatrix.makeCompoundMatrix(arrayList), this.getChild(1));
            }
            if (this.getChild(1).toFlatten(false) && (intpair.lower > 0L || intpair.upper < (long)(n - 1))) {
                ArrayList<ASTNode> arrayList = this.list();
                if (intpair.lower < 0L) {
                    intpair.lower = 0L;
                }
                if (intpair.upper > (long)(n - 1)) {
                    intpair.upper = n - 1;
                }
                int n3 = (int)intpair.lower;
                while ((long)n3 <= intpair.upper) {
                    arrayList.add(this.getChild(0).getChild(n3 + 1));
                    ++n3;
                }
                return new Element(CompoundMatrix.makeCompoundMatrix(arrayList), BinOp.makeBinOp("-", this.getChild(1), new NumberConstant(intpair.lower)));
            }
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        return this.lookupBounds(intpair);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        if (CmdFlags.getUseBoundVars() && (aSTNode.exceedsBoundThreshold() || this.getChild(0).exceedsBoundThreshold() || this.getChild(1).exceedsBoundThreshold())) {
            stringBuilder.append("element(");
        } else {
            stringBuilder.append("watchelement(");
        }
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("element(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("), ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }
}

