/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.LogicBinOp;
import savilerow.expression.Negate;
import savilerow.expression.Or;
import savilerow.model.SymbolTable;

public class Implies
extends LogicBinOp {
    public static final long serialVersionUID = 1L;

    public Implies(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Implies(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("ineq(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", 0)");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("leq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Implies(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint bool_le(");
        this.getChild(0).toFlatzinc(stringBuilder, true);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, true);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append("->");
        this.getChild(1).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public ASTNode simplify() {
        return new Or(new Negate(this.getChild(0)), this.getChild(1));
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new And(this.getChild(0), new Negate(this.getChild(1)));
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: Implication contains non-relation expression:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " -> " + this.getChild(1) + ")";
    }
}

