/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.EmptyRange;
import savilerow.expression.IntegerDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;

public class Intpair
implements Comparable<Intpair> {
    public long lower;
    public long upper;

    public Intpair(long l, long l2) {
        this.lower = l;
        this.upper = l2;
    }

    public String toString() {
        return "(" + this.lower + "," + this.upper + ")";
    }

    public boolean isEmpty() {
        return this.lower > this.upper;
    }

    public Intpair intersect(Intpair intpair) {
        long l = this.lower < intpair.lower ? intpair.lower : this.lower;
        long l2 = this.upper < intpair.upper ? this.upper : intpair.upper;
        return new Intpair(l, l2);
    }

    public Intpair union(Intpair intpair) {
        long l = this.lower < intpair.lower ? this.lower : intpair.lower;
        long l2 = this.upper > intpair.upper ? this.upper : intpair.upper;
        return new Intpair(l, l2);
    }

    public Intpair merge(Intpair intpair) {
        if (this.upper < intpair.lower - 1L || this.lower - 1L > intpair.upper) {
            return null;
        }
        long l = this.lower < intpair.lower ? this.lower : intpair.lower;
        long l2 = this.upper < intpair.upper ? intpair.upper : this.upper;
        return new Intpair(l, l2);
    }

    public ArrayList<Intpair> subtract(Intpair intpair) {
        Intpair intpair2;
        Intpair intpair3 = this.intersect(intpair);
        ArrayList<Intpair> arrayList = new ArrayList<Intpair>();
        long l = this.lower;
        long l2 = this.upper < intpair3.lower - 1L ? this.upper : intpair3.lower - 1L;
        long l3 = this.lower > intpair3.upper + 1L ? this.lower : intpair3.upper + 1L;
        long l4 = this.upper;
        Intpair intpair4 = new Intpair(l, l2);
        if (!intpair4.isEmpty()) {
            arrayList.add(intpair4);
        }
        if (!(intpair2 = new Intpair(l3, l4)).isEmpty()) {
            arrayList.add(intpair2);
        }
        return arrayList;
    }

    @Override
    public int compareTo(Intpair intpair) {
        if (this.lower > intpair.lower) {
            return 1;
        }
        if (this.lower == intpair.lower) {
            if (this.upper > intpair.upper) {
                return 1;
            }
            if (this.upper == intpair.upper) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static long BigIntegerToLong(BigInteger bigInteger) {
        long l = bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) <= 0 ? Long.MIN_VALUE : (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0 ? Long.MAX_VALUE : bigInteger.longValue());
        return l;
    }

    public static ASTNode makeDomain(ArrayList<Intpair> arrayList, boolean bl) {
        if (bl) {
            assert (arrayList.size() <= 1);
            assert (arrayList.size() == 0 || arrayList.get((int)0).lower >= 0L && arrayList.get((int)0).upper <= 1L);
            if (arrayList.size() == 0) {
                return new BooleanDomain(new EmptyRange());
            }
            return new BooleanDomain(new Range(new NumberConstant(arrayList.get((int)0).lower), new NumberConstant(arrayList.get((int)0).upper)));
        }
        if (arrayList.size() == 1 && arrayList.get((int)0).lower == Long.MIN_VALUE && arrayList.get((int)0).upper == Long.MAX_VALUE) {
            return new IntegerDomain(new Range(null, null));
        }
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Intpair intpair = arrayList.get(i);
            if (intpair.lower == intpair.upper) {
                arrayList2.add(new NumberConstant(intpair.lower));
                continue;
            }
            NumberConstant numberConstant = intpair.lower == Long.MIN_VALUE ? null : new NumberConstant(intpair.lower);
            NumberConstant numberConstant2 = intpair.upper == Long.MAX_VALUE ? null : new NumberConstant(intpair.upper);
            arrayList2.add(new Range(numberConstant, numberConstant2));
        }
        return new IntegerDomain(arrayList2);
    }

    public static long numValues(ArrayList<Intpair> arrayList) {
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            l = l + arrayList.get((int)i).upper - arrayList.get((int)i).lower + 1L;
        }
        return l;
    }
}

