/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.PosInfinity;
import savilerow.model.SymbolTable;

public class Length
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Length(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Length(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Length must contain a one-dimensional matrix:" + this);
            return false;
        }
        return true;
    }

    @Override
    public Intpair getBounds() {
        return new Intpair(0L, Long.MAX_VALUE);
    }

    @Override
    public PairASTNode getBoundsAST() {
        return new PairASTNode(new NumberConstant(0L), new PosInfinity());
    }

    @Override
    public ASTNode simplify() {
        ArrayList<ASTNode> arrayList = this.getChild(0).getIndexDomains();
        if (arrayList == null) {
            return this;
        }
        assert (arrayList.size() == 1);
        ArrayList<Intpair> arrayList2 = arrayList.get(0).getIntervalSet();
        long l = 0L;
        for (int i = 0; i < arrayList2.size(); ++i) {
            l += arrayList2.get((int)i).upper - arrayList2.get((int)i).lower + 1L;
        }
        return new NumberConstant(l);
    }

    @Override
    public String toString() {
        return "length(" + this.getChild(0) + ")";
    }
}

