/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.LessEqual;
import savilerow.expression.NumberConstant;
import savilerow.expression.SATLiteral;
import savilerow.expression.WeightedSum;
import savilerow.model.Sat;

public class Less
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Less(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Less(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(false);
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.upper < intpair2.lower) {
            return new BooleanConstant(true);
        }
        if (intpair.lower >= intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            if (this.getChild(0).getValue() < this.getChild(1).getValue()) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0), this.getChild(1)), new NumberConstant(-1L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3) {
            Pair<ASTNode, ASTNode> pair = ((WeightedSum)this.getChild(0)).retrieveConstant();
            if (pair != null) {
                return new Less(pair.getSecond(), BinOp.makeBinOp("-", this.getChild(1), pair.getFirst()));
            }
            return new LessEqual(this.getChild(0), BinOp.makeBinOp("-", this.getChild(1), new NumberConstant(1L)));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3) {
            Pair<ASTNode, ASTNode> pair = ((WeightedSum)this.getChild(1)).retrieveConstant();
            if (pair != null) {
                return new Less(BinOp.makeBinOp("-", this.getChild(0), pair.getFirst()), pair.getSecond());
            }
            return new LessEqual(BinOp.makeBinOp("+", this.getChild(0), new NumberConstant(1L)), this.getChild(1));
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new LessEqual(this.getChild(1), this.getChild(0));
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("ineq(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", -1)");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "<" + this.getChild(1) + ")";
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("<");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("less(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint int_lt(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("<");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(1) instanceof SATLiteral) {
                assert (this.getChild(0).getValue() == 0L);
                return ((SATLiteral)this.getChild(1)).getLit();
            }
            assert (this.getChild(1) instanceof Identifier);
            return -sat.getOrderVariable(this.getChild(1).toString(), this.getChild(0).getValue());
        }
        if (this.getChild(1).isConstant()) {
            if (this.getChild(0) instanceof SATLiteral) {
                assert (this.getChild(1).getValue() == 1L);
                return -((SATLiteral)this.getChild(0)).getLit();
            }
            assert (this.getChild(0) instanceof Identifier);
            return sat.getOrderVariable(this.getChild(0).toString(), this.getChild(1).getValue() - 1L);
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        sat.supportEncodingBinary(this, this.getChild(0), this.getChild(1));
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        sat.supportEncodingBinaryWithAuxVar(this, this.getChild(0), this.getChild(1), l);
    }

    @Override
    public boolean test(long l, long l2) {
        return l < l2;
    }
}

