/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.NumberConstant;
import savilerow.expression.SATLiteral;
import savilerow.expression.WeightedSum;
import savilerow.model.Sat;

public class LessEqual
extends BinOp {
    public static final long serialVersionUID = 1L;

    public LessEqual(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new LessEqual(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() > 2) {
            ((WeightedSum)this.getChild(0)).toDominionLeq(stringBuilder, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() > 2) {
            ((WeightedSum)this.getChild(1)).toDominionGeq(stringBuilder, this.getChild(0));
            return;
        }
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("leq(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public ASTNode simplify() {
        Pair<ASTNode, ASTNode> pair;
        if (this.getChild(0).equals(this.getChild(1))) {
            return new BooleanConstant(true);
        }
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair.upper <= intpair2.lower) {
            return new BooleanConstant(true);
        }
        if (intpair.lower > intpair2.upper) {
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            if (this.getChild(0).getValue() <= this.getChild(1).getValue()) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(1) instanceof WeightedSum) {
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0).copy(), this.getChild(1).copy()), new NumberConstant(0L));
        }
        if (this.getChild(0) instanceof WeightedSum && this.getChild(0).getCategory() == 3 && this.getChild(1).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(0)).retrieveConstant()) != null) {
            return new LessEqual(pair.getSecond(), BinOp.makeBinOp("-", this.getChild(1), pair.getFirst()));
        }
        if (this.getChild(1) instanceof WeightedSum && this.getChild(1).getCategory() == 3 && this.getChild(0).getCategory() < 3 && (pair = ((WeightedSum)this.getChild(1)).retrieveConstant()) != null) {
            return new LessEqual(BinOp.makeBinOp("-", this.getChild(0), pair.getFirst()), pair.getSecond());
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return new Less(this.getChild(1), this.getChild(0));
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toMinionLeq(stringBuilder, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toMinionGeq(stringBuilder, this.getChild(0));
            return;
        }
        stringBuilder.append("ineq(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(", 0)");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("<=");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "<=" + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toFlatzincLeq(stringBuilder, this.getChild(1));
            return;
        }
        if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toFlatzincGeq(stringBuilder, this.getChild(0));
            return;
        }
        stringBuilder.append("constraint int_le(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(", ");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append("<=");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(1) instanceof SATLiteral) {
                assert (this.getChild(0).getValue() == 1L);
                return ((SATLiteral)this.getChild(1)).getLit();
            }
            if (this.getChild(1) instanceof Identifier) {
                return -sat.getOrderVariable(this.getChild(1).toString(), this.getChild(0).getValue() - 1L);
            }
        }
        if (this.getChild(1).isConstant()) {
            if (this.getChild(0) instanceof SATLiteral) {
                assert (this.getChild(1).getValue() == 0L);
                return -((SATLiteral)this.getChild(0)).getLit();
            }
            if (this.getChild(0) instanceof Identifier) {
                return sat.getOrderVariable(this.getChild(0).toString(), this.getChild(1).getValue());
            }
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        assert (!(this.getChild(0) instanceof WeightedSum) || !(this.getChild(1) instanceof WeightedSum));
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toSATLeq(sat, this.getChild(1).getValue());
        } else if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toSATGeq(sat, this.getChild(0).getValue());
        } else {
            sat.supportEncodingBinary(this, this.getChild(0), this.getChild(1));
        }
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        if (this.getChild(0) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(0)).toSATLeqWithAuxVar(sat, this.getChild(1).getValue(), l);
        } else if (this.getChild(1) instanceof WeightedSum) {
            ((WeightedSum)this.getChild(1)).toSATGeqWithAuxVar(sat, this.getChild(0).getValue(), l);
        } else {
            sat.supportEncodingBinaryWithAuxVar(this, this.getChild(0), this.getChild(1), l);
        }
    }

    @Override
    public boolean test(long l, long l2) {
        return l <= l2;
    }
}

