/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.Negate;
import savilerow.expression.SATLiteral;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Or
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public Or(ArrayList<ASTNode> arrayList) {
        super(arrayList);
    }

    public Or(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Or(this.getChildren());
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        int n;
        boolean bl = false;
        ArrayList<ASTNode> arrayList = this.getChildren();
        for (n = 0; n < arrayList.size(); ++n) {
            if (!(arrayList.get(n) instanceof Or)) continue;
            bl = true;
            ASTNode aSTNode = arrayList.remove(n);
            --n;
            arrayList.addAll(aSTNode.getChildren());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (!arrayList.get(n).isConstant()) continue;
            long l = arrayList.get(n).getValue();
            if (l == 1L) {
                return new BooleanConstant(true);
            }
            bl = true;
            arrayList.remove(n);
            --n;
        }
        HashSet<ASTNode> hashSet = new HashSet<ASTNode>(arrayList);
        if (hashSet.size() < arrayList.size()) {
            bl = true;
            arrayList.clear();
            arrayList.addAll(hashSet);
        }
        if (arrayList.size() == 0) {
            return new BooleanConstant(false);
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        if (bl) {
            return new Or(arrayList);
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < this.numChildren(); ++i) {
            arrayList.add(new Negate(this.getChild(i)));
        }
        return new And(arrayList);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (!aSTNode.typecheck(symbolTable)) {
                return false;
            }
            if (aSTNode.isRelation()) continue;
            System.out.println("ERROR: 'Or' contains numerical expression:" + aSTNode);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode normalise() {
        ArrayList<ASTNode> arrayList = this.getChildren();
        boolean bl = Or.sortByHashcode(arrayList);
        if (bl) {
            return new Or(arrayList);
        }
        return this;
    }

    @Override
    public boolean isCommAssoc() {
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("watched-or({");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("})");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            stringBuilder.append(this.getChild(i).toString());
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(" \\/ ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("])");
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint array_bool_or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],");
        aSTNode.toFlatzinc(stringBuilder, true);
        stringBuilder.append(");");
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint array_bool_or([");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toFlatzinc(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("],");
        stringBuilder.append("true);");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("(");
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, true);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(" \\/ ");
        }
        stringBuilder.append(")");
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.numChildren(); ++i) {
            ASTNode aSTNode = this.getChild(i);
            if (aSTNode instanceof Identifier || aSTNode instanceof SATLiteral) {
                arrayList.add(aSTNode.directEncode(sat, 1L));
                continue;
            }
            long l = sat.createAuxSATVariable();
            aSTNode.toSATWithAuxVar(sat, l);
            arrayList.add(l);
        }
        sat.addClause(arrayList);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (ASTNode aSTNode : this.getChildren()) {
            if (aSTNode instanceof Identifier || aSTNode instanceof SATLiteral) {
                arrayList.add(aSTNode.directEncode(sat, 1L));
                continue;
            }
            long l2 = sat.createAuxSATVariable();
            aSTNode.toSATWithAuxVar(sat, l2);
            arrayList.add(l2);
        }
        sat.addClauseReified(arrayList, l);
    }

    @Override
    public boolean childrenAreSymmetric() {
        return true;
    }
}

