/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Unpack;
import savilerow.model.SymbolTable;

public class SafeMatrixDeref
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public SafeMatrixDeref(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
    }

    @Override
    public ASTNode copy() {
        ASTNode aSTNode = this.getChild(0);
        ArrayList<ASTNode> arrayList = this.getChildren();
        arrayList.remove(0);
        return new SafeMatrixDeref(aSTNode, arrayList);
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return !this.getChild(0).isRelation() && !this.getChild(0).isSet();
    }

    @Override
    public boolean isSet() {
        return this.getChild(0).isSet();
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        if (intpair.lower > 0L) {
            intpair.lower = 0L;
        }
        if (intpair.upper < 0L) {
            intpair.upper = 0L;
        }
        return intpair;
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(0).getBoundsAST();
        pairASTNode.e1 = new Min(pairASTNode.e1, new NumberConstant(0L));
        pairASTNode.e2 = new Max(pairASTNode.e2, new NumberConstant(0L));
        return pairASTNode;
    }

    @Override
    public ASTNode simplify() {
        if (this.numChildren() == 2 && this.getChild(1) instanceof Unpack) {
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                return new SafeMatrixDeref(this.getChild(0), arrayList);
            }
            return this;
        }
        boolean bl = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() == 0) continue;
            bl = true;
        }
        if (!bl) {
            Object object;
            SymbolTable symbolTable;
            if (this.getChild(0) instanceof Identifier && (symbolTable = ((Identifier)this.getChild((int)0)).global_symbols).getCategory((String)(object = this.getChild(0).toString())) == 0) {
                ASTNode aSTNode = symbolTable.getConstantMatrix((String)object);
                ArrayList<ASTNode> arrayList = this.getChildren();
                arrayList.remove(0);
                ASTNode aSTNode2 = SafeMatrixDeref.derefCompoundMatrix(aSTNode, arrayList);
                if (aSTNode2 == null) {
                    return this;
                }
                return aSTNode2.copy();
            }
            if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
                ArrayList<ASTNode> arrayList = this.getChildren();
                arrayList.remove(0);
                object = SafeMatrixDeref.derefCompoundMatrix(this.getChild(0), arrayList);
                if (object == null) {
                    return this;
                }
                return object;
            }
        }
        return this;
    }

    public static ASTNode derefCompoundMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            if (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix)) {
                return null;
            }
            if (aSTNode instanceof EmptyMatrix) {
                return new NumberConstant(0L);
            }
            ASTNode aSTNode2 = aSTNode.getChild(0);
            long l = arrayList.get(i).getValue();
            ArrayList<Intpair> arrayList2 = aSTNode2.getIntervalSet();
            int n2 = -1;
            int n3 = 0;
            for (n = 0; n < arrayList2.size(); ++n) {
                Intpair intpair = arrayList2.get(n);
                if (l >= intpair.lower && l <= intpair.upper) {
                    n2 = (int)(l - intpair.lower + (long)n3);
                    break;
                }
                n3 = (int)((long)n3 + (intpair.upper - intpair.lower + 1L));
            }
            if (n2 == -1) {
                return new NumberConstant(0L);
            }
            n = n2 + 1;
            aSTNode = aSTNode.getChild(n);
        }
        return aSTNode;
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        int n;
        for (n = 0; n < this.numChildren(); ++n) {
            if (this.getChild(n).typecheck(symbolTable)) continue;
            return false;
        }
        if (this.getChild(0).getDimension() != this.numChildren() - 1) {
            System.out.println("ERROR: Dimension mismatch in matrix deref: " + this);
            return false;
        }
        for (n = 1; n < this.numChildren(); ++n) {
            if (this.getChild(n).isNumerical() || this.getChild(n).isRelation()) continue;
            System.out.println("ERROR: In matrix deref " + this + ", index " + this.getChild(n) + " is not numerical or relational.");
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            if (CmdFlags.getUseBoundVars() && this.exceedsBoundThreshold()) {
                stringBuilder.append("eq(");
            } else {
                stringBuilder.append("w-literal(");
            }
        }
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (bl) {
            stringBuilder.append(",1)");
        }
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ", ";
        }
        return string + "]";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(CmdFlags.getCtName() + " ");
            stringBuilder.append("literal(");
        }
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (bl) {
            stringBuilder.append(", 1)");
        }
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        this.getChild(0).toMinizinc(stringBuilder, bl);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinizinc(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }
}

