/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import java.util.Collections;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.EmptyRange;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.model.SymbolTable;

public class ToSet
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ToSet(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new ToSet(this.getChild(0));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public boolean isFiniteSet() {
        return true;
    }

    @Override
    public boolean isFiniteSetUpper() {
        return true;
    }

    @Override
    public boolean isFiniteSetLower() {
        return true;
    }

    @Override
    public boolean isBooleanSet() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (this.getChild(0).getDimension() != 1) {
            System.out.println("ERROR: Expected one-dimensional matrix inside toSet function: " + this);
            return false;
        }
        if (this.getChild(0).getCategory() == 3) {
            System.out.println("ERROR: toSet function contains a decision variable: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        ASTNode aSTNode = this.getChild(0);
        if (aSTNode instanceof Identifier) {
            aSTNode = ((Identifier)aSTNode).global_symbols.getConstantMatrix(aSTNode.toString());
        }
        if ((aSTNode instanceof EmptyMatrix || aSTNode instanceof CompoundMatrix) && aSTNode.getCategory() == 0) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                arrayList.add(aSTNode.getChild(i).getValue());
            }
            Collections.sort(arrayList);
            if (!aSTNode.isRelation()) {
                ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i != 0 && ((Long)arrayList.get(i)).equals(arrayList.get(i - 1))) continue;
                    arrayList2.add(new NumberConstant((Long)arrayList.get(i)));
                }
                return new IntegerDomain(arrayList2);
            }
            if (arrayList.size() == 0) {
                return new BooleanDomain(new EmptyRange());
            }
            return new BooleanDomain(new Range(new NumberConstant((Long)arrayList.get(0)), new NumberConstant((Long)arrayList.get(arrayList.size() - 1))));
        }
        return this;
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public String toString() {
        return "toSet(" + this.getChild(0) + ")";
    }
}

