/*
 * Decompiled with CFR 0.152.
 */
package savilerow.model;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import savilerow.CmdFlags;
import savilerow.Pair;
import savilerow.expression.ASTNode;
import savilerow.expression.And;
import savilerow.expression.BinOp;
import savilerow.expression.BooleanConstant;
import savilerow.expression.BooleanDomain;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.Container;
import savilerow.expression.Domain;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.HoleyMatrixDomain;
import savilerow.expression.Identifier;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intersect;
import savilerow.expression.Intpair;
import savilerow.expression.Letting;
import savilerow.expression.MatrixDomain;
import savilerow.expression.Negate;
import savilerow.expression.NumberConstant;
import savilerow.expression.Range;
import savilerow.expression.SimpleDomain;
import savilerow.model.Model;
import savilerow.model.categoryentry;
import savilerow.model.replaces_matrix_entry;
import savilerow.treetransformer.ReplaceASTNode;
import savilerow.treetransformer.TransformFixSTRef;
import savilerow.treetransformer.TransformSimplify;
import savilerow.treetransformer.TreeTransformer;
import savilerow.treetransformer.TreeTransformerBottomUpNoWrapper;

public class SymbolTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Model m;
    public ArrayDeque<ASTNode> lettings_givens = new ArrayDeque();
    public HashMap<String, categoryentry> category;
    public categoryentry category_first = null;
    public categoryentry category_last = null;
    private ArrayList<categoryentry> category_list;
    private HashMap<String, ASTNode> domains = new HashMap();
    private HashMap<String, ASTNode> constant_matrices;
    public HashMap<String, String> represents_ct;
    public HashMap<String, ASTNode> deleted_matrices;
    public HashMap<String, ASTNode> matrix_original_domain;
    public HashMap<String, replaces_matrix_entry> replaces_matrix;
    int auxvarcounter = 0;
    public HashMap<ASTNode, ASTNode> replacements;
    public HashMap<ASTNode, ASTNode> replacements_domains;
    public HashMap<ASTNode, Integer> replacements_category;
    HashMap<String, Boolean> boolvar_bool;
    HashMap<String, Boolean> boolvar_int;
    HashSet<String> directvar_sat;

    public SymbolTable() {
        this.category = new HashMap();
        this.constant_matrices = new HashMap();
        this.represents_ct = new HashMap();
        this.boolvar_bool = new HashMap();
        this.boolvar_int = new HashMap();
        this.deleted_matrices = new HashMap();
        this.matrix_original_domain = new HashMap();
        this.replaces_matrix = new HashMap();
        this.replacements = new HashMap();
        this.replacements_domains = new HashMap();
        this.replacements_category = new HashMap();
    }

    private void category_put_end(String string, int n) {
        if (this.category_last == null) {
            assert (this.category_first == null);
            this.category_first = this.category_last = new categoryentry(string, n, null, null);
        } else {
            categoryentry categoryentry2;
            this.category_last.next = categoryentry2 = new categoryentry(string, n, this.category_last, null);
            this.category_last = categoryentry2;
        }
        this.category.put(string, this.category_last);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SymbolTable)) {
            return false;
        }
        SymbolTable symbolTable = (SymbolTable)object;
        if (this.lettings_givens.size() != symbolTable.lettings_givens.size()) {
            return false;
        }
        Iterator<ASTNode> iterator = this.lettings_givens.iterator();
        Iterator<ASTNode> iterator2 = symbolTable.lettings_givens.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        if (!symbolTable.category.equals(this.category)) {
            return false;
        }
        categoryentry categoryentry2 = this.category_first;
        categoryentry categoryentry3 = symbolTable.category_first;
        while (categoryentry2 != null || categoryentry3 != null) {
            if (categoryentry2 == null || categoryentry3 == null) {
                return false;
            }
            if (!categoryentry2.equals(categoryentry3)) {
                return false;
            }
            assert (categoryentry2.next == null || categoryentry2.next.prev == categoryentry2);
            assert (categoryentry3.next == null || categoryentry3.next.prev == categoryentry3);
            assert (categoryentry2.next != null || categoryentry2 == this.category_last);
            assert (categoryentry3.next != null || categoryentry3 == symbolTable.category_last);
            categoryentry2 = categoryentry2.next;
            categoryentry3 = categoryentry3.next;
        }
        if (!symbolTable.domains.equals(this.domains)) {
            return false;
        }
        if (!symbolTable.constant_matrices.equals(this.constant_matrices)) {
            return false;
        }
        if (!symbolTable.represents_ct.equals(this.represents_ct)) {
            return false;
        }
        if (!symbolTable.deleted_matrices.equals(this.deleted_matrices)) {
            return false;
        }
        if (!symbolTable.matrix_original_domain.equals(this.matrix_original_domain)) {
            return false;
        }
        if (!symbolTable.replaces_matrix.equals(this.replaces_matrix)) {
            return false;
        }
        if (symbolTable.auxvarcounter != this.auxvarcounter) {
            return false;
        }
        if (!symbolTable.replacements.equals(this.replacements)) {
            return false;
        }
        if (!symbolTable.replacements_domains.equals(this.replacements_domains)) {
            return false;
        }
        return symbolTable.replacements_category.equals(this.replacements_category);
    }

    public SymbolTable copy() {
        SymbolTable symbolTable = new SymbolTable();
        TransformFixSTRef transformFixSTRef = new TransformFixSTRef(symbolTable);
        for (ASTNode iterator : this.lettings_givens) {
            symbolTable.lettings_givens.addLast(transformFixSTRef.transform(iterator.copy()));
        }
        Object object = this.category_first;
        while (object != null) {
            symbolTable.category_put_end(((categoryentry)object).name, ((categoryentry)object).cat);
            object = ((categoryentry)object).next;
        }
        for (String string : this.domains.keySet()) {
            symbolTable.domains.put(string, transformFixSTRef.transform(this.domains.get(string).copy()));
        }
        for (String string : this.constant_matrices.keySet()) {
            symbolTable.constant_matrices.put(string, transformFixSTRef.transform(this.constant_matrices.get(string).copy()));
        }
        symbolTable.represents_ct = new HashMap<String, String>(this.represents_ct);
        for (String string : this.deleted_matrices.keySet()) {
            symbolTable.deleted_matrices.put(string, transformFixSTRef.transform(this.deleted_matrices.get(string).copy()));
        }
        for (String string : this.matrix_original_domain.keySet()) {
            symbolTable.matrix_original_domain.put(string, transformFixSTRef.transform(this.matrix_original_domain.get(string).copy()));
        }
        for (String string : this.replaces_matrix.keySet()) {
            replaces_matrix_entry replaces_matrix_entry2 = new replaces_matrix_entry(this.replaces_matrix.get((Object)string).name, new ArrayList<Long>(this.replaces_matrix.get((Object)string).idx));
            symbolTable.replaces_matrix.put(string, replaces_matrix_entry2);
        }
        symbolTable.auxvarcounter = this.auxvarcounter;
        for (ASTNode aSTNode : this.replacements.keySet()) {
            symbolTable.replacements.put(transformFixSTRef.transform(aSTNode.copy()), transformFixSTRef.transform(this.replacements.get(aSTNode).copy()));
        }
        for (ASTNode aSTNode : this.replacements_domains.keySet()) {
            symbolTable.replacements_domains.put(transformFixSTRef.transform(aSTNode.copy()), transformFixSTRef.transform(this.replacements_domains.get(aSTNode).copy()));
        }
        for (ASTNode aSTNode : this.replacements_category.keySet()) {
            symbolTable.replacements_category.put(transformFixSTRef.transform(aSTNode.copy()), (int)this.replacements_category.get(aSTNode));
        }
        return symbolTable;
    }

    public void setModel(Model model) {
        this.m = model;
    }

    public void newVariable(String string, ASTNode aSTNode, int n) {
        assert (!this.category.containsKey(string));
        this.domains.put(string, aSTNode);
        this.category_put_end(string, n);
    }

    public void newVariable(String string, int n) {
        assert (n == 0);
        assert (!this.category.containsKey(string));
        this.category_put_end(string, n);
    }

    public void newVariable(String string, ASTNode aSTNode, int n, ASTNode aSTNode2, ArrayList<Long> arrayList) {
        Serializable serializable;
        assert (!this.category.containsKey(string));
        this.domains.put(string, aSTNode);
        if (aSTNode.getCategory() == 0 && (serializable = aSTNode.getIntervalSet()).size() == 0) {
            CmdFlags.println("ERROR: Empty domain");
        }
        serializable = this.category.get(aSTNode2.toString());
        categoryentry categoryentry2 = new categoryentry(string, n, ((categoryentry)serializable).prev, (categoryentry)serializable);
        if (categoryentry2.next == null) {
            this.category_last = categoryentry2;
        } else {
            categoryentry2.next.prev = categoryentry2;
        }
        if (categoryentry2.prev == null) {
            this.category_first = categoryentry2;
        } else {
            categoryentry2.prev.next = categoryentry2;
        }
        this.category.put(string, categoryentry2);
        this.replaces_matrix.put(string, new replaces_matrix_entry(aSTNode2.toString(), new ArrayList<Long>(arrayList)));
    }

    public void unifyVariables(ASTNode aSTNode, ASTNode object) {
        Object object2;
        assert (aSTNode.getCategory() == 3 && ((ASTNode)object).getCategory() == 3);
        if (this.category.get((Object)aSTNode.toString()).cat == 10) {
            object2 = aSTNode;
            aSTNode = object;
            object = object2;
        }
        object2 = new TransformSimplify();
        this.setDomain(aSTNode.toString(), ((TreeTransformerBottomUpNoWrapper)object2).transform(new Intersect(this.getDomain(aSTNode.toString()), this.getDomain(((ASTNode)object).toString()))));
        this.replacements.put((ASTNode)object, aSTNode);
        this.replacements_domains.put((ASTNode)object, this.getDomain(((ASTNode)object).toString()));
        this.replacements_category.put((ASTNode)object, this.category.get((Object)((ASTNode)object).toString()).cat);
        this.deleteSymbol(((ASTNode)object).toString());
    }

    public void unifyVariablesNegated(ASTNode aSTNode, ASTNode object) {
        Object object2;
        assert (aSTNode.getCategory() == 3 && ((ASTNode)object).getCategory() == 3);
        assert (object instanceof Negate);
        object = ((ASTNode)object).getChild(0);
        assert (aSTNode.isRelation() && ((ASTNode)object).isRelation());
        if (this.category.get((Object)aSTNode.toString()).cat == 10) {
            object2 = aSTNode;
            aSTNode = object;
            object = object2;
        }
        object2 = new TransformSimplify();
        this.setDomain(aSTNode.toString(), ((TreeTransformerBottomUpNoWrapper)object2).transform(new Intersect(this.getDomain(aSTNode.toString()), this.getDomain(((ASTNode)object).toString()))));
        this.replacements.put((ASTNode)object, new Negate(aSTNode));
        this.replacements_domains.put((ASTNode)object, this.getDomain(((ASTNode)object).toString()));
        this.replacements_category.put((ASTNode)object, this.category.get((Object)((ASTNode)object).toString()).cat);
        this.deleteSymbol(((ASTNode)object).toString());
    }

    public void assignVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        assert (!CmdFlags.getUseAggregate() || CmdFlags.getAfterAggregate());
        assert (aSTNode instanceof Identifier);
        assert (aSTNode2.isConstant());
        assert (this.getDomain(aSTNode.toString()).containsValue(aSTNode2.getValue()));
        assert (((Identifier)aSTNode).global_symbols == this);
        if (aSTNode.isRelation() && !aSTNode2.isRelation()) {
            long l = aSTNode2.getValue();
            assert (l >= 0L && l <= 1L);
            aSTNode2 = new BooleanConstant(l == 1L);
        }
        this.replacements.put(aSTNode, aSTNode2);
        this.replacements_domains.put(aSTNode, this.getDomain(aSTNode.toString()));
        this.replacements_category.put(aSTNode, this.category.get((Object)aSTNode.toString()).cat);
        this.deleteSymbol(aSTNode.toString());
    }

    public void newDim(String string, ASTNode aSTNode, int n) {
        assert (!this.category.containsKey(string));
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new IntegerDomain(new Range(null, null)));
        }
        this.domains.put(string, new MatrixDomain(aSTNode, arrayList));
        this.category_put_end(string, 12);
    }

    public void newForallFind(String string, ASTNode aSTNode) {
        assert (this.domains.containsKey(string));
        this.domains.put(string, new HoleyMatrixDomain(this.domains.get(string), aSTNode));
        this.category.get((Object)string).cat = 3;
    }

    public void newConstantMatrix(String string, ASTNode aSTNode) {
        if (this.category.containsKey(string)) {
            assert (this.category.get((Object)string).cat == 1);
            this.category.get((Object)string).cat = 11;
        } else {
            this.category_put_end(string, 11);
        }
        this.constant_matrices.put(string, aSTNode);
        if (this.domains.get(string) == null) {
            ArrayList<Long> arrayList = this.getConstantMatrixSize(aSTNode);
            Intpair intpair = this.getConstantMatrixBounds(aSTNode);
            SimpleDomain simpleDomain = intpair == null ? (aSTNode.isRelation() ? new BooleanDomain(new Range(new NumberConstant(0L), new NumberConstant(0L))) : new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(0L)))) : (aSTNode.isRelation() ? new BooleanDomain(new Range(new NumberConstant(intpair.lower), new NumberConstant(intpair.upper))) : new IntegerDomain(new Range(new NumberConstant(intpair.lower), new NumberConstant(intpair.upper))));
            ASTNode aSTNode2 = aSTNode;
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(aSTNode2.getChild(0));
                if (aSTNode2.numChildren() > 1) {
                    aSTNode2 = aSTNode2.getChild(1);
                    continue;
                }
                assert (i == arrayList.size() - 1);
            }
            MatrixDomain matrixDomain = new MatrixDomain((ASTNode)simpleDomain, arrayList2);
            this.domains.put(string, matrixDomain);
        } else {
            this.tightenConstantMatrixDomain(string);
        }
    }

    void tightenConstantMatrixDomain(String string) {
        Intpair intpair = this.getConstantMatrixBounds(this.constant_matrices.get(string));
        if (intpair != null) {
            ASTNode aSTNode = this.domains.get(string).getChild(0);
            if (!aSTNode.isBooleanSet()) {
                aSTNode = new Intersect(aSTNode, new IntegerDomain(new Range(new NumberConstant(intpair.lower), new NumberConstant(intpair.upper))));
                TransformSimplify transformSimplify = new TransformSimplify();
                aSTNode = transformSimplify.transform(aSTNode);
            }
            this.domains.get(string).setChild(0, aSTNode);
        }
    }

    ArrayList<Long> getConstantMatrixSize(ASTNode aSTNode) {
        ArrayList<ASTNode> arrayList = aSTNode.getIndexDomains();
        ArrayList<Long> arrayList2 = new ArrayList<Long>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Intpair> arrayList3 = arrayList.get(i).getIntervalSet();
            long l = 0L;
            for (int j = 0; j < arrayList3.size(); ++j) {
                l = l + arrayList3.get((int)j).upper - arrayList3.get((int)j).lower + 1L;
            }
            arrayList2.add(l);
        }
        return arrayList2;
    }

    ArrayList<Long> getConstantMatrixContents(ASTNode aSTNode) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (aSTNode instanceof CompoundMatrix || aSTNode instanceof EmptyMatrix) {
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                arrayList.addAll(this.getConstantMatrixContents(aSTNode.getChild(i)));
            }
        } else {
            assert (aSTNode.isConstant());
            arrayList.add(aSTNode.getValue());
        }
        return arrayList;
    }

    Intpair getConstantMatrixBounds(ASTNode aSTNode) {
        if (aSTNode instanceof CompoundMatrix) {
            Intpair intpair = null;
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                Intpair intpair2 = this.getConstantMatrixBounds(aSTNode.getChild(i));
                if (intpair2 == null) continue;
                if (intpair == null) {
                    intpair = intpair2;
                    continue;
                }
                intpair.lower = intpair.lower < intpair2.lower ? intpair.lower : intpair2.lower;
                intpair.upper = intpair.upper > intpair2.upper ? intpair.upper : intpair2.upper;
            }
            return intpair;
        }
        if (aSTNode instanceof EmptyMatrix) {
            return null;
        }
        assert (aSTNode.isConstant());
        Intpair intpair = new Intpair(aSTNode.getValue(), aSTNode.getValue());
        return intpair;
    }

    public ArrayList<ASTNode> makeLettingsConstantMatrix(String string) {
        ASTNode aSTNode = this.constant_matrices.get(string);
        ASTNode aSTNode2 = this.domains.get(string);
        ArrayList<ASTNode> arrayList = aSTNode.getIndexDomains();
        ASTNode aSTNode3 = aSTNode2.getChild(0);
        ArrayList<ASTNode> arrayList2 = aSTNode2.getChildren();
        arrayList2.remove(0);
        arrayList2.remove(0);
        arrayList2.remove(0);
        ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ASTNode aSTNode4;
            ASTNode aSTNode5;
            if (!(arrayList2.get(i) instanceof IntegerDomain) || arrayList2.get(i).numChildren() != 1 || arrayList.get(i).numChildren() != 1 || !((aSTNode5 = arrayList2.get(i).getChild(0)) instanceof Range) || !(arrayList.get(i).getChild(0) instanceof Range)) continue;
            if (aSTNode5.getChild(0) instanceof Identifier) {
                aSTNode4 = new Letting(aSTNode5.getChild(0), BinOp.makeBinOp("+", BinOp.makeBinOp("-", arrayList.get(i).getChild(0).getChild(0), arrayList.get(i).getChild(0).getChild(1)), aSTNode5.getChild(1)));
                aSTNode4 = new TransformSimplify().transform(aSTNode4);
                arrayList3.add(aSTNode4);
            }
            if (!(aSTNode5.getChild(1) instanceof Identifier)) continue;
            aSTNode4 = new Letting(aSTNode5.getChild(1), BinOp.makeBinOp("+", BinOp.makeBinOp("-", arrayList.get(i).getChild(0).getChild(1), arrayList.get(i).getChild(0).getChild(0)), aSTNode5.getChild(0)));
            aSTNode4 = new TransformSimplify().transform(aSTNode4);
            arrayList3.add(aSTNode4);
        }
        return arrayList3;
    }

    public void correctIndicesConstantMatrix(String string) {
        ASTNode aSTNode = this.constant_matrices.get(string);
        ASTNode aSTNode2 = this.domains.get(string);
        Pair<ASTNode, Boolean> pair = SymbolTable.fixIndicesConstantMatrix(aSTNode2, aSTNode);
        if (pair.getSecond().booleanValue()) {
            System.out.println("WARNING: Index domains do not match for the matrix " + string);
            System.out.println("WARNING: This could be a mismatch between the matrix given in the parameter file");
            System.out.println("WARNING: and its matrix domain in the given statement in the model file.");
        }
        this.constant_matrices.put(string, pair.getFirst());
    }

    public static Pair<ASTNode, Boolean> fixIndicesConstantMatrix(ASTNode aSTNode, ASTNode aSTNode2) {
        ASTNode aSTNode3;
        if (aSTNode2 instanceof EmptyMatrix) {
            return new Pair<ASTNode, Boolean>(new EmptyMatrix(aSTNode.copy()), false);
        }
        assert (aSTNode2 instanceof CompoundMatrix);
        boolean bl = false;
        ASTNode aSTNode4 = aSTNode2.getChild(0);
        if (!aSTNode4.equals(aSTNode3 = aSTNode.getChild(3))) {
            aSTNode2.setChild(0, aSTNode3);
            bl = true;
        }
        ArrayList<ASTNode> arrayList = aSTNode.getChildren();
        arrayList.remove(0);
        arrayList.remove(0);
        arrayList.remove(0);
        arrayList.remove(0);
        if (arrayList.size() == 0) {
            return new Pair<ASTNode, Boolean>(aSTNode2, bl);
        }
        for (int i = 1; i < aSTNode2.numChildren(); ++i) {
            MatrixDomain matrixDomain = new MatrixDomain(aSTNode.getChild(0), arrayList);
            Pair<ASTNode, Boolean> pair = SymbolTable.fixIndicesConstantMatrix(matrixDomain, aSTNode2.getChild(i));
            aSTNode2.setChild(i, pair.getFirst());
            bl = bl || pair.getSecond() != false;
        }
        return new Pair<ASTNode, Boolean>(aSTNode2, bl);
    }

    public boolean checkConstantMatrices() {
        for (String string : this.constant_matrices.keySet()) {
            ASTNode aSTNode = this.domains.get(string);
            ASTNode aSTNode2 = aSTNode.getChild(0);
            ArrayList<ASTNode> arrayList = aSTNode.getChildren();
            arrayList.remove(0);
            arrayList.remove(0);
            arrayList.remove(0);
            HashSet<Long> hashSet = null;
            if (aSTNode2.isFiniteSet()) {
                TransformSimplify transformSimplify = new TransformSimplify();
                hashSet = new HashSet<Long>(transformSimplify.transform(aSTNode2).getValueSet());
            }
            if (this.checkConstantMatrixDomain(string, this.constant_matrices.get(string), arrayList, hashSet, 0)) continue;
            return false;
        }
        return true;
    }

    private boolean checkConstantMatrixDomain(String string, ASTNode aSTNode, ArrayList<ASTNode> arrayList, HashSet<Long> hashSet, int n) {
        block6: {
            int n2;
            block5: {
                ASTNode aSTNode2 = arrayList.get(n);
                TransformSimplify transformSimplify = new TransformSimplify();
                if (aSTNode2.isFiniteSet()) {
                    n2 = transformSimplify.transform(aSTNode2).getValueSet().size();
                    if (aSTNode.numChildren() - 1 != n2) {
                        CmdFlags.println("ERROR: At index " + n + " of constant matrix " + string + ", actual size does not match the matrix dimensions.");
                        return false;
                    }
                } else {
                    CmdFlags.println("ERROR: Not allowed infinite set (" + aSTNode2 + ") for index " + n + " of matrix " + string);
                    return false;
                }
                if (n != arrayList.size() - 1) break block5;
                if (hashSet == null) break block6;
                for (n2 = 1; n2 < aSTNode.numChildren(); ++n2) {
                    ASTNode aSTNode3 = aSTNode.getChild(n2);
                    if (hashSet.contains(aSTNode3.getValue())) continue;
                    CmdFlags.println("ERROR: Item " + aSTNode3 + " is not contained in domain of constant matrix " + string + ".");
                    return false;
                }
                break block6;
            }
            for (n2 = 1; n2 < aSTNode.numChildren(); ++n2) {
                ASTNode aSTNode4 = aSTNode.getChild(n2);
                if (this.checkConstantMatrixDomain(string, (CompoundMatrix)aSTNode4, arrayList, hashSet, n + 1)) continue;
                return false;
            }
        }
        return true;
    }

    public ASTNode getDomain(String string) {
        return this.domains.get(string);
    }

    public ASTNode getConstantMatrix(String string) {
        assert (this.constant_matrices.containsKey(string));
        return this.constant_matrices.get(string);
    }

    public void setConstantMatrix(String string, ASTNode aSTNode) {
        assert (this.constant_matrices.containsKey(string));
        this.constant_matrices.put(string, aSTNode);
    }

    public void setDomain(String string, ASTNode aSTNode) {
        if (aSTNode instanceof MatrixDomain && !this.matrix_original_domain.containsKey(string)) {
            this.matrix_original_domain.put(string, this.domains.get(string));
        }
        this.domains.put(string, aSTNode);
    }

    public ASTNode getOriginalDomain(String string) {
        return this.matrix_original_domain.get(string);
    }

    public HashMap<String, ASTNode> getDomains() {
        return this.domains;
    }

    public HashMap<String, categoryentry> getCategories() {
        return this.category;
    }

    public categoryentry getCategoryFirst() {
        return this.category_first;
    }

    public int getCategory(String string) {
        if (this.category.get(string) == null) {
            return 20;
        }
        int n = this.category.get((Object)string).cat;
        if (n == 10) {
            return 3;
        }
        if (n == 11) {
            return 0;
        }
        if (n == 12) {
            return 3;
        }
        return n;
    }

    public boolean isRelational(String string) {
        ASTNode aSTNode;
        Domain domain = (Domain)this.domains.get(string);
        if (domain instanceof BooleanDomain) {
            return true;
        }
        return domain instanceof MatrixDomain && (aSTNode = domain.getChildren().get(0)) instanceof BooleanDomain;
    }

    public boolean hasVariable(String string) {
        return this.category.containsKey(string);
    }

    public String newAuxId() {
        String string = "aux" + this.auxvarcounter;
        while (this.category.containsKey(string)) {
            ++this.auxvarcounter;
            string = "aux" + this.auxvarcounter;
        }
        ++this.auxvarcounter;
        return string;
    }

    public Identifier newAuxiliaryVariable(long l, long l2) {
        String string = this.newAuxId();
        if (l != 0L || l2 != 1L) {
            this.domains.put(string, new IntegerDomain(new Range(new NumberConstant(l), new NumberConstant(l2))));
        } else {
            this.domains.put(string, new BooleanDomain());
        }
        this.category_put_end(string, 10);
        return new Identifier(string, this);
    }

    public Identifier newAuxiliaryVariable(ASTNode aSTNode) {
        String string = this.newAuxId();
        this.domains.put(string, aSTNode.copy());
        this.category_put_end(string, 10);
        return new Identifier(string, this);
    }

    public ASTNode newAuxHelper(ASTNode aSTNode) {
        Intpair intpair = aSTNode.getBounds();
        ASTNode aSTNode2 = this.m.filt.constructDomain(aSTNode, intpair.lower, intpair.upper);
        Identifier identifier = this.newAuxiliaryVariable(aSTNode2);
        this.m.filt.auxVarRepresentsAST(((ASTNode)identifier).toString(), aSTNode);
        return identifier;
    }

    public Identifier newAuxiliaryVariable(ASTNode aSTNode, ASTNode aSTNode2) {
        String string = this.newAuxId();
        this.domains.put(string, new IntegerDomain(new Range(aSTNode, aSTNode2)));
        this.category_put_end(string, 10);
        return new Identifier(string, this);
    }

    public Identifier newAuxiliaryVariableMatrix(ASTNode aSTNode, ASTNode aSTNode2, ArrayList<ASTNode> arrayList, ArrayList<ASTNode> arrayList2, ArrayList<ASTNode> arrayList3) {
        String string = this.newAuxId();
        this.category_put_end(string, 10);
        this.domains.put(string, new MatrixDomain((ASTNode)new IntegerDomain(new Range(aSTNode, aSTNode2)), arrayList2, (ASTNode)new Container(arrayList), (ASTNode)new And(arrayList3)));
        return new Identifier(string, this);
    }

    public void auxVarRepresentsConstraint(String string, String string2) {
        this.represents_ct.put(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string = categoryentry2.name;
            ASTNode aSTNode = this.getDomain(string);
            if (this.getCategory(string) == 1) {
                stringBuilder.append("given ");
            } else if (this.getCategory(string) == 3) {
                stringBuilder.append("find ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" : ");
            stringBuilder.append(aSTNode.toString());
            stringBuilder.append("\n");
            categoryentry2 = categoryentry2.next;
        }
        return stringBuilder.toString();
    }

    public void simplify() {
        Object object;
        int n;
        TransformSimplify transformSimplify = new TransformSimplify();
        Iterator<Map.Entry<String, ASTNode>> iterator = this.domains.entrySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.lettings_givens.size();
        for (n = 0; n < n2; ++n) {
            this.lettings_givens.addLast(transformSimplify.transform(this.lettings_givens.removeFirst()));
        }
        while (iterator.hasNext()) {
            Map.Entry<String, ASTNode> entry = iterator.next();
            ASTNode object22 = entry.getValue();
            object22 = transformSimplify.transform(object22);
            entry.setValue(object22);
            if (!CmdFlags.getUseDeleteVars() || object22.getCategory() != 0 || !object22.isFiniteSet()) continue;
            object = object22.getBounds();
            if (((Intpair)object).lower != ((Intpair)object).upper) continue;
            arrayList.add(entry.getKey());
        }
        if (CmdFlags.getUseDeleteVars() && (!CmdFlags.getUseAggregate() || CmdFlags.getAfterAggregate())) {
            for (n = 0; n < arrayList.size(); ++n) {
                ASTNode aSTNode = this.domains.get(arrayList.get((int)n)).getBoundsAST().e1.copy();
                this.assignVariable(new Identifier((String)arrayList.get(n), this), aSTNode);
            }
        }
        for (Map.Entry<String, ASTNode> entry : this.constant_matrices.entrySet()) {
            object = entry.getValue();
            object = transformSimplify.transform((ASTNode)object);
            entry.setValue((ASTNode)object);
        }
    }

    public void transform_all(TreeTransformer treeTransformer) {
        Object object;
        Iterator<Map.Entry<ASTNode, ASTNode>> iterator;
        int n = this.lettings_givens.size();
        for (int i = 0; i < n; ++i) {
            this.lettings_givens.addLast(treeTransformer.transform(this.lettings_givens.removeFirst()));
        }
        for (Map.Entry<String, ASTNode> object32 : this.domains.entrySet()) {
            iterator = object32.getValue();
            object32.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        for (Map.Entry<String, ASTNode> entry : this.constant_matrices.entrySet()) {
            iterator = entry.getValue();
            entry.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        for (Map.Entry<String, ASTNode> entry : this.deleted_matrices.entrySet()) {
            iterator = entry.getValue();
            entry.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        for (Map.Entry<String, ASTNode> entry : this.matrix_original_domain.entrySet()) {
            iterator = entry.getValue();
            entry.setValue(treeTransformer.transform((ASTNode)((Object)iterator)));
        }
        HashMap<ASTNode, ASTNode> hashMap = new HashMap<ASTNode, ASTNode>();
        for (Map.Entry entry : this.replacements.entrySet()) {
            ASTNode aSTNode = treeTransformer.transform((ASTNode)entry.getKey());
            object = treeTransformer.transform((ASTNode)entry.getValue());
            hashMap.put(aSTNode, (ASTNode)object);
        }
        this.replacements = hashMap;
        HashMap<Object, ASTNode> hashMap2 = new HashMap<Object, ASTNode>();
        for (Map.Entry<ASTNode, ASTNode> entry : this.replacements_domains.entrySet()) {
            object = treeTransformer.transform(entry.getKey());
            ASTNode aSTNode = treeTransformer.transform(entry.getValue());
            hashMap2.put(object, aSTNode);
        }
        this.replacements_domains = hashMap2;
        HashMap<ASTNode, Integer> hashMap3 = new HashMap<ASTNode, Integer>();
        for (Map.Entry entry : this.replacements_category.entrySet()) {
            ASTNode aSTNode = treeTransformer.transform((ASTNode)entry.getKey());
            hashMap3.put(aSTNode, (Integer)entry.getValue());
        }
        this.replacements_category = hashMap3;
    }

    public void substitute(ASTNode aSTNode, ASTNode aSTNode2) {
        ReplaceASTNode replaceASTNode = new ReplaceASTNode(aSTNode, aSTNode2);
        for (Map.Entry<String, ASTNode> object : this.domains.entrySet()) {
            ASTNode n = object.getValue();
            object.setValue(replaceASTNode.transform(n));
        }
        for (Map.Entry<String, ASTNode> entry : this.constant_matrices.entrySet()) {
            ASTNode aSTNode3 = entry.getValue();
            entry.setValue(replaceASTNode.transform(aSTNode3));
        }
        int n = this.lettings_givens.size();
        for (int i = 0; i < n; ++i) {
            ASTNode aSTNode4 = this.lettings_givens.removeFirst();
            ASTNode aSTNode5 = aSTNode4.getChild(0);
            aSTNode4 = replaceASTNode.transform(aSTNode4);
            aSTNode4.setChild(0, aSTNode5);
            this.lettings_givens.addLast(aSTNode4);
        }
    }

    public boolean typecheck() {
        for (String string : this.domains.keySet()) {
            ASTNode aSTNode = this.domains.get(string);
            if (!(aSTNode instanceof Domain)) {
                CmdFlags.println("ERROR: Found " + aSTNode + " when expecting domain for symbol " + string);
                return false;
            }
            if (!aSTNode.typecheck(this)) {
                return false;
            }
            if (this.getCategory(string) != 3) continue;
            if (aSTNode instanceof MatrixDomain) {
                for (int i = 3; i < aSTNode.numChildren(); ++i) {
                    if (aSTNode.getChild(i) instanceof MatrixDomain || aSTNode.getChild(i).isFiniteSet()) continue;
                    CmdFlags.println("ERROR: Found " + aSTNode.getChild(i) + " when expecting finite integer domain for indices of matrix variable " + string);
                    return false;
                }
                if (aSTNode.getChild(0).isFiniteSet()) continue;
                CmdFlags.println("ERROR: Found " + aSTNode.getChild(0) + " when expecting finite integer domain for decision variable " + string);
                return false;
            }
            if (aSTNode instanceof HoleyMatrixDomain || aSTNode.isFiniteSet()) continue;
            CmdFlags.println("ERROR: Found " + aSTNode + " when expecting finite integer domain for decision variable " + string);
            return false;
        }
        return this.checkConstantMatrices();
    }

    public void deleteSymbol(String string) {
        assert (this.category.containsKey(string));
        categoryentry categoryentry2 = this.category.get(string);
        if (categoryentry2.prev != null) {
            categoryentry2.prev.next = categoryentry2.next;
        } else {
            this.category_first = categoryentry2.next;
        }
        if (categoryentry2.next != null) {
            categoryentry2.next.prev = categoryentry2.prev;
        } else {
            this.category_last = categoryentry2.prev;
        }
        this.category.remove(string);
        if (this.domains.containsKey(string)) {
            this.domains.remove(string);
        }
        if (this.constant_matrices.containsKey(string)) {
            this.constant_matrices.remove(string);
        }
    }

    public void deleteMatrix(String string) {
        assert (this.category.containsKey(string));
        categoryentry categoryentry2 = this.category.get(string);
        if (categoryentry2.prev != null) {
            categoryentry2.prev.next = categoryentry2.next;
        } else {
            this.category_first = categoryentry2.next;
        }
        if (categoryentry2.next != null) {
            categoryentry2.next.prev = categoryentry2.prev;
        } else {
            this.category_last = categoryentry2.prev;
        }
        this.category.remove(string);
        assert (this.domains.containsKey(string));
        this.deleted_matrices.put(string, this.domains.get(string));
        this.domains.remove(string);
    }

    public String minionReduceDomainsLevel() {
        String string = "SACBounds";
        int n = 0;
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            long l;
            ArrayList<Intpair> arrayList;
            if ((categoryentry2.cat == 3 || categoryentry2.cat == 10) && (arrayList = this.domains.get(categoryentry2.name).getIntervalSet()).size() > 0 && (l = arrayList.get((int)(arrayList.size() - 1)).upper - arrayList.get((int)0).lower + 1L) > (long)CmdFlags.getBoundVarThreshold()) {
                if (l > (long)(CmdFlags.getBoundVarThreshold() * 5)) {
                    string = "GAC";
                } else if (l > (long)CmdFlags.getBoundVarThreshold()) {
                    ++n;
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        if (n > 5) {
            string = "GAC";
        }
        return string;
    }

    private void mangle_before_serialization() {
        this.category_list = new ArrayList();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            this.category_list.add(categoryentry2);
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            categoryentry2.prev = null;
            categoryentry2 = categoryentry2.next;
            if (categoryentry2 == null) continue;
            categoryentry2.prev.next = null;
        }
    }

    public void unmangle_after_serialization() {
        if (this.category_list.size() > 0) {
            this.category_first = this.category_list.get(0);
            this.category_last = this.category_list.get(this.category_list.size() - 1);
        } else {
            this.category_first = null;
            this.category_last = null;
        }
        for (int i = 0; i < this.category_list.size(); ++i) {
            this.category_list.get((int)i).prev = i > 0 ? this.category_list.get(i - 1) : null;
            this.category_list.get((int)i).next = i < this.category_list.size() - 1 ? this.category_list.get(i + 1) : null;
        }
        this.category_list = null;
    }

    protected void serialize() {
        Model model = this.m;
        this.m = null;
        this.mangle_before_serialization();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CmdFlags.auxfile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            CmdFlags.println(Thread.currentThread().getStackTrace());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                System.out.println(stackTraceElement);
            }
            CmdFlags.println("WARNING: Failed to serialise: " + exception);
        }
        this.unmangle_after_serialization();
        this.m = model;
    }

    public void toMinion(StringBuilder stringBuilder) {
        assert (this.m.global_symbols == this);
        if (!CmdFlags.getRunSolver()) {
            this.serialize();
        }
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                this.output_variable(stringBuilder, categoryentry2.name, (Domain)this.domains.get(categoryentry2.name));
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 10) {
                this.output_variable(stringBuilder, categoryentry2.name, (Domain)this.domains.get(categoryentry2.name));
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string = categoryentry2.name;
            if (categoryentry2.cat == 11) {
                int n;
                int n2;
                Serializable serializable;
                if (((MatrixDomain)this.domains.get(string)).getMDIndexDomains().size() == 2) {
                    stringBuilder.append("**TUPLELIST**\n");
                    stringBuilder.append(string + " ");
                    serializable = this.constant_matrices.get(string);
                    stringBuilder.append(((ASTNode)serializable).numChildren() - 1 + " ");
                    stringBuilder.append(((ASTNode)serializable).getChild(1).numChildren() - 1 + "\n");
                    for (n2 = 1; n2 < ((ASTNode)serializable).numChildren(); ++n2) {
                        ASTNode aSTNode = ((ASTNode)serializable).getChild(n2);
                        assert (aSTNode instanceof CompoundMatrix);
                        for (int i = 1; i < aSTNode.numChildren(); ++i) {
                            ASTNode aSTNode2 = aSTNode.getChild(i);
                            aSTNode2.toMinion(stringBuilder, false);
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append("**VARIABLES**\n");
                }
                serializable = this.getConstantMatrixSize(this.constant_matrices.get(string));
                n2 = 0;
                for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                    if (((ArrayList)serializable).get(n) != 0L) continue;
                    n2 = 1;
                }
                if (n2 == 0) {
                    stringBuilder.append("ALIAS " + string + "[");
                    for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                        stringBuilder.append(((ArrayList)serializable).get(n));
                        if (n >= ((ArrayList)serializable).size() - 1) continue;
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("]=");
                    this.constant_matrices.get(string).toMinion(stringBuilder, false);
                    stringBuilder.append("\n");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public void printPrintStmt(StringBuilder stringBuilder) {
        stringBuilder.append("PRINT[");
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == 3) {
                stringBuilder.append(string);
                if (this.getDomain(string2) instanceof SimpleDomain) {
                    stringBuilder.append("[");
                    stringBuilder.append(string2);
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append(string2);
                }
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
        if (this.m.objective != null) {
            stringBuilder.append("[");
            stringBuilder.append(this.m.objective.getChild(0).toString());
            stringBuilder.append("]");
        }
        stringBuilder.append("]\n");
    }

    public void printAllVariables(StringBuilder stringBuilder, int n) {
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == n) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    public boolean printAllVariablesFlatzinc(StringBuilder stringBuilder, int n) {
        String string = "";
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            String string2 = categoryentry2.name;
            if (categoryentry2.cat == n) {
                stringBuilder.append(string);
                if (this.getDomain(string2).equals(new BooleanDomain()) || this.getDomain(string2).equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) {
                    if (this.boolvar_int.containsKey(string2)) {
                        stringBuilder.append(string2 + "_INTEGER");
                    } else if (this.boolvar_bool.containsKey(string2)) {
                        stringBuilder.append(string2 + "_BOOL");
                    } else assert (false) : "Something strange has happened: var with name " + string2 + " is apparently not used anywhere.";
                } else {
                    stringBuilder.append(string2);
                }
                bl = true;
                string = ",";
            }
            categoryentry2 = categoryentry2.next;
        }
        return bl;
    }

    private void output_variable(StringBuilder stringBuilder, String string, Domain domain) {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain instanceof BooleanDomain && domain.containsValue(0L) && domain.containsValue(1L)) {
            stringBuilder.append("BOOL " + string + " #" + string2 + "\n");
        } else if (domain instanceof SimpleDomain || domain instanceof BooleanDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() > 0) {
                long l = arrayList.get((int)(arrayList.size() - 1)).upper - arrayList.get((int)0).lower + 1L;
                if (CmdFlags.getUseBoundVars() && l > (long)CmdFlags.getBoundVarThreshold()) {
                    stringBuilder.append("BOUND " + string + " #" + string2 + "\n");
                } else {
                    stringBuilder.append("DISCRETE " + string + " #" + string2 + "\n");
                }
                stringBuilder.append("{" + arrayList.get((int)0).lower + ".." + arrayList.get((int)(arrayList.size() - 1)).upper + "}\n");
                if (arrayList.size() > 1) {
                    stringBuilder.append("**CONSTRAINTS**\n");
                    stringBuilder.append("w-inintervalset(" + string + ", [");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        stringBuilder.append(arrayList.get((int)i).lower);
                        stringBuilder.append(",");
                        stringBuilder.append(arrayList.get((int)i).upper);
                        if (i >= arrayList.size() - 1) continue;
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("])\n");
                    stringBuilder.append("**VARIABLES**\n");
                }
            } else {
                stringBuilder.append("DISCRETE " + string + " #" + string2 + "\n");
                stringBuilder.append("{0..0}  #  This is an empty domain. Faking that by using 0..0 and the false() constraint below.\n");
                stringBuilder.append("**CONSTRAINTS**\n");
                stringBuilder.append("false()\n");
                stringBuilder.append("**VARIABLES**\n");
            }
        } else assert (false);
    }

    public void toDominion(StringBuilder stringBuilder) {
        TransformSimplify transformSimplify = new TransformSimplify();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            int n;
            Serializable serializable;
            String string = categoryentry2.name;
            Domain domain = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 1) {
                stringBuilder.append("given " + string);
                if (domain instanceof MatrixDomain) {
                    serializable = (MatrixDomain)domain;
                    stringBuilder.append("[");
                    for (n = 3; n < ((ASTNode)serializable).numChildren(); ++n) {
                        assert (((ASTNode)serializable).getChild((int)n).getBoundsAST().e1.equals(new NumberConstant(0L)));
                        ASTNode aSTNode = BinOp.makeBinOp("+", ((ASTNode)serializable).getChild((int)n).getBoundsAST().e2, new NumberConstant(1L));
                        aSTNode = transformSimplify.transform(aSTNode);
                        aSTNode.toDominionParam(stringBuilder);
                        if (n >= ((ASTNode)serializable).numChildren() - 1) continue;
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("]");
                    domain = (Domain)((ASTNode)serializable).getChild(0);
                }
                stringBuilder.append(": int {");
                domain.toDominionParam(stringBuilder);
                stringBuilder.append("}\n");
            } else if (categoryentry2.cat == 3 || categoryentry2.cat == 10) {
                this.output_variable_dominion(stringBuilder, string, domain);
            } else if (categoryentry2.cat == 11) {
                serializable = this.getConstantMatrixSize(this.constant_matrices.get(string));
                stringBuilder.append("define " + string + "[");
                for (n = 0; n < ((ArrayList)serializable).size(); ++n) {
                    stringBuilder.append("..");
                    if (n >= ((ArrayList)serializable).size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("] = ");
                StringBuilder stringBuilder2 = new StringBuilder();
                this.constant_matrices.get(string).toDominionParam(stringBuilder2);
                stringBuilder.append(stringBuilder2.toString() + "\n");
            } else {
                System.out.println("WARNING: Found something in symbol table that cannot be output to Dominion: " + string);
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    private void output_variable_dominion(StringBuilder stringBuilder, String string, Domain domain) {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain instanceof BooleanDomain) {
            stringBuilder.append("find " + string + " : bool $" + string2 + "\n");
        } else if (domain instanceof SimpleDomain) {
            stringBuilder.append("find " + string + " : int {");
            domain.toDominionParam(stringBuilder);
            stringBuilder.append("} $" + string2 + "\n");
        } else if (domain instanceof MatrixDomain) {
            int n;
            stringBuilder.append("dim " + string + "[");
            ArrayList<ASTNode> arrayList = domain.getChildren();
            ASTNode aSTNode = arrayList.get(0);
            ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>(arrayList.subList(3, arrayList.size()));
            ArrayList<ASTNode> arrayList3 = domain.getChild(1).getChildren();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>();
            if (domain.getChild(2) instanceof And) {
                arrayList4.addAll(domain.getChild(2).getChildren());
            } else if (!domain.getChild(2).equals(new BooleanConstant(true))) {
                arrayList4.add(domain.getChild(2));
            }
            assert (arrayList2.size() == arrayList3.size() || arrayList3.size() == 0);
            for (n = 0; n < arrayList2.size(); ++n) {
                assert (arrayList2.get((int)n).getBoundsAST().e1.equals(new NumberConstant(0L)));
                ASTNode aSTNode2 = BinOp.makeBinOp("+", arrayList2.get((int)n).getBoundsAST().e2, new NumberConstant(1L));
                TransformSimplify transformSimplify = new TransformSimplify();
                aSTNode2 = transformSimplify.transform(aSTNode2);
                aSTNode2.toDominionParam(stringBuilder);
                if (n >= arrayList2.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("] : int\n");
            if (arrayList3.size() == 0) {
                stringBuilder.append("find " + string + "[");
                for (n = 0; n < arrayList2.size(); ++n) {
                    stringBuilder.append("..");
                    if (n >= arrayList2.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("] : int {");
                aSTNode.toDominionParam(stringBuilder);
                stringBuilder.append("}\n");
            } else {
                stringBuilder.append("[ find " + string + "[");
                for (n = 0; n < arrayList3.size(); ++n) {
                    arrayList3.get(n).toDominionParam(stringBuilder);
                    if (n >= arrayList3.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]: int {");
                aSTNode.toDominionParam(stringBuilder);
                stringBuilder.append("} | ");
                for (n = 0; n < arrayList3.size(); ++n) {
                    arrayList3.get(n).toDominionParam(stringBuilder);
                    stringBuilder.append(" in {");
                    arrayList2.get(n).toDominionParam(stringBuilder);
                    stringBuilder.append("}");
                    if (n >= arrayList3.size() - 1) continue;
                    stringBuilder.append(", ");
                }
                if (arrayList4.size() > 0) {
                    stringBuilder.append(", ");
                }
                for (n = 0; n < arrayList4.size(); ++n) {
                    ((ASTNode)arrayList4.get(n)).toDominionParam(stringBuilder);
                    if (n >= arrayList4.size() - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("]\n");
            }
            if (!string2.equals("")) {
                stringBuilder.append("$ representing constraint: " + string2 + "\n");
            }
        } else assert (false);
    }

    public void markAsBoolGecode(String string) {
        this.boolvar_bool.put(string, true);
    }

    public void markAsIntGecode(String string) {
        this.boolvar_int.put(string, true);
    }

    public void toFlatzinc(StringBuilder stringBuilder) {
        ASTNode aSTNode;
        String string;
        StringBuilder stringBuilder2 = new StringBuilder();
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 3) {
                this.output_variable_flatzinc(stringBuilder, string, (Domain)aSTNode, stringBuilder2);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 10) {
                this.output_variable_flatzinc(stringBuilder, string, (Domain)aSTNode, stringBuilder2);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            if (categoryentry2.cat == 11) {
                aSTNode = this.constant_matrices.get(categoryentry2.name);
                ArrayList<Long> arrayList = this.getConstantMatrixSize(aSTNode);
                ArrayList<Long> arrayList2 = this.getConstantMatrixContents(aSTNode);
                if (arrayList.size() == 1) {
                    stringBuilder.append("array [1.." + arrayList.get(0) + "] of int: " + categoryentry2.name + " = " + arrayList2.toString() + ";\n");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if ((categoryentry2.cat == 3 || categoryentry2.cat == 10) && (aSTNode instanceof BooleanDomain || aSTNode.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) && this.boolvar_bool.containsKey(string) && this.boolvar_int.containsKey(string)) {
                stringBuilder.append("constraint bool2int(" + string + "_BOOL," + string + "_INTEGER);\n");
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    private void output_variable_flatzinc(StringBuilder stringBuilder, String string, Domain domain, StringBuilder stringBuilder2) {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain instanceof BooleanDomain || domain.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) {
            if (this.boolvar_bool.containsKey(string)) {
                stringBuilder.append("var bool: " + string + "_BOOL");
                if (this.category.get((Object)string).cat == 3 && !this.boolvar_int.containsKey(string)) {
                    stringBuilder.append("::output_var");
                }
                stringBuilder.append("; %" + string2 + "\n");
            }
            if (this.boolvar_int.containsKey(string)) {
                stringBuilder.append("var {0,1}: " + string + "_INTEGER ");
                if (this.category.get((Object)string).cat == 3) {
                    stringBuilder.append("::output_var");
                }
                stringBuilder.append("; %" + string2 + "\n");
            }
        } else if (domain instanceof SimpleDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() == 0) {
                stringBuilder.append("var 0..0 : " + string);
                if (this.category.get((Object)string).cat == 3) {
                    stringBuilder.append("::output_var");
                }
                stringBuilder.append("; % Empty domain simulated with 0..0 and bool_eq(true,false). " + string2 + "\n");
                stringBuilder2.append("constraint bool_eq(true,false);\n");
            } else {
                stringBuilder.append("var " + arrayList.get((int)0).lower + ".." + arrayList.get((int)(arrayList.size() - 1)).upper + ": " + string);
                if (this.category.get((Object)string).cat == 3) {
                    stringBuilder.append("::output_var");
                }
                stringBuilder.append("; %" + string2 + "\n");
                if (arrayList.size() > 1) {
                    stringBuilder2.append("constraint set_in(" + string + ",{");
                    for (int i = 0; i < arrayList.size(); ++i) {
                        for (long j = arrayList.get((int)i).lower; j <= arrayList.get((int)i).upper; ++j) {
                            stringBuilder2.append(j);
                            if (i >= arrayList.size() - 1 && j >= arrayList.get((int)i).upper) continue;
                            stringBuilder2.append(",");
                        }
                    }
                    stringBuilder2.append("});\n");
                }
            }
        } else assert (false);
    }

    public void toMinizinc(StringBuilder stringBuilder) {
        ASTNode aSTNode;
        String string;
        if (!CmdFlags.getRunSolver()) {
            this.serialize();
        }
        categoryentry categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 3) {
                this.output_variable_minizinc(stringBuilder, string, (Domain)aSTNode);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 10) {
                this.output_variable_minizinc(stringBuilder, string, (Domain)aSTNode);
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            if (categoryentry2.cat == 11) {
                aSTNode = this.constant_matrices.get(categoryentry2.name);
                ArrayList<Long> arrayList = this.getConstantMatrixSize(aSTNode);
                ArrayList<Long> arrayList2 = this.getConstantMatrixContents(aSTNode);
                if (arrayList.size() == 1) {
                    stringBuilder.append("array [1.." + arrayList.get(0) + "] of int: " + categoryentry2.name + " = " + arrayList2.toString() + ";\n");
                }
            }
            categoryentry2 = categoryentry2.next;
        }
        categoryentry2 = this.category_first;
        while (categoryentry2 != null) {
            string = categoryentry2.name;
            aSTNode = (Domain)this.getDomain(string);
            if ((categoryentry2.cat == 3 || categoryentry2.cat == 10) && (aSTNode instanceof BooleanDomain || aSTNode.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) && this.boolvar_bool.containsKey(string) && this.boolvar_int.containsKey(string)) {
                stringBuilder.append("constraint bool2int(" + string + "_BOOL) = " + string + "_INTEGER;\n");
            }
            categoryentry2 = categoryentry2.next;
        }
    }

    private void output_variable_minizinc(StringBuilder stringBuilder, String string, Domain domain) {
        String string2 = this.represents_ct.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (domain instanceof BooleanDomain || this.getDomain(string).equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) {
            if (this.boolvar_bool.containsKey(string)) {
                stringBuilder.append("var bool: " + string + "_BOOL; %" + string2 + "\n");
            }
            if (this.boolvar_int.containsKey(string)) {
                stringBuilder.append("var {0,1}: " + string + "_INTEGER; %" + string2 + "\n");
            }
        } else if (domain instanceof SimpleDomain) {
            ArrayList<Intpair> arrayList = domain.getIntervalSet();
            if (arrayList.size() > 1) {
                String string3 = this.newAuxId();
                stringBuilder.append("set of int : " + string3 + " = ");
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuilder.append(arrayList.get((int)i).lower + ".." + arrayList.get((int)i).upper);
                    if (i >= arrayList.size() - 1) continue;
                    stringBuilder.append(" union ");
                }
                stringBuilder.append(";\n");
                stringBuilder.append("var " + string3 + " : " + string);
            } else {
                stringBuilder.append("var " + arrayList.get((int)0).lower + ".." + arrayList.get((int)0).upper + ": " + string);
            }
            stringBuilder.append("; %" + string2 + "\n");
        } else assert (false);
    }

    public void showVariablesMinizinc(StringBuilder stringBuilder) {
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            String string = categoryentry2.name;
            Domain domain = (Domain)this.getDomain(string);
            if (categoryentry2.cat == 3) {
                stringBuilder.append("show(");
                if (domain instanceof BooleanDomain || domain.equals(new IntegerDomain(new Range(new NumberConstant(0L), new NumberConstant(1L))))) {
                    if (this.boolvar_bool.containsKey(string)) {
                        stringBuilder.append(string + "_BOOL");
                    } else if (this.boolvar_int.containsKey(string)) {
                        stringBuilder.append(string + "_INTEGER");
                    }
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append("),\" \",");
                bl = true;
            }
            categoryentry2 = categoryentry2.next;
        }
        if (bl) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
    }

    public void markAsDirectSAT(String string) {
        if (this.directvar_sat == null) {
            this.directvar_sat = new HashSet();
        }
        this.directvar_sat.add(string);
    }

    public boolean isDirectSAT(String string) {
        if (this.directvar_sat == null) {
            return false;
        }
        return this.directvar_sat.contains(string);
    }

    public void writeVarDomainsAsJSON(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                if (bl) {
                    stringBuilder.append(",");
                } else {
                    bl = true;
                }
                stringBuilder.append("\n");
                ASTNode aSTNode = this.getDomain(categoryentry2.name);
                stringBuilder.append("{\n\"name\": \"" + this.escapeVar(categoryentry2.name) + "\",\n");
                stringBuilder.append("\"domain\": [");
                ArrayList<Intpair> arrayList = aSTNode.getIntervalSet();
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringBuilder.append("[" + arrayList.get((int)i).lower + ", " + arrayList.get((int)i).upper + "]");
                    if (i >= arrayList.size() - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append("]\n}");
            }
            categoryentry2 = categoryentry2.next;
        }
        stringBuilder.append("]");
    }

    public void writeVarListAsJSON(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                if (bl) {
                    stringBuilder.append(",");
                } else {
                    bl = true;
                }
                stringBuilder.append("\"" + this.escapeVar(categoryentry2.name) + "\"");
            }
            categoryentry2 = categoryentry2.next;
        }
        stringBuilder.append("]");
    }

    String escapeVar(String string) {
        return "$" + string;
    }

    public static String unescapeVar(String string) {
        return string.replaceAll("^\\$(.*)$", "$1");
    }

    public ArrayList<String> getVarNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        categoryentry categoryentry2 = this.category_first;
        boolean bl = false;
        while (categoryentry2 != null) {
            if (categoryentry2.cat == 3) {
                arrayList.add(categoryentry2.name);
            }
            categoryentry2 = categoryentry2.next;
        }
        return arrayList;
    }
}

