/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.expression.ASTNode;
import savilerow.expression.Container;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.model.SymbolTable;

public class ComprehensionMatrix
extends ASTNode {
    public static final long serialVersionUID = 1L;

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2) {
        super(aSTNode, new Container(arrayList), aSTNode2, new IntegerDomain(new Range(new NumberConstant(1L), null)));
    }

    public ComprehensionMatrix(ASTNode aSTNode, ArrayList<ASTNode> arrayList, ASTNode aSTNode2, ASTNode aSTNode3) {
        super(aSTNode, new Container(arrayList), aSTNode2, aSTNode3);
    }

    @Override
    public ASTNode copy() {
        return new ComprehensionMatrix(this.getChild(0), this.getChild(1).getChildren(), this.getChild(2), this.getChild(3));
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return false;
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }

    @Override
    public int getDimension() {
        return 1 + this.getChild(0).getDimension();
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!(this.getChild(0).typecheck(symbolTable) && this.getChild(1).typecheck(symbolTable) && this.getChild(2).typecheck(symbolTable) && this.getChild(3).typecheck(symbolTable))) {
            return false;
        }
        if (this.getChild(1).getCategory() > 2) {
            System.out.println("ERROR: In comprehension matrix: " + this);
            System.out.println("ERROR: Decision variable in domain.");
            return false;
        }
        if (this.getChild(2).getCategory() > 2) {
            System.out.println("ERROR: In comprehension matrix: " + this);
            System.out.println("ERROR: Decision variable in condition.");
            return false;
        }
        return true;
    }

    @Override
    public ASTNode getDomainForId(ASTNode aSTNode) {
        for (ASTNode aSTNode2 : this.getChild(1).getChildren()) {
            if (!aSTNode2.getChild(0).equals(aSTNode)) continue;
            return aSTNode2.getChild(1);
        }
        return this.getParent().getDomainForId(aSTNode);
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            this.getChild(1).getChild(i).toDominionParam(stringBuilder);
            stringBuilder.append(", ");
        }
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("]");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("[");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            this.getChild(1).getChild(i).toDominionParam(stringBuilder);
            stringBuilder.append(", ");
        }
        this.getChild(2).toDominionParam(stringBuilder);
        stringBuilder.append("]");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.getChild(0));
        stringBuilder.append("|");
        for (int i = 0; i < this.getChild(1).numChildren(); ++i) {
            stringBuilder.append(this.getChild(1).getChild(i).toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append(this.getChild(2));
        stringBuilder.append(" ;");
        stringBuilder.append(this.getChild(3));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

