/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Intpair;
import savilerow.expression.Less;
import savilerow.expression.LexLessEqual;
import savilerow.expression.MatrixBinOp;

public class LexLess
extends MatrixBinOp {
    public static final long serialVersionUID = 1L;

    public LexLess(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new LexLess(this.getChild(0), this.getChild(1));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if ((this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) && (this.getChild(1) instanceof CompoundMatrix || this.getChild(1) instanceof EmptyMatrix)) {
            Intpair intpair;
            Intpair intpair2;
            ArrayList<ASTNode> arrayList = this.getChild(0).getChildren();
            arrayList.remove(0);
            ArrayList<ASTNode> arrayList2 = this.getChild(1).getChildren();
            arrayList2.remove(0);
            if (arrayList.size() < arrayList2.size()) {
                while (arrayList2.size() > arrayList.size()) {
                    arrayList2.remove(arrayList2.size() - 1);
                }
                return new LexLessEqual(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
            }
            if (arrayList.size() > arrayList2.size()) {
                while (arrayList.size() > arrayList2.size()) {
                    arrayList.remove(arrayList.size() - 1);
                }
                return new LexLess(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
            }
            boolean bl = false;
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n).equals(arrayList2.get(n))) {
                    arrayList.remove(n);
                    arrayList2.remove(n);
                    bl = true;
                    continue;
                }
                ++n;
            }
            while (arrayList.size() >= 1) {
                intpair2 = arrayList.get(arrayList.size() - 1).getBounds();
                intpair = arrayList2.get(arrayList2.size() - 1).getBounds();
                if (intpair2.lower < intpair.upper) break;
                arrayList.remove(arrayList.size() - 1);
                arrayList2.remove(arrayList2.size() - 1);
                bl = true;
            }
            if (arrayList.size() == 0 && arrayList2.size() == 0) {
                return new BooleanConstant(false);
            }
            intpair2 = arrayList.get(0).getBounds();
            intpair = arrayList2.get(0).getBounds();
            if (intpair2.upper < intpair.lower) {
                return new BooleanConstant(true);
            }
            if (intpair2.lower > intpair.upper) {
                return new BooleanConstant(false);
            }
            if (arrayList.size() == 1) {
                return new Less(arrayList.get(0), arrayList2.get(0));
            }
            if (bl) {
                return new LexLess(CompoundMatrix.makeCompoundMatrix(arrayList), CompoundMatrix.makeCompoundMatrix(arrayList2));
            }
        }
        return this;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (bl);
        stringBuilder.append("lexless(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("lexless(flatten(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append("),flatten(");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append("))");
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + " <lex " + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint array_int_lt(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("lex_less(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }
}

