/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.util.ArrayList;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.CompoundMatrix;
import savilerow.expression.ComprehensionForall;
import savilerow.expression.ComprehensionMatrix;
import savilerow.expression.EmptyMatrix;
import savilerow.expression.Identifier;
import savilerow.expression.Indices;
import savilerow.expression.IntegerDomain;
import savilerow.expression.Intpair;
import savilerow.expression.MatrixDeref;
import savilerow.expression.MatrixDomain;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.expression.Range;
import savilerow.expression.SafeMatrixDeref;
import savilerow.expression.Unpack;
import savilerow.model.SymbolTable;

public class MatrixSlice
extends ASTNode {
    public static final long serialVersionUID = 1L;
    private SymbolTable global_symbols;

    public MatrixSlice(ASTNode aSTNode, ArrayList<ASTNode> arrayList, SymbolTable symbolTable) {
        ArrayList<ASTNode> arrayList2 = new ArrayList<ASTNode>();
        arrayList2.add(aSTNode);
        arrayList2.addAll(arrayList);
        this.setChildren(arrayList2);
        this.global_symbols = symbolTable;
    }

    @Override
    public ASTNode copy() {
        ASTNode aSTNode = this.getChild(0);
        ArrayList<ASTNode> arrayList = this.getChildren();
        arrayList.remove(0);
        return new MatrixSlice(aSTNode, arrayList, this.global_symbols);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        for (ASTNode aSTNode : this.getChildren()) {
            if (aSTNode.typecheck(symbolTable)) continue;
            return false;
        }
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() <= 2) continue;
        }
        if (this.numChildren() - 1 != this.getChild(0).getDimension()) {
            CmdFlags.println("ERROR: Number of indices in matrix slice does not match dimensions of matrix:");
            CmdFlags.println("ERROR: " + this);
            return false;
        }
        return true;
    }

    @Override
    public ASTNode simplify() {
        Object object;
        if (this.numChildren() == 2 && this.getChild(1) instanceof Unpack) {
            ArrayList<ASTNode> arrayList = ((Unpack)this.getChild(1)).items();
            if (arrayList != null) {
                return new MatrixSlice(this.getChild(0), arrayList, this.global_symbols);
            }
            return this;
        }
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (this.getChild(i).getCategory() > 0) {
                bl = false;
            }
            if (this.getChild(i).getCategory() != 3) continue;
            bl2 = true;
        }
        if (bl) {
            SymbolTable symbolTable;
            if (this.getChild(0) instanceof CompoundMatrix || this.getChild(0) instanceof EmptyMatrix) {
                ArrayList<ASTNode> arrayList = this.getChildren();
                arrayList.remove(0);
                ASTNode aSTNode = MatrixSlice.evaluateSlice(this.getChild(0), arrayList);
                return aSTNode == null ? this : aSTNode;
            }
            if (this.getChild(0) instanceof Identifier && (symbolTable = ((Identifier)this.getChild((int)0)).global_symbols).getCategory((String)(object = this.getChild(0).toString())) == 0) {
                ASTNode aSTNode = symbolTable.getConstantMatrix((String)object);
                ArrayList<ASTNode> arrayList = this.getChildren();
                arrayList.remove(0);
                ASTNode aSTNode2 = MatrixSlice.evaluateSlice(aSTNode, arrayList);
                return aSTNode2 == null ? this : aSTNode2;
            }
        }
        if (bl2) {
            ASTNode aSTNode;
            ArrayList<ASTNode> arrayList = this.list();
            object = this.list();
            for (int i = 1; i < this.numChildren(); ++i) {
                if (this.getChild(i).isSet()) {
                    aSTNode = new Identifier(this.global_symbols.newAuxId(), this.global_symbols);
                    arrayList.add(aSTNode);
                    ((ArrayList)object).add(aSTNode);
                    continue;
                }
                arrayList.add(null);
                ((ArrayList)object).add((ASTNode)this.getChild(i));
            }
            ASTNode aSTNode3 = new SafeMatrixDeref(this.getChild(0), (ArrayList<ASTNode>)object);
            aSTNode = new Indices(this.getChild(0));
            for (int i = this.numChildren() - 1; i >= 1; --i) {
                if (!this.getChild(i).isSet()) continue;
                MatrixDeref matrixDeref = new MatrixDeref(aSTNode, this.list(new NumberConstant(i)));
                aSTNode3 = new ComprehensionMatrix(aSTNode3, this.list(new ComprehensionForall(arrayList.get(i - 1), matrixDeref)), (ASTNode)new BooleanConstant(true), (ASTNode)matrixDeref);
            }
            return aSTNode3;
        }
        return this;
    }

    public static ASTNode evaluateSlice(ASTNode aSTNode, ArrayList<ASTNode> arrayList) {
        long l;
        if (arrayList.size() == 0) {
            assert (!(aSTNode instanceof CompoundMatrix) && !(aSTNode instanceof EmptyMatrix));
            return aSTNode;
        }
        ASTNode aSTNode2 = arrayList.get(0);
        if (aSTNode instanceof EmptyMatrix) {
            ASTNode aSTNode3 = aSTNode.getChild(0);
            ArrayList<ASTNode> arrayList2 = aSTNode3.getChildren();
            arrayList2.remove(0);
            arrayList2.remove(0);
            arrayList2.remove(0);
            assert (arrayList2.size() == arrayList.size());
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                if (arrayList.get(i).equals(new IntegerDomain(new Range(null, null)))) continue;
                arrayList2.remove(i);
            }
            return new EmptyMatrix(new MatrixDomain(aSTNode.getChild(0).getChild(0), arrayList2));
        }
        if (aSTNode2.equals(new IntegerDomain(new Range(null, null)))) {
            ArrayList<ASTNode> arrayList3 = new ArrayList<ASTNode>();
            ArrayList<ASTNode> arrayList4 = new ArrayList<ASTNode>(arrayList);
            arrayList4.remove(0);
            for (int i = 1; i < aSTNode.numChildren(); ++i) {
                ASTNode aSTNode4 = MatrixSlice.evaluateSlice(aSTNode.getChild(i), arrayList4);
                if (aSTNode4 == null) {
                    return null;
                }
                arrayList3.add(aSTNode4);
            }
            return new CompoundMatrix(aSTNode.getChild(0), arrayList3);
        }
        ArrayList<Long> arrayList5 = aSTNode instanceof CompoundMatrix ? aSTNode.getChild(0).getValueSet() : (aSTNode instanceof EmptyMatrix ? new ArrayList() : null);
        int n = arrayList5.indexOf(l = aSTNode2.getValue());
        if (n == -1) {
            return null;
        }
        ArrayList<ASTNode> arrayList6 = new ArrayList<ASTNode>(arrayList);
        arrayList6.remove(0);
        return MatrixSlice.evaluateSlice(aSTNode.getChild(n + 1), arrayList6);
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        assert (!bl);
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toMinion(stringBuilder, false);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        this.toDominionParam(stringBuilder);
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append("[");
        for (int i = 1; i < this.numChildren(); ++i) {
            this.getChild(i).toDominionParam(stringBuilder);
            if (i >= this.numChildren() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
    }

    @Override
    public Intpair getBounds() {
        return this.getChild(0).getBounds();
    }

    @Override
    public PairASTNode getBoundsAST() {
        return this.getChild(0).getBoundsAST();
    }

    @Override
    public int getDimension() {
        int n = 0;
        for (int i = 1; i < this.numChildren(); ++i) {
            if (!this.getChild(i).isSet()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public String toString() {
        String string = this.getChild(0).toString() + "[";
        for (int i = 1; i < this.numChildren(); ++i) {
            string = string + this.getChild(i);
            if (i >= this.numChildren() - 1) continue;
            string = string + ",";
        }
        return string + "]";
    }

    @Override
    public boolean isRelation() {
        return this.getChild(0).isRelation();
    }

    @Override
    public boolean isNumerical() {
        return this.getChild(0).isNumerical();
    }
}

