/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import java.math.BigInteger;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BinOp;
import savilerow.expression.Divide;
import savilerow.expression.Intpair;
import savilerow.expression.Max;
import savilerow.expression.Min;
import savilerow.expression.NumberConstant;
import savilerow.expression.PairASTNode;
import savilerow.model.Sat;

public class Mod
extends BinOp {
    public static final long serialVersionUID = 1L;

    public Mod(ASTNode aSTNode, ASTNode aSTNode2) {
        super(aSTNode, aSTNode2);
    }

    @Override
    public ASTNode copy() {
        return new Mod(this.getChild(0), this.getChild(1));
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant() && this.getChild(1).isConstant()) {
            long l = this.getChild(0).getValue();
            long l2 = this.getChild(1).getValue();
            if (l2 == 0L) {
                return this;
            }
            return new NumberConstant(this.mod(l, l2));
        }
        return this;
    }

    public long mod(long l, long l2) {
        return Intpair.BigIntegerToLong(BigInteger.valueOf(l).subtract(BigInteger.valueOf(Divide.div(l, l2)).multiply(BigInteger.valueOf(l2))));
    }

    @Override
    public Intpair getBounds() {
        Intpair intpair = this.getChild(0).getBounds();
        Intpair intpair2 = this.getChild(1).getBounds();
        if (intpair2.lower >= 0L) {
            --intpair2.upper;
            intpair2.lower = 0L;
            return this.lookupBounds(intpair2);
        }
        if (intpair2.upper <= 0L) {
            ++intpair2.lower;
            intpair2.upper = 0L;
            return this.lookupBounds(intpair2);
        }
        --intpair2.upper;
        ++intpair2.lower;
        return this.lookupBounds(intpair2);
    }

    @Override
    public PairASTNode getBoundsAST() {
        PairASTNode pairASTNode = this.getChild(1).getBoundsAST();
        pairASTNode.e1 = BinOp.makeBinOp("+", pairASTNode.e1, new NumberConstant(1L));
        pairASTNode.e2 = BinOp.makeBinOp("-", pairASTNode.e2, new NumberConstant(1L));
        pairASTNode.e1 = new Min(new NumberConstant(0L), pairASTNode.e1);
        pairASTNode.e2 = new Max(new NumberConstant(0L), pairASTNode.e2);
        return pairASTNode;
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public void toMinionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("modulo(");
        this.getChild(0).toMinion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toMinion(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toMinion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("modulo(");
        this.getChild(0).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toDominion(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toDominion(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("Mod(");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(",");
        this.getChild(1).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        assert (this.getCategory() <= 2);
        this.toDominionParam(stringBuilder);
    }

    @Override
    public String toString() {
        return "(" + this.getChild(0) + "%" + this.getChild(1) + ")";
    }

    @Override
    public void toFlatzincWithAuxVar(StringBuilder stringBuilder, ASTNode aSTNode) {
        stringBuilder.append("constraint int_mod(");
        this.getChild(0).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        this.getChild(1).toFlatzinc(stringBuilder, false);
        stringBuilder.append(",");
        aSTNode.toFlatzinc(stringBuilder, false);
        stringBuilder.append(");");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(");
        this.getChild(0).toMinizinc(stringBuilder, false);
        stringBuilder.append(" mod ");
        this.getChild(1).toMinizinc(stringBuilder, false);
        stringBuilder.append(")");
    }

    @Override
    public void toSATWithAuxVar(Sat sat, ASTNode aSTNode) throws IOException {
        sat.ternaryEncoding(this, aSTNode);
    }

    @Override
    public boolean test(long l, long l2, long l3) {
        return this.mod(l, l2) == l3;
    }

    @Override
    public long func(long l, long l2) {
        return this.mod(l, l2);
    }
}

