/*
 * Decompiled with CFR 0.152.
 */
package savilerow.expression;

import java.io.IOException;
import savilerow.CmdFlags;
import savilerow.expression.ASTNode;
import savilerow.expression.BooleanConstant;
import savilerow.expression.Identifier;
import savilerow.expression.SATLiteral;
import savilerow.expression.Unary;
import savilerow.model.Sat;
import savilerow.model.SymbolTable;

public class Negate
extends Unary {
    public static final long serialVersionUID = 1L;

    public Negate(ASTNode aSTNode) {
        super(aSTNode);
    }

    @Override
    public ASTNode copy() {
        return new Negate(this.getChild(0));
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public ASTNode simplify() {
        if (this.getChild(0).isConstant()) {
            if (this.getChild(0).getValue() == 0L) {
                return new BooleanConstant(true);
            }
            return new BooleanConstant(false);
        }
        if (this.getChild(0).isNegatable()) {
            return this.getChild(0).negation();
        }
        return this;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public ASTNode negation() {
        return this.getChild(0);
    }

    @Override
    public boolean toFlatten(boolean bl) {
        return !CmdFlags.getMiniontrans() || !(this.getChild(0) instanceof Identifier);
    }

    @Override
    public boolean typecheck(SymbolTable symbolTable) {
        if (!this.getChild(0).typecheck(symbolTable)) {
            return false;
        }
        if (!this.getChild(0).isRelation()) {
            System.out.println("ERROR: Boolean negation contains numerical expression:" + this);
            return false;
        }
        return true;
    }

    @Override
    public void toMinion(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append("w-literal(");
            this.getChild(0).toMinion(stringBuilder, false);
            stringBuilder.append(",0)");
        } else {
            stringBuilder.append("!");
            this.getChild(0).toMinion(stringBuilder, false);
        }
    }

    @Override
    public void toFlatzinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("constraint bool_eq(");
        this.getChild(0).toFlatzinc(stringBuilder, true);
        stringBuilder.append(",false);");
    }

    @Override
    public String toString() {
        return "(!" + this.getChild(0) + ")";
    }

    @Override
    public void toDominionInner(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(CmdFlags.getCtName() + " ");
        stringBuilder.append("not(");
        this.getChild(0).toDominion(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public void toDominionParam(StringBuilder stringBuilder) {
        stringBuilder.append("(!");
        this.getChild(0).toDominionParam(stringBuilder);
        stringBuilder.append(")");
    }

    @Override
    public void toMinizinc(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(not ");
        this.getChild(0).toMinizinc(stringBuilder, true);
        stringBuilder.append(")");
    }

    @Override
    public Long toSATLiteral(Sat sat) {
        if (this.getChild(0) instanceof SATLiteral) {
            return -((SATLiteral)this.getChild(0)).getLit();
        }
        return null;
    }

    @Override
    public void toSAT(Sat sat) throws IOException {
        long l = sat.createAuxSATVariable();
        sat.addClause(String.valueOf(-l));
        this.getChild(0).toSATWithAuxVar(sat, l);
    }

    @Override
    public void toSATWithAuxVar(Sat sat, long l) throws IOException {
        this.getChild(0).toSATWithAuxVar(sat, -l);
    }
}

